/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.PropertiesEditorPlugin;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.util.PropertiesFileUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class ProjectProperties {
    private static ProjectProperties instance = null;
    private Map propertyMap = new HashMap();

    private ProjectProperties() {
    }

    public static ProjectProperties getInstance() {
        if (instance == null) {
            instance = new ProjectProperties();
        }
        return instance;
    }

    public void loadAllProperty(IWorkspace workspace) {
        IProject[] projects = workspace.getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (project.isOpen()) {
                this.loadProjectProperties(project);
            }
            ++i;
        }
    }

    public void deleteProjectProperties(IProject project) {
        this.log("properties removing '" + project.getName() + "'");
        this.propertyMap.remove(project);
    }

    public void loadProjectProperties(IProject project) {
        this.log("properties loading '" + project.getName() + "'");
        if (!project.isOpen()) {
            this.propertyMap.remove(project);
            return;
        }
        IJavaProject jProject = JavaCore.create((IProject)project);
        IPath outputPath = null;
        try {
            outputPath = jProject.getOutputLocation();
        }
        catch (JavaModelException javaModelException) {}
        IFile[] pFiles = PropertiesFileUtil.findFileExt((IContainer)project, outputPath, "properties");
        HashMap<IFile, Properties> list = new HashMap<IFile, Properties>();
        int j = 0;
        while (j < pFiles.length) {
            ILog log;
            Status status;
            Properties prop = new Properties();
            try {
                prop.load(pFiles[j].getContents());
            }
            catch (IOException e) {
                status = new Status(4, PropertiesEditorPlugin.PLUGIN_ID, 0, e.getMessage(), (Throwable)e);
                log = PropertiesEditorPlugin.getDefault().getLog();
                log.log((IStatus)status);
            }
            catch (CoreException e) {
                status = new Status(4, PropertiesEditorPlugin.PLUGIN_ID, 0, e.getMessage(), (Throwable)e);
                log = PropertiesEditorPlugin.getDefault().getLog();
                log.log((IStatus)status);
            }
            list.put(pFiles[j], prop);
            ++j;
        }
        this.propertyMap.put(project, list);
    }

    public Properties getProperty(IProject project) {
        Properties prop = new Properties();
        Map properties = (Map)this.propertyMap.get(project);
        Iterator ite = properties.keySet().iterator();
        while (ite.hasNext()) {
            IFile file = (IFile)ite.next();
            Properties p = (Properties)properties.get(file);
            prop.putAll((Map<?, ?>)p);
        }
        return prop;
    }

    public Map getProperty(IProject project, String key) {
        HashMap<IFile, Properties> list = new HashMap<IFile, Properties>();
        Map properties = (Map)this.propertyMap.get(project);
        Iterator ite = properties.keySet().iterator();
        while (ite.hasNext()) {
            IFile file = (IFile)ite.next();
            Properties p = (Properties)properties.get(file);
            if (!p.containsKey(key)) continue;
            list.put(file, p);
        }
        return list;
    }

    private void log(String msg) {
        Status status = new Status(1, PropertiesEditorPlugin.PLUGIN_ID, 0, msg, null);
        ILog log = PropertiesEditorPlugin.getDefault().getLog();
        log.log((IStatus)status);
    }
}

