/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.Cursor;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.QueryResultIterator;
import com.google.appengine.api.datastore.QueryResultsSource;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionImpl;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QueryResultIteratorImpl
implements QueryResultIterator<Entity> {
    private final PreparedQuery query;
    private final QueryResultsSource resultsSource;
    private final LinkedList<Entity> entityBuffer;
    private final Transaction txn;
    private Cursor lastCursor = null;
    private Cursor nextCursor;
    private int resultsSinceLastCursor = 0;

    QueryResultIteratorImpl(PreparedQuery query, QueryResultsSource resultsSource, FetchOptions fetchOptions, Transaction txn) {
        this.query = query;
        this.resultsSource = resultsSource;
        this.entityBuffer = new LinkedList();
        this.txn = txn;
        if (fetchOptions.getCompile() == Boolean.TRUE) {
            Cursor cursor = this.nextCursor = fetchOptions.getStartCursor() == null ? new Cursor() : new Cursor(fetchOptions.getStartCursor());
            if (fetchOptions.getOffset() != null) {
                this.resultsSinceLastCursor = fetchOptions.getOffset();
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.ensureLoaded();
    }

    @Override
    public Entity next() {
        TransactionImpl.ensureTxnActive(this.txn);
        if (this.ensureLoaded()) {
            ++this.resultsSinceLastCursor;
            return this.entityBuffer.removeFirst();
        }
        throw new NoSuchElementException();
    }

    @Override
    public Cursor getCursor() {
        this.ensureInitialized();
        Cursor cursor = null;
        if (this.entityBuffer.isEmpty()) {
            cursor = this.nextCursor;
        } else if (this.lastCursor != null) {
            this.lastCursor.advance(this.resultsSinceLastCursor, this.query);
            this.resultsSinceLastCursor = 0;
            cursor = this.lastCursor;
        }
        if (cursor != null) {
            return new Cursor(cursor);
        }
        return null;
    }

    public List<Entity> nextList(int maximumElements) {
        TransactionImpl.ensureTxnActive(this.txn);
        this.ensureLoaded(maximumElements);
        int numberToReturn = Math.min(maximumElements, this.entityBuffer.size());
        List backingList = this.entityBuffer.subList(0, numberToReturn);
        ArrayList<Entity> returnList = new ArrayList<Entity>(backingList);
        backingList.clear();
        this.resultsSinceLastCursor += returnList.size();
        return returnList;
    }

    private void saveNextCursor(int bufferSize, Cursor next) {
        if (next != null) {
            this.lastCursor = this.nextCursor;
            this.resultsSinceLastCursor = -bufferSize;
            this.nextCursor = next;
        }
    }

    private void ensureInitialized() {
        this.saveNextCursor(this.entityBuffer.size(), this.resultsSource.loadMoreEntities(0, this.entityBuffer));
    }

    private boolean ensureLoaded() {
        if (this.entityBuffer.isEmpty() && this.resultsSource.hasMoreEntities()) {
            this.saveNextCursor(this.entityBuffer.size(), this.resultsSource.loadMoreEntities(this.entityBuffer));
        }
        return !this.entityBuffer.isEmpty();
    }

    private boolean ensureLoaded(int numberDesired) {
        int numberToLoad = numberDesired - this.entityBuffer.size();
        if (numberToLoad > 0 && this.resultsSource.hasMoreEntities()) {
            this.saveNextCursor(this.entityBuffer.size(), this.resultsSource.loadMoreEntities(numberToLoad, this.entityBuffer));
        }
        return this.entityBuffer.size() >= numberDesired;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int getNumSkipped() {
        this.ensureInitialized();
        return this.resultsSource.getNumSkipped();
    }
}

