/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.Cursor;
import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityTranslator;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.FutureHelper;
import com.google.appengine.api.datastore.QueryResultsSource;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionImpl;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QueryResultsSourceImpl
implements QueryResultsSource {
    private static final int AT_LEAST_ONE = -1;
    private final ApiProxy.ApiConfig apiConfig;
    private final int chunkSize;
    private final int offset;
    private final Transaction txn;
    private Future<DatastorePb.QueryResult> nextResult;
    private int skippedResults;

    public QueryResultsSourceImpl(ApiProxy.ApiConfig apiConfig, FetchOptions fetchOptions, Transaction txn, Future<DatastorePb.QueryResult> firstResult) {
        this.apiConfig = apiConfig;
        this.chunkSize = fetchOptions.getChunkSize() != null ? fetchOptions.getChunkSize() : -1;
        this.offset = fetchOptions.getOffset() != null ? fetchOptions.getOffset() : 0;
        this.txn = txn;
        this.nextResult = firstResult;
        this.skippedResults = -1;
    }

    @Override
    public boolean hasMoreEntities() {
        return this.nextResult != null;
    }

    @Override
    public int getNumSkipped() {
        return this.skippedResults;
    }

    @Override
    public Cursor loadMoreEntities(List<Entity> buffer) {
        return this.loadMoreEntities(-1, buffer);
    }

    @Override
    public Cursor loadMoreEntities(int numberToLoad, List<Entity> buffer) {
        TransactionImpl.ensureTxnActive(this.txn);
        if (this.nextResult != null) {
            if (numberToLoad == 0 && this.offset <= this.skippedResults) {
                return null;
            }
            int previousSize = buffer.size();
            DatastorePb.QueryResult res = FutureHelper.quietGet(this.nextResult);
            this.nextResult = null;
            this.processQueryResult(res, buffer);
            if (res.isMoreResults()) {
                DatastorePb.NextRequest req = new DatastorePb.NextRequest();
                req.getMutableCursor().copyFrom(res.getCursor());
                if (res.hasCompiledCursor()) {
                    req.setCompile(true);
                }
                boolean setCount = true;
                if (numberToLoad <= 0) {
                    setCount = false;
                    if (this.chunkSize != -1) {
                        req.setCount(this.chunkSize);
                    }
                    if (numberToLoad == -1) {
                        numberToLoad = 1;
                    }
                }
                while ((this.skippedResults < this.offset || buffer.size() - previousSize < numberToLoad) && res.isMoreResults()) {
                    if (this.skippedResults < this.offset) {
                        req.setOffset(this.offset - this.skippedResults);
                    } else {
                        req.clearOffset();
                    }
                    if (setCount) {
                        req.setCount(Math.max(this.chunkSize, numberToLoad - buffer.size() + previousSize));
                    }
                    res = new DatastorePb.QueryResult();
                    DatastoreApiHelper.makeSyncCall(this.apiConfig, "Next", req, res);
                    this.processQueryResult(res, buffer);
                }
                if (res.isMoreResults()) {
                    if (this.chunkSize != -1) {
                        req.setCount(this.chunkSize);
                    } else {
                        req.clearCount();
                    }
                    req.clearOffset();
                    this.nextResult = DatastoreApiHelper.makeAsyncCall(this.apiConfig, "Next", req, new DatastorePb.QueryResult());
                }
            }
            return res.hasCompiledCursor() ? new Cursor(res.getCompiledCursor()) : null;
        }
        return null;
    }

    private void processQueryResult(DatastorePb.QueryResult res, List<Entity> buffer) {
        if (this.skippedResults < 0) {
            this.skippedResults = 0;
        } else if (res.getSkippedResults() <= 0 && res.resultSize() <= 0) {
            res.setMoreResults(false);
            return;
        }
        this.skippedResults += res.getSkippedResults();
        for (OnestoreEntity.EntityProto entityProto : res.results()) {
            buffer.add(EntityTranslator.createFromPb(entityProto));
        }
    }
}

