/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import jp.gr.java_conf.ussiy.app.propedit.BaseDialog;
import jp.gr.java_conf.ussiy.swing.JExtendedPopupComboBox;

public class JFontChooserDialog
extends BaseDialog {
    static ResourceBundle res = ResourceBundle.getBundle("lang");
    public static final int CANCEL_OPTION = 1;
    public static final int ERROR_OPTION = -1;
    public static final int APPROVE_OPTION = 0;
    private int returnValue = -1;
    private JPanel panel1 = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel jPanel1 = new JPanel();
    private JPanel jPanel2 = new JPanel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private JPanel jPanel3 = new JPanel();
    private JPanel jPanel4 = new JPanel();
    private JLabel jLabel1 = new JLabel();
    private JComboBox fontNameComboBox = new JExtendedPopupComboBox();
    private JLabel jLabel2 = new JLabel();
    private JComboBox styleComboBox = new JExtendedPopupComboBox();
    private JLabel jLabel3 = new JLabel();
    private JComboBox sizeComboBox = new JExtendedPopupComboBox();
    private JLabel charaColorLabel = new JLabel();
    private JButton selectForegroundButton = new JButton();
    private JPanel jPanel5 = new JPanel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private Border border1;
    private TitledBorder titledBorder1;
    private BorderLayout borderLayout3 = new BorderLayout();
    private String[] fontNameList;
    private static Font defaultFont = new Font("Dialog", 0, 10);
    private static Color defaultForegroundColor = Color.BLACK;
    private static Color defaultBackgroundColor = Color.WHITE;
    private static final String[] fontSizeList = new String[]{"7", "8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
    private static final int[] fontStyleCodeList;
    private JLabel backgroundColorLabel = new JLabel();
    private JButton selectBackgroundButton = new JButton();
    private JPanel buttonPanel = new JPanel();
    private JButton cancelButton = new JButton();
    private JButton setButton = new JButton();
    private FlowLayout flowLayout1 = new FlowLayout();
    JTextField sampleTextField = new JTextField();

    static {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        fontStyleCodeList = nArray;
    }

    public JFontChooserDialog(Frame frame, boolean modal) {
        this(frame, defaultFont, defaultForegroundColor, defaultBackgroundColor, modal);
    }

    public JFontChooserDialog(Frame frame, Font selectFont, Color selectForegroundColor, Color selectBackgroundColor, boolean modal) {
        super(frame, res.getString("fontchooser_title"), modal);
        defaultFont = selectFont;
        defaultForegroundColor = selectForegroundColor;
        defaultBackgroundColor = selectBackgroundColor;
        try {
            this.jbInit();
            this.initialize();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142));
        this.titledBorder1 = new TitledBorder(this.border1, res.getString("sample_titled_border"));
        this.panel1.setLayout(this.borderLayout1);
        this.jPanel2.setLayout(this.borderLayout2);
        this.jLabel1.setText(res.getString("font_name"));
        this.jLabel2.setText(res.getString("style_name"));
        this.jLabel3.setText(res.getString("font_size"));
        this.charaColorLabel.setOpaque(true);
        this.charaColorLabel.setPreferredSize(new Dimension(50, 26));
        this.charaColorLabel.setHorizontalAlignment(0);
        this.charaColorLabel.setText(res.getString("font_color"));
        this.selectForegroundButton.setText(res.getString("selectForegroundButton_text"));
        this.selectForegroundButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFontChooserDialog.this.selectForegroundButton_actionPerformed(e);
            }
        });
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.jPanel5.setBorder(this.titledBorder1);
        this.jPanel5.setLayout(this.borderLayout3);
        this.sampleTextField.setText(res.getString("sample_character"));
        this.panel1.setMinimumSize(new Dimension(300, 200));
        this.jPanel1.setPreferredSize(new Dimension(300, 120));
        this.fontNameComboBox.setPreferredSize(new Dimension(100, 18));
        this.fontNameComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFontChooserDialog.this.fontNameComboBox_actionPerformed(e);
            }
        });
        this.styleComboBox.setMinimumSize(new Dimension(23, 18));
        this.styleComboBox.setPreferredSize(new Dimension(70, 18));
        this.styleComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFontChooserDialog.this.styleComboBox_actionPerformed(e);
            }
        });
        this.sizeComboBox.setMinimumSize(new Dimension(23, 18));
        this.sizeComboBox.setPreferredSize(new Dimension(50, 18));
        this.sizeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFontChooserDialog.this.sizeComboBox_actionPerformed(e);
            }
        });
        this.backgroundColorLabel.setOpaque(true);
        this.backgroundColorLabel.setPreferredSize(new Dimension(50, 26));
        this.backgroundColorLabel.setHorizontalAlignment(0);
        this.backgroundColorLabel.setHorizontalTextPosition(11);
        this.backgroundColorLabel.setText(res.getString("backgroundColorLabel_bgcolor"));
        this.selectBackgroundButton.setText(res.getString("selectBackgroundButton_text"));
        this.selectBackgroundButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFontChooserDialog.this.selectBackgroundButton_actionPerformed(e);
            }
        });
        this.cancelButton.setText(res.getString("cancelButton_text"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFontChooserDialog.this.cancelButton_actionPerformed(e);
            }
        });
        this.setButton.setText(res.getString("setButton_text"));
        this.setButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFontChooserDialog.this.setButton_actionPerformed(e);
            }
        });
        this.buttonPanel.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(2);
        this.flowLayout1.setHgap(5);
        this.jPanel4.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel3.setBorder(null);
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jPanel5, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 4, 4, 4), 390, 219));
        this.jPanel5.add((Component)this.sampleTextField, "Center");
        this.panel1.add((Component)this.jPanel2, "North");
        this.jPanel2.add((Component)this.jPanel3, "South");
        this.jPanel3.add((Component)this.charaColorLabel, null);
        this.jPanel3.add((Component)this.selectForegroundButton, null);
        this.jPanel3.add((Component)this.backgroundColorLabel, null);
        this.jPanel3.add((Component)this.selectBackgroundButton, null);
        this.jPanel2.add((Component)this.jPanel4, "North");
        this.jPanel4.add((Component)this.jLabel1, null);
        this.jPanel4.add((Component)this.fontNameComboBox, null);
        this.jPanel4.add((Component)this.jLabel2, null);
        this.jPanel4.add((Component)this.styleComboBox, null);
        this.jPanel4.add((Component)this.jLabel3, null);
        this.jPanel4.add((Component)this.sizeComboBox, null);
        this.panel1.add((Component)this.buttonPanel, "South");
        this.buttonPanel.add((Component)this.setButton, null);
        this.buttonPanel.add((Component)this.cancelButton, null);
    }

    private String getFontStyleStringByFontStyleCode(int style) {
        switch (style) {
            case 0: {
                return "Plain";
            }
            case 1: {
                return "Bold";
            }
            case 2: {
                return "Italic";
            }
            case 3: {
                return "Bold Italic";
            }
        }
        return null;
    }

    private int getFontStyleCodeByFontStyleString(String style) {
        if (style == null) {
            return -1;
        }
        if (style.equals("Plain")) {
            return 0;
        }
        if (style.equals("Bold")) {
            return 1;
        }
        if (style.equals("Italic")) {
            return 2;
        }
        if (style.equals("Bold Italic")) {
            return 3;
        }
        return -1;
    }

    private void initialize() {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.fontNameList = env.getAvailableFontFamilyNames();
        int i = 0;
        while (i < this.fontNameList.length) {
            this.fontNameComboBox.addItem(this.fontNameList[i]);
            ++i;
        }
        i = 0;
        while (i < fontStyleCodeList.length) {
            this.styleComboBox.addItem(this.getFontStyleStringByFontStyleCode(fontStyleCodeList[i]));
            ++i;
        }
        i = 0;
        while (i < fontSizeList.length) {
            this.sizeComboBox.addItem(fontSizeList[i]);
            ++i;
        }
        this.fontNameComboBox.setSelectedItem(defaultFont.getFamily());
        this.styleComboBox.setSelectedItem(this.getFontStyleStringByFontStyleCode(defaultFont.getStyle()));
        this.sizeComboBox.setSelectedItem(Integer.toString(defaultFont.getSize()));
        this.sampleTextField.setFont(defaultFont);
        this.sampleTextField.setForeground(defaultForegroundColor);
        this.sampleTextField.setBackground(defaultBackgroundColor);
        this.backgroundColorLabel.setBackground(defaultBackgroundColor);
        this.charaColorLabel.setForeground(defaultForegroundColor);
    }

    public Font getSelectedFont() {
        String fontName = (String)this.fontNameComboBox.getSelectedItem();
        int fontStyle = this.getFontStyleCodeByFontStyleString((String)this.styleComboBox.getSelectedItem());
        int fontSize = Integer.parseInt((String)this.sizeComboBox.getSelectedItem());
        return new Font(fontName, fontStyle, fontSize);
    }

    private void fontNameComboBox_actionPerformed(ActionEvent e) {
        Font f = this.sampleTextField.getFont();
        Font newFont = new Font((String)this.fontNameComboBox.getSelectedItem(), f.getStyle(), f.getSize());
        this.sampleTextField.setFont(newFont);
    }

    private void styleComboBox_actionPerformed(ActionEvent e) {
        Font f = this.sampleTextField.getFont();
        Font newFont = new Font(f.getFontName(), this.getFontStyleCodeByFontStyleString((String)this.styleComboBox.getSelectedItem()), f.getSize());
        this.sampleTextField.setFont(newFont);
    }

    private void sizeComboBox_actionPerformed(ActionEvent e) {
        Font f = this.sampleTextField.getFont();
        Font newFont = new Font(f.getFontName(), f.getStyle(), Integer.parseInt((String)this.sizeComboBox.getSelectedItem()));
        this.sampleTextField.setFont(newFont);
    }

    private void selectForegroundButton_actionPerformed(ActionEvent e) {
        Color selectedColor = JColorChooser.showDialog(this, res.getString("colorchooser_title"), defaultForegroundColor);
        if (selectedColor == null) {
            return;
        }
        defaultForegroundColor = selectedColor;
        this.charaColorLabel.setForeground(defaultForegroundColor);
        this.sampleTextField.setForeground(defaultForegroundColor);
    }

    private void selectBackgroundButton_actionPerformed(ActionEvent e) {
        Color selectedColor = JColorChooser.showDialog(this, res.getString("colorchooser_title"), defaultBackgroundColor);
        if (selectedColor == null) {
            return;
        }
        defaultBackgroundColor = selectedColor;
        this.backgroundColorLabel.setBackground(defaultBackgroundColor);
        this.sampleTextField.setBackground(defaultBackgroundColor);
    }

    public Color getForgroundColor() {
        return defaultForegroundColor;
    }

    public Color getBackgroundColor() {
        return defaultBackgroundColor;
    }

    private void cancelButton_actionPerformed(ActionEvent e) {
        this.returnValue = 1;
        this.dispose();
    }

    private void setButton_actionPerformed(ActionEvent e) {
        this.returnValue = 0;
        this.dispose();
    }

    public int getReturnValue() {
        return this.returnValue;
    }
}

