/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.jdt.hover;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.PropertiesEditorPlugin;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.resources.Messages;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.util.ProjectProperties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.ui.text.java.hover.IJavaEditorTextHover;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class PropertiesHover
implements IJavaEditorTextHover,
ITextHoverExtension {
    private IEditorPart editorPart;

    public void setEditor(IEditorPart editorPart) {
        this.editorPart = editorPart;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion region) {
        int endIdx;
        int startIdx;
        block11: {
            IDocument document = textViewer.getDocument();
            int offset = region.getOffset();
            try {
                int lineNum = document.getLineOfOffset(offset);
                int lineOffset = document.getLineOffset(lineNum);
                int lineLength = document.getLineLength(lineNum);
                String source = document.get();
                startIdx = -1;
                int tmp = offset - 1;
                while (tmp >= lineOffset) {
                    if ((tmp = source.lastIndexOf("\"", tmp)) < lineOffset) {
                        startIdx = -1;
                        break;
                    }
                    if (tmp > 0) {
                        if (document.getChar(tmp - 1) == '\\') continue;
                        startIdx = tmp + 1;
                        break;
                    }
                    if (tmp == 0) {
                        startIdx = 1;
                        break;
                    }
                    startIdx = -1;
                    break;
                }
                tmp = offset + 1;
                endIdx = -1;
                while (tmp < lineOffset + lineLength) {
                    if ((tmp = source.indexOf("\"", tmp)) > lineOffset + lineLength) {
                        endIdx = -1;
                        break;
                    }
                    if (tmp > 0) {
                        if (document.getChar(tmp - 1) == '\\') continue;
                        endIdx = tmp;
                        break;
                    }
                    if (tmp == 0) {
                        endIdx = 0;
                        break;
                    }
                    endIdx = -1;
                    break;
                }
                if (startIdx != -1 && endIdx != -1 && startIdx != endIdx) break block11;
                return null;
            }
            catch (BadLocationException e) {
                Status status = new Status(4, PropertiesEditorPlugin.PLUGIN_ID, 0, e.getMessage(), (Throwable)e);
                ILog log = PropertiesEditorPlugin.getDefault().getLog();
                log.log((IStatus)status);
                return null;
            }
        }
        String key = textViewer.getDocument().get(startIdx, endIdx - startIdx);
        return this.getPropertyValue(key);
    }

    private String getPropertyValue(String targetKey) {
        if (targetKey == null || targetKey.equals("")) {
            return "";
        }
        IEditorInput editorInput = this.editorPart.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fEditorInput = (IFileEditorInput)editorInput;
            IProject project = fEditorInput.getFile().getProject();
            Map propertyMap = ProjectProperties.getInstance().getProperty(project, targetKey);
            if (propertyMap.isEmpty()) {
                return null;
            }
            Iterator ite = propertyMap.keySet().iterator();
            StringBuffer buf = new StringBuffer();
            while (ite.hasNext()) {
                IFile file = (IFile)ite.next();
                String path = file.getFullPath().toPortableString();
                String value = ((Properties)propertyMap.get(file)).getProperty(targetKey);
                buf.append("< ").append(Messages.getString("eclipse.propertieseditor.hover.file")).append(path).append(" >\n");
                buf.append(value).append("\n");
            }
            return buf.toString();
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent);
            }
        };
    }
}

