/*
 * Decompiled with CFR 0.152.
 */
package org.slim3.gen.desc;

import org.slim3.gen.Constants;
import org.slim3.gen.desc.ControllerDesc;
import org.slim3.gen.util.ClassUtil;
import org.slim3.gen.util.StringUtil;

public class ControllerDescFactory {
    protected final String packageName;
    protected final String superclassName;
    protected final String testCaseSuperclassName;
    protected final boolean useView;

    public ControllerDescFactory(String packageName, String superclassName, String testCaseSuperclassName, boolean useView) {
        if (packageName == null) {
            throw new NullPointerException("The packageName parameter is null.");
        }
        if (superclassName == null) {
            throw new NullPointerException("The superclassName parameter is null.");
        }
        if (testCaseSuperclassName == null) {
            throw new NullPointerException("The testCaseSuperclassName parameter is null.");
        }
        this.packageName = packageName;
        this.superclassName = superclassName;
        this.testCaseSuperclassName = testCaseSuperclassName;
        this.useView = useView;
    }

    public ControllerDesc createControllerDesc(String path) {
        if (path == null) {
            throw new NullPointerException("The path parameter is null.");
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("The path does not start with '/'.");
        }
        ControllerDesc controllerDesc = new ControllerDesc();
        controllerDesc.setSuperclassName(this.superclassName);
        controllerDesc.setTestCaseSuperclassName(this.testCaseSuperclassName);
        String className = this.toControllerClassName(path);
        controllerDesc.setPackageName(ClassUtil.getPackageName(className));
        controllerDesc.setSimpleName(ClassUtil.getSimpleName(className));
        controllerDesc.setViewName(this.toViewName(path));
        controllerDesc.setPath(path);
        controllerDesc.setUseView(this.useView);
        return controllerDesc;
    }

    protected String toControllerClassName(String path) {
        String className = this.packageName + path.replace('/', '.');
        if (className.endsWith(".")) {
            className = className + Constants.INDEX_CONTROLLER;
        } else {
            int pos = className.lastIndexOf(46);
            className = className.substring(0, pos + 1) + StringUtil.capitalize(className.substring(pos + 1)) + "Controller";
        }
        return className;
    }

    protected String toViewName(String path) {
        String viewName = path;
        viewName = path.endsWith("/") ? viewName + "index.jsp" : viewName + ".jsp";
        return viewName;
    }
}

