/*
 * Decompiled with CFR 0.152.
 */
package org.slim3.gen.generator;

import org.slim3.gen.desc.ModelDesc;
import org.slim3.gen.generator.Generator;
import org.slim3.gen.printer.Printer;
import org.slim3.gen.util.ClassUtil;

public class ModelGenerator
implements Generator {
    protected final ModelDesc modelDesc;

    public ModelGenerator(ModelDesc modelDesc) {
        if (modelDesc == null) {
            throw new NullPointerException("The modelDesc parameter is null.");
        }
        this.modelDesc = modelDesc;
    }

    public void generate(Printer p) {
        if (this.modelDesc.getPackageName().length() != 0) {
            p.println("package %s;", this.modelDesc.getPackageName());
            p.println();
        }
        p.println("import java.io.Serializable;", new Object[0]);
        p.println();
        if ("java.lang.Object".equals(this.modelDesc.getSuperclassName())) {
            p.println("import com.google.appengine.api.datastore.Key;", new Object[0]);
            p.println();
            p.println("import org.slim3.datastore.Attribute;", new Object[0]);
            p.println("import org.slim3.datastore.Model;", new Object[0]);
        } else {
            p.println("import org.slim3.datastore.Model;", new Object[0]);
            p.println();
            p.println("import %s;", this.modelDesc.getSuperclassName());
        }
        p.println();
        p.println("@Model(%1$s = 1)", "schemaVersion");
        if ("java.lang.Object".equals(this.modelDesc.getSuperclassName())) {
            p.println("public class %s implements Serializable {", this.modelDesc.getSimpleName());
        } else {
            p.println("public class %s extends %s implements Serializable {", this.modelDesc.getSimpleName(), ClassUtil.getSimpleName(this.modelDesc.getSuperclassName()));
        }
        p.println();
        p.println("    private static final long serialVersionUID = 1L;", new Object[0]);
        p.println();
        if ("java.lang.Object".equals(this.modelDesc.getSuperclassName())) {
            p.println("    @Attribute(primaryKey = true)", new Object[0]);
            p.println("    private Key key;", new Object[0]);
            p.println();
            p.println("    @Attribute(version = true)", new Object[0]);
            p.println("    private Long version;", new Object[0]);
            p.println();
            p.println("    /**", new Object[0]);
            p.println("     * Returns the key.", new Object[0]);
            p.println("     *", new Object[0]);
            p.println("     * @return the key", new Object[0]);
            p.println("     */", new Object[0]);
            p.println("    public Key getKey() {", new Object[0]);
            p.println("        return key;", new Object[0]);
            p.println("    }", new Object[0]);
            p.println();
            p.println("    /**", new Object[0]);
            p.println("     * Sets the key.", new Object[0]);
            p.println("     *", new Object[0]);
            p.println("     * @param key", new Object[0]);
            p.println("     *            the key", new Object[0]);
            p.println("     */", new Object[0]);
            p.println("    public void setKey(Key key) {", new Object[0]);
            p.println("        this.key = key;", new Object[0]);
            p.println("    }", new Object[0]);
            p.println();
            p.println("    /**", new Object[0]);
            p.println("     * Returns the version.", new Object[0]);
            p.println("     *", new Object[0]);
            p.println("     * @return the version", new Object[0]);
            p.println("     */", new Object[0]);
            p.println("    public Long getVersion() {", new Object[0]);
            p.println("        return version;", new Object[0]);
            p.println("    }", new Object[0]);
            p.println();
            p.println("    /**", new Object[0]);
            p.println("     * Sets the version.", new Object[0]);
            p.println("     *", new Object[0]);
            p.println("     * @param version", new Object[0]);
            p.println("     *            the version", new Object[0]);
            p.println("     */", new Object[0]);
            p.println("    public void setVersion(Long version) {", new Object[0]);
            p.println("        this.version = version;", new Object[0]);
            p.println("    }", new Object[0]);
            p.println();
            p.println("    @Override", new Object[0]);
            p.println("    public int hashCode() {", new Object[0]);
            p.println("        final int prime = 31;", new Object[0]);
            p.println("        int result = 1;", new Object[0]);
            p.println("        result = prime * result + ((key == null) ? 0 : key.hashCode());", new Object[0]);
            p.println("        return result;", new Object[0]);
            p.println("    }", new Object[0]);
            p.println();
            p.println("    @Override", new Object[0]);
            p.println("    public boolean equals(Object obj) {", new Object[0]);
            p.println("        if (this == obj) {", new Object[0]);
            p.println("            return true;", new Object[0]);
            p.println("        }", new Object[0]);
            p.println("        if (obj == null) {", new Object[0]);
            p.println("            return false;", new Object[0]);
            p.println("        }", new Object[0]);
            p.println("        if (getClass() != obj.getClass()) {", new Object[0]);
            p.println("            return false;", new Object[0]);
            p.println("        }", new Object[0]);
            p.println("        %1$s other = (%1$s) obj;", this.modelDesc.getSimpleName());
            p.println("        if (key == null) {", new Object[0]);
            p.println("            if (other.key != null) {", new Object[0]);
            p.println("                return false;", new Object[0]);
            p.println("            }", new Object[0]);
            p.println("        } else if (!key.equals(other.key)) {", new Object[0]);
            p.println("            return false;", new Object[0]);
            p.println("        }", new Object[0]);
            p.println("        return true;", new Object[0]);
            p.println("    }", new Object[0]);
        }
        p.println("}", new Object[0]);
    }
}

