/*
 * Decompiled with CFR 0.152.
 */
package org.slim3.gen.generator;

import org.slim3.gen.desc.ServiceDesc;
import org.slim3.gen.generator.Generator;
import org.slim3.gen.printer.Printer;
import org.slim3.gen.util.ClassUtil;

public class ServiceTestCaseGenerator
implements Generator {
    protected final ServiceDesc serviceDesc;

    public ServiceTestCaseGenerator(ServiceDesc serviceDesc) {
        if (serviceDesc == null) {
            throw new NullPointerException("The serviceDesc parameter is null.");
        }
        this.serviceDesc = serviceDesc;
    }

    public void generate(Printer p) {
        if (this.serviceDesc.getPackageName().length() != 0) {
            p.println("package %s;", this.serviceDesc.getPackageName());
            p.println();
        }
        if (!"java.lang.Object".equals(this.serviceDesc.getTestCaseSuperclassName())) {
            p.println("import %s;", this.serviceDesc.getTestCaseSuperclassName());
        }
        p.println("import %s;", "org.junit.Test");
        p.println("import static %s.*;", "org.junit.Assert");
        p.println("import static %s.*;", "org.hamcrest.CoreMatchers");
        p.println();
        p.print("public class %s%s", this.serviceDesc.getSimpleName(), "Test");
        if (!"java.lang.Object".equals(this.serviceDesc.getTestCaseSuperclassName())) {
            p.print(" extends %s", ClassUtil.getSimpleName(this.serviceDesc.getTestCaseSuperclassName()));
        }
        p.println(" {", new Object[0]);
        p.println();
        p.println("    private %1$s service = new %1$s();", this.serviceDesc.getSimpleName());
        p.println();
        p.println("    @%s", ClassUtil.getSimpleName("org.junit.Test"));
        p.println("    public void test() throws Exception {", new Object[0]);
        p.println("        assertThat(service, is(notNullValue()));", new Object[0]);
        p.println("    }", new Object[0]);
        p.println("}", new Object[0]);
    }
}

