/*
 * Decompiled with CFR 0.152.
 */
package org.slim3.gen.util;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.type.AnnotationType;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationMirrorUtil {
    public static <T> T getElementValue(AnnotationMirror anno, String name) {
        if (anno == null) {
            return null;
        }
        if (name == null) {
            return null;
        }
        Map elementValues = anno.getElementValues();
        for (AnnotationTypeElementDeclaration element : elementValues.keySet()) {
            if (!element.getSimpleName().equals(name)) continue;
            AnnotationValue v = (AnnotationValue)elementValues.get(element);
            return (T)(v != null ? v.getValue() : null);
        }
        return null;
    }

    public static <T> T getElementValueWithDefault(AnnotationMirror anno, String name) {
        if (anno == null) {
            return null;
        }
        if (name == null) {
            return null;
        }
        Map<String, AnnotationValue> elementValues = AnnotationMirrorUtil.getElementValuesWithDefault(anno);
        for (Map.Entry<String, AnnotationValue> entry : elementValues.entrySet()) {
            String elementName = entry.getKey();
            AnnotationValue value = entry.getValue();
            if (!elementName.equals(name)) continue;
            return (T)(value != null ? value.getValue() : null);
        }
        return null;
    }

    private static Map<String, AnnotationValue> getElementValuesWithDefault(AnnotationMirror anno) {
        HashMap<String, AnnotationValue> results = new HashMap<String, AnnotationValue>(AnnotationMirrorUtil.getElementDefaultValues(anno));
        for (Map.Entry entry : anno.getElementValues().entrySet()) {
            results.put(((AnnotationTypeElementDeclaration)entry.getKey()).getSimpleName(), (AnnotationValue)entry.getValue());
        }
        return results;
    }

    private static Map<String, AnnotationValue> getElementDefaultValues(AnnotationMirror anno) {
        HashMap<String, AnnotationValue> results = new HashMap<String, AnnotationValue>();
        AnnotationType annoType = anno.getAnnotationType();
        if (annoType == null) {
            return results;
        }
        AnnotationTypeDeclaration annoTypeDeclaration = annoType.getDeclaration();
        if (annoTypeDeclaration == null) {
            return results;
        }
        for (AnnotationTypeElementDeclaration element : annoTypeDeclaration.getMethods()) {
            results.put(element.getSimpleName(), element.getDefaultValue());
        }
        return results;
    }
}

