/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.hyperlink;

import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors.detector.IHyperlinkDetector;
import jp.gr.java_conf.ussiy.app.propedit.hyperlink.Activator;
import jp.gr.java_conf.ussiy.app.propedit.hyperlink.Messages;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertyKeyHyperlink;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class PropertiesHyperlinkDetector
implements IHyperlinkDetector {
    private ITextEditor editor;

    public void setTextEditor(ITextEditor editor) {
        this.editor = editor;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer viewer, IRegion region, boolean canMulti) {
        int endPos;
        int lineTopIdx;
        IDocument document;
        block18: {
            block17: {
                char c2;
                char c1;
                block16: {
                    IStorageEditorInput editorInput = (IStorageEditorInput)this.editor.getEditorInput();
                    document = this.editor.getDocumentProvider().getDocument((Object)editorInput);
                    int lineNum = document.getLineOfOffset(region.getOffset());
                    endPos = lineTopIdx = document.getLineOffset(lineNum);
                    if (endPos - 2 < 0) break block16;
                    c1 = document.getChar(endPos - 2);
                    c2 = document.getChar(endPos - 1);
                    if (c1 == '\\' && (c2 == '\r' || c2 == '\n')) {
                        return null;
                    }
                    break block17;
                }
                if (endPos - 3 < 0) break block17;
                c1 = document.getChar(endPos - 3);
                c2 = document.getChar(endPos - 2);
                char c3 = document.getChar(endPos - 1);
                if (c1 != '\\' || c2 != '\r' || c3 != '\n') break block17;
                return null;
            }
            char c = document.getChar(endPos);
            if (c != '#' && c != '!') break block18;
            return null;
        }
        try {
            boolean escapeFlg = false;
            boolean spaceFlg = true;
            int beforeChar = 0;
            int beforeBeforeChar = 0;
            while (endPos < document.getLength()) {
                char c = document.getChar(endPos);
                if (c == '\\') {
                    escapeFlg = !escapeFlg;
                    ++endPos;
                    continue;
                }
                if (c == ' ' || c == '\t') {
                    if (spaceFlg) {
                        ++endPos;
                        continue;
                    }
                } else {
                    spaceFlg = false;
                }
                if (c == '=' || c == '\r' || c == '\n' || c == '\t' || c == ' ' || c == ':') {
                    if (!escapeFlg) {
                        if (beforeBeforeChar != 92 || beforeChar != 13 || c != '\n') {
                            break;
                        }
                    } else {
                        escapeFlg = !escapeFlg;
                    }
                } else {
                    escapeFlg = false;
                }
                beforeBeforeChar = beforeChar;
                beforeChar = c;
                ++endPos;
            }
            int length = endPos - lineTopIdx;
            String tmp = document.get(lineTopIdx, length);
            String key = tmp.trim();
            int offset = tmp.indexOf(key);
            PropertyKeyHyperlink[] hyperlinks = new PropertyKeyHyperlink[]{new PropertyKeyHyperlink((IRegion)new Region(lineTopIdx + offset, key.length()), key, this.editor)};
            return hyperlinks;
        }
        catch (BadLocationException e) {
            Status status = new Status(4, "jp.gr.java_conf.ussiy.app.propedit.hyperlink", 0, e.getMessage(), (Throwable)e);
            ILog log = Activator.getDefault().getLog();
            log.log((IStatus)status);
            ErrorDialog.openError(null, (String)Messages.getString("PropertiesHyperlinkDetector.1"), (String)Messages.getString("PropertiesHyperlinkDetector.2"), (IStatus)status);
            return null;
        }
    }
}

