/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc;

import com.google.cloud.sql.jdbc.Connection;
import com.google.cloud.sql.jdbc.PreparedStatement;
import com.google.cloud.sql.jdbc.internal.BoundValue;
import com.google.cloud.sql.jdbc.internal.DataTypeConverters;
import com.google.cloud.sql.jdbc.internal.Exceptions;
import com.google.cloud.sql.jdbc.internal.JdbcType;
import com.google.cloud.sql.jdbc.internal.Url;
import com.google.cloud.sql.jdbc.internal.Util;
import com.google.protos.cloud.sql.Client;
import com.google.protos.cloud.sql.ExecRequest;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CallableStatement
extends PreparedStatement
implements java.sql.CallableStatement {
    private boolean lastOutParameterWasNull;

    CallableStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, Connection conn, Url url) {
        super(sql, resultSetType, resultSetConcurrency, resultSetHoldability, conn, url);
        this.rpcOptions.setStatementType(ExecRequest.StatementType.CALLABLE_STATEMENT);
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        return this.getOutValue(parameterIndex, BigDecimal.class);
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        return this.getBigDecimal(parameterIndex).setScale(scale);
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        return this.getOutValue(parameterIndex, Blob.class);
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        return this.getOutValue(parameterIndex, Boolean.class);
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        return this.getOutValue(parameterIndex, Byte.class);
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        return this.getOutValue(parameterIndex, byte[].class);
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        return this.getOutValue(parameterIndex, Clob.class);
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        return this.getOutValue(parameterIndex, Date.class);
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        return this.getOutValue(parameterIndex, Double.class);
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        return this.getOutValue(parameterIndex, Float.class).floatValue();
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        return this.getOutValue(parameterIndex, Integer.class);
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        return this.getOutValue(parameterIndex, Long.class);
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        Client.BindVariableProto variable = this.lookupOutBindVariable(parameterIndex);
        boolean bl = this.lastOutParameterWasNull = !variable.hasValue();
        if (this.lastOutParameterWasNull) {
            return null;
        }
        JdbcType jdbcType = JdbcType.fromCode(variable.getType());
        return jdbcType.getConverter().toObject(variable.getValue());
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        return this.getOutValue(parameterIndex, Short.class);
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        return this.getOutValue(parameterIndex, String.class);
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        return this.getOutValue(parameterIndex, Time.class);
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        return this.getOutValue(parameterIndex, Timestamp.class);
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        throw Exceptions.newNotYetImplementedException();
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.throwIfNotOpen();
        this.bindParameter(parameterIndex, BoundValue.nullValue(JdbcType.fromCode(sqlType), Client.BindVariableProto.Direction.OUT));
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        throw Exceptions.newNotYetImplementedException("Registering output parameter with scale is not implemented yet.");
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.throwIfNotOpen();
        this.registerOutParameter(parameterIndex, sqlType);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.throwIfNotOpen();
        return this.lastOutParameterWasNull;
    }

    @Override
    void bindParameter(int parameterIndex, BoundValue typedValue) throws SQLException {
        BoundValue previous;
        if (typedValue.getDirection() == Client.BindVariableProto.Direction.OUT) {
            Util.checkParameter(typedValue.isNull(), "Output parameter @ index {0} is not null", parameterIndex);
        }
        if ((previous = this.getBindParametersMap().get(parameterIndex)) == null) {
            super.bindParameter(parameterIndex, typedValue);
            return;
        }
        Util.checkParameter(previous.getDataType() == typedValue.getDataType(), "Found inconsistent type for parameter {0}", parameterIndex);
        if (previous.getDirection() == Client.BindVariableProto.Direction.IN && typedValue.getDirection() == Client.BindVariableProto.Direction.OUT) {
            super.bindParameter(parameterIndex, BoundValue.of(previous.getValue(), previous.getDataType(), Client.BindVariableProto.Direction.INOUT));
        } else {
            super.bindParameter(parameterIndex, typedValue);
        }
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        throw Exceptions.newNamedParameterNotYetImplementedException();
    }

    private <C> C getOutValue(int parameterIndex, Class<C> clazz) throws SQLException {
        Client.BindVariableProto variable = this.lookupOutBindVariable(parameterIndex);
        this.lastOutParameterWasNull = !variable.hasValue();
        return DataTypeConverters.getConverter(clazz).toObject(variable.getValue());
    }

    private Client.BindVariableProto lookupOutBindVariable(int parameterIndex) throws SQLException {
        this.throwIfNotOpen();
        Client.BindVariableProto variable = (Client.BindVariableProto)this.outParametersMap.get(parameterIndex);
        if (variable == null) {
            throw Exceptions.newSqlException("No out parameter at index " + parameterIndex);
        }
        return variable;
    }
}

