/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc.internal;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.cloud.sql.jdbc.internal.BoundValue;
import com.google.cloud.sql.jdbc.internal.SqlClient;
import com.google.cloud.sql.jdbc.internal.SqlRpcOptions;
import com.google.cloud.sql.jdbc.internal.Url;
import com.google.cloud.sql.jdbc.internal.Util;
import com.google.protos.cloud.sql.Client;
import com.google.protos.cloud.sql.CloseConnectionRequest;
import com.google.protos.cloud.sql.ExecOpRequest;
import com.google.protos.cloud.sql.ExecRequest;
import com.google.protos.cloud.sql.MetadataRequest;
import com.google.protos.cloud.sql.OpenConnectionRequest;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSqlClient
implements SqlClient {
    private final String instance;

    protected AbstractSqlClient(String instance) {
        if (instance == null || instance.isEmpty()) {
            throw new IllegalArgumentException("invalid instance: (" + instance + ").");
        }
        this.instance = Util.makeSafe(instance);
    }

    protected String getInstance() {
        return this.instance;
    }

    protected ExecRequest createExecRequest(SqlRpcOptions options, ByteString connectionId, String sql, List<BoundValue> bindParameters) throws SQLException {
        ExecRequest.Builder request = this.createExecRequestBuilder(options, connectionId, sql);
        for (Client.BindVariableProto.Builder b : this.bindParameterBuildersFor(bindParameters)) {
            request.addBindVariable(b);
        }
        return request.build();
    }

    protected ExecRequest createBatchExecRequest(SqlRpcOptions options, ByteString connectionId, String sql, List<List<BoundValue>> batchBindParameters) throws SQLException {
        ExecRequest.Builder request = this.createExecRequestBuilder(options, connectionId, sql);
        Client.BatchProto.Builder batch = Client.BatchProto.newBuilder();
        for (List<BoundValue> bindParameters : batchBindParameters) {
            Client.BatchBindVariableProto.Builder bbv = Client.BatchBindVariableProto.newBuilder();
            for (Client.BindVariableProto.Builder b : this.bindParameterBuildersFor(bindParameters)) {
                bbv.addBindVariable(b);
            }
            batch.addBatchBindVariable(bbv);
        }
        request.setBatch(batch);
        return request.build();
    }

    protected ExecRequest createBatchExecRequest(SqlRpcOptions options, ByteString connectionId, List<String> batchSql) throws SQLException {
        return this.createExecRequestBuilder(options, connectionId, null).setBatch(Client.BatchProto.newBuilder().addAllStatement(batchSql)).build();
    }

    private ExecRequest.Builder createExecRequestBuilder(SqlRpcOptions options, ByteString connectionId, String sql) {
        ExecRequest.Builder request = ExecRequest.newBuilder().setStatementType(options.getStatementType()).setInstance(this.getInstance()).setConnectionId(connectionId);
        if (sql != null) {
            request.setStatement(sql);
        }
        Client.ExecOptions.Builder optionsBuilder = Client.ExecOptions.newBuilder();
        if (options.getIncludeExportedKeys()) {
            optionsBuilder.setIncludeGeneratedKeys(true);
        }
        if (options.getGeneratedColumnIndices() != null) {
            for (int index : options.getGeneratedColumnIndices()) {
                optionsBuilder.addGeneratedColumnIndices(index);
            }
        }
        if (options.getGeneratedColumnNames() != null) {
            optionsBuilder.addAllGeneratedColumnNames(Arrays.asList(options.getGeneratedColumnNames()));
        }
        if (options.getFetchSize() != 0) {
            optionsBuilder.setFetchSize(options.getFetchSize());
        }
        optionsBuilder.setType(Client.ResultSetType.valueOf(options.getResultSetType()));
        optionsBuilder.setConcurrency(Client.ResultSetConcurrency.valueOf(options.getResultSetConcurrency()));
        optionsBuilder.setHoldability(Client.ResultSetHoldability.valueOf(options.getResultSetHoldability()));
        request.setOptions(optionsBuilder.build());
        return request;
    }

    protected ExecRequest createExecNextRequest(SqlRpcOptions options, ByteString connectionId, long statementId) {
        ExecRequest.Builder request = ExecRequest.newBuilder().setInstance(this.getInstance()).setConnectionId(connectionId).setStatementId(statementId);
        return request.build();
    }

    protected ExecOpRequest createExecOpRequest(ByteString connectionId, Client.OpProto op) {
        ExecOpRequest.Builder request = ExecOpRequest.newBuilder().setInstance(this.getInstance()).setConnectionId(connectionId).setOp(op);
        return request.build();
    }

    protected OpenConnectionRequest createConnectRequest(Url url) {
        OpenConnectionRequest.Builder request = OpenConnectionRequest.newBuilder();
        for (Map.Entry<String, String> e : url.getProperties().entrySet()) {
            request.addProperty(Client.Property.newBuilder().setKey(e.getKey()).setValue(e.getValue()));
        }
        request.setInstance(this.getInstance());
        return request.build();
    }

    protected CloseConnectionRequest createReleaseRequest(ByteString connectionId) {
        return CloseConnectionRequest.newBuilder().setInstance(this.getInstance()).setConnectionId(connectionId).build();
    }

    protected MetadataRequest createMetadataRequest(ByteString connectionId, Client.MetadataType metadataType, List<BoundValue> bindParameters) throws SQLException {
        MetadataRequest.Builder request = MetadataRequest.newBuilder().setInstance(this.getInstance()).setConnectionId(connectionId).setMetadata(metadataType);
        for (Client.BindVariableProto.Builder b : this.bindParameterBuildersFor(bindParameters)) {
            request.addBindVariable(b);
        }
        return request.build();
    }

    private List<Client.BindVariableProto.Builder> bindParameterBuildersFor(List<BoundValue> bindParameters) throws SQLException {
        ArrayList<Client.BindVariableProto.Builder> builders = Util.newArrayListWithCapacity(bindParameters.size());
        if (!bindParameters.isEmpty()) {
            int position = 1;
            for (BoundValue p : bindParameters) {
                Client.BindVariableProto.Builder bind = Client.BindVariableProto.newBuilder();
                bind.setPosition(position++);
                bind.setType(p.getDataType().getCode());
                bind.setDirection(p.getDirection());
                if (!p.isNull()) {
                    bind.setValue(p.getValueAsByteString());
                }
                builders.add(bind);
            }
        }
        return builders;
    }
}

