/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.Cursor;
import java.util.ArrayList;

public final class FetchOptions {
    @Deprecated
    public static final int DEFAULT_CHUNK_SIZE = 20;
    private Integer limit;
    private Integer offset;
    private Integer prefetchSize;
    private Integer chunkSize;
    private Cursor startCursor;
    private Cursor endCursor;
    private Boolean compile;

    private FetchOptions() {
    }

    FetchOptions(FetchOptions original) {
        this.limit = original.limit;
        this.offset = original.offset;
        this.prefetchSize = original.prefetchSize;
        this.chunkSize = original.chunkSize;
        this.startCursor = original.startCursor;
        this.endCursor = original.endCursor;
        this.compile = original.compile;
    }

    public FetchOptions limit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("Limit must be non-negative.");
        }
        this.limit = limit;
        return this;
    }

    FetchOptions clearLimit() {
        this.limit = null;
        return this;
    }

    public FetchOptions offset(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset must be 0 or greater.");
        }
        this.offset = offset;
        return this;
    }

    FetchOptions clearOffset() {
        this.offset = null;
        return this;
    }

    public FetchOptions chunkSize(int chunkSize) {
        if (chunkSize < 1) {
            throw new IllegalArgumentException("Chunk size must be greater than 0.");
        }
        this.chunkSize = chunkSize;
        return this;
    }

    FetchOptions clearChunkSize() {
        this.chunkSize = null;
        return this;
    }

    public FetchOptions prefetchSize(int prefetchSize) {
        if (prefetchSize < 0) {
            throw new IllegalArgumentException("Prefetch size must be 0 or greater.");
        }
        this.prefetchSize = prefetchSize;
        return this;
    }

    FetchOptions clearPrefetchSize() {
        this.prefetchSize = null;
        return this;
    }

    @Deprecated
    public FetchOptions cursor(Cursor cursor) {
        return this.startCursor(cursor);
    }

    public FetchOptions startCursor(Cursor startCursor) {
        if (startCursor == null) {
            throw new NullPointerException("start cursor cannot be null.");
        }
        this.startCursor = startCursor;
        return this;
    }

    public FetchOptions endCursor(Cursor endCursor) {
        if (endCursor == null) {
            throw new NullPointerException("end cursor cannot be null.");
        }
        this.endCursor = endCursor;
        return this;
    }

    FetchOptions clearStartCursor() {
        this.startCursor = null;
        return this;
    }

    FetchOptions clearEndCursor() {
        this.endCursor = null;
        return this;
    }

    FetchOptions compile(boolean compile) {
        this.compile = compile;
        return this;
    }

    FetchOptions clearCompile() {
        this.compile = null;
        return this;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Integer getChunkSize() {
        return this.chunkSize;
    }

    public Integer getPrefetchSize() {
        return this.prefetchSize;
    }

    @Deprecated
    public Cursor getCursor() {
        return this.getStartCursor();
    }

    public Cursor getStartCursor() {
        return this.startCursor;
    }

    public Cursor getEndCursor() {
        return this.endCursor;
    }

    Boolean getCompile() {
        return this.compile;
    }

    public int hashCode() {
        int result = 0;
        if (this.prefetchSize != null) {
            result = result * 31 + this.prefetchSize.hashCode();
        }
        if (this.chunkSize != null) {
            result = result * 31 + this.chunkSize.hashCode();
        }
        if (this.limit != null) {
            result = result * 31 + this.limit.hashCode();
        }
        if (this.offset != null) {
            result = result * 31 + this.offset.hashCode();
        }
        if (this.startCursor != null) {
            result = result * 31 + this.startCursor.hashCode();
        }
        if (this.endCursor != null) {
            result = result * 31 + this.endCursor.hashCode();
        }
        if (this.compile != null) {
            result = result * 31 + this.compile.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        FetchOptions that = (FetchOptions)obj;
        if (this.prefetchSize != null ? !this.prefetchSize.equals(that.prefetchSize) : that.prefetchSize != null) {
            return false;
        }
        if (this.chunkSize != null ? !this.chunkSize.equals(that.chunkSize) : that.chunkSize != null) {
            return false;
        }
        if (this.limit != null ? !this.limit.equals(that.limit) : that.limit != null) {
            return false;
        }
        if (this.offset != null ? !this.offset.equals(that.offset) : that.offset != null) {
            return false;
        }
        if (this.startCursor != null ? !this.startCursor.equals(that.startCursor) : that.startCursor != null) {
            return false;
        }
        if (this.endCursor != null ? !this.endCursor.equals(that.endCursor) : that.endCursor != null) {
            return false;
        }
        return !(this.compile != null ? !this.compile.equals(that.compile) : that.compile != null);
    }

    public String toString() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.prefetchSize != null) {
            result.add("prefetchSize=" + this.prefetchSize);
        }
        if (this.chunkSize != null) {
            result.add("chunkSize=" + this.chunkSize);
        }
        if (this.limit != null) {
            result.add("limit=" + this.limit);
        }
        if (this.offset != null) {
            result.add("offset=" + this.offset);
        }
        if (this.startCursor != null) {
            result.add("startCursor=" + this.startCursor);
        }
        if (this.endCursor != null) {
            result.add("endCursor=" + this.endCursor);
        }
        if (this.compile != null) {
            result.add("compile=" + this.compile);
        }
        return "FetchOptions" + result;
    }

    public static final class Builder {
        public static FetchOptions withLimit(int limit) {
            return Builder.withDefaults().limit(limit);
        }

        public static FetchOptions withOffset(int offset) {
            return Builder.withDefaults().offset(offset);
        }

        public static FetchOptions withChunkSize(int chunkSize) {
            return Builder.withDefaults().chunkSize(chunkSize);
        }

        public static FetchOptions withPrefetchSize(int prefetchSize) {
            return Builder.withDefaults().prefetchSize(prefetchSize);
        }

        @Deprecated
        public static FetchOptions withCursor(Cursor cursor) {
            return Builder.withStartCursor(cursor);
        }

        public static FetchOptions withStartCursor(Cursor startCursor) {
            return Builder.withDefaults().startCursor(startCursor);
        }

        public static FetchOptions withEndCursor(Cursor endCursor) {
            return Builder.withDefaults().endCursor(endCursor);
        }

        public static FetchOptions withDefaults() {
            return new FetchOptions();
        }

        private Builder() {
        }
    }
}

