/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc;

import com.google.cloud.sql.jdbc.ResultSet;
import com.google.cloud.sql.jdbc.Statement;
import com.google.protos.cloud.sql.Client;
import com.google.protos.cloud.sql.ExecResponse;
import java.sql.SQLException;
import java.sql.SQLWarning;

public class StreamingResultSet
extends ResultSet {
    boolean moreRows;

    public StreamingResultSet(Statement stmt, Client.ResultProto result, SQLWarning warnings, String catalog, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super(stmt, result.getRows().getTuplesList(), result.getRows().getColumnsList(), warnings, catalog, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.moreRows = result.hasMoreRows();
    }

    public boolean next() throws SQLException {
        boolean next = super.next();
        if (!next && this.moreRows) {
            ExecResponse response = this.getStatement().executeNext();
            if (!response.hasResult()) {
                this.moreRows = false;
                return false;
            }
            Client.ResultProto result = response.getResult();
            this.moreRows = result.getMoreRows();
            return this.setData(result.getRows().getTuplesList());
        }
        return next;
    }
}

