/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc.internal;

import com.google.cloud.sql.jdbc.internal.Util;
import java.util.Map;

public final class SqlState {
    static final int PUBLIC_ERROR_CODE_START = 1000;
    private static final Map<Integer, String> CODE_TO_SQLSTATE_MAP = Util.newHashMap();

    private SqlState() {
    }

    public static String forOpenConnectionError(int errorCode) {
        if (errorCode == 1003) {
            return CODE_TO_SQLSTATE_MAP.get(errorCode);
        }
        return "08006";
    }

    public static String forError(int errorCode) {
        if (errorCode <= 1000) {
            return "";
        }
        String sqlState = CODE_TO_SQLSTATE_MAP.get(errorCode);
        if (sqlState != null) {
            return sqlState;
        }
        return String.format("R%04X", errorCode);
    }

    static {
        CODE_TO_SQLSTATE_MAP.put(1001, "22000");
        CODE_TO_SQLSTATE_MAP.put(1003, "28000");
        CODE_TO_SQLSTATE_MAP.put(1004, "08004");
        CODE_TO_SQLSTATE_MAP.put(1005, "22023");
        CODE_TO_SQLSTATE_MAP.put(1006, "HY000");
        CODE_TO_SQLSTATE_MAP.put(1007, "08006");
        CODE_TO_SQLSTATE_MAP.put(1008, "24000");
        CODE_TO_SQLSTATE_MAP.put(1009, "42000");
        CODE_TO_SQLSTATE_MAP.put(1010, "42000");
        CODE_TO_SQLSTATE_MAP.put(1020, "42000");
        CODE_TO_SQLSTATE_MAP.put(1030, "OA100");
        CODE_TO_SQLSTATE_MAP.put(1031, "OA000");
        CODE_TO_SQLSTATE_MAP.put(1036, "08002");
    }
}

