﻿// Copyright (C) 2010 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: UpdateConfig.cs 504 2014-02-11 09:49:09Z panacoran $

using Protra.Lib.Update;

namespace Protra.Lib.Config
{
    /// <summary>
    /// データ更新に関する設定を読み書きするクラス
    /// </summary>
    public class UpdateConfig : ConfigBase
    {
        /// <summary>
        /// プロキシサーバを使用するかを取得または設定する。
        /// </summary>
        public bool UseProxy { get; set; }

        /// <summary>
        /// プロキシサーバのアドレスを取得または設定する。
        /// </summary>
        public string ProxyAddress { get; set; }
        
        /// <summary>
        /// プロキシサーバのポートを取得または設定する。
        /// </summary>
        public int ProxyPort { get; set; }

        /// <summary>
        /// 株価データソースを取得または設定する。
        /// </summary>
        public PriceDataSource PriceDataSource { get; set; }

        /// <summary>
        /// 無尽蔵のURLを取得または設定する。
        /// </summary>
        public string MujinzouUrl { get; set; }

        /// <summary>
        /// 設定ファイルの名前を取得する。
        /// </summary>
        protected override string ConfigName
        {
            get { return "update"; }
        }

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public UpdateConfig()
        {
            ProxyAddress = "";
            ProxyPort = -1;
        }
    }
}
