﻿// Copyright (C) 2013 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id$

using System.Drawing;
using System.Windows.Forms;

namespace Protra.Lib
{
    /// <summary>
    /// ユーティリティ関数をを提供するクラス
    /// </summary>
    public class Utils
    {
        /// <summary>
        /// 指定したRectangle全体が画面に表示されるかを返す。
        /// </summary>
        /// <param name="bounds">Rectangle</param>
        /// <returns>表示されるならtrueをされないならfalseを返す。</returns>
        public static bool IsShowOnScreen(Rectangle bounds)
        {
            foreach (var screen in Screen.AllScreens)
                if (screen.Bounds.Contains(bounds))
                    return true;
            return false;
        }
    }
}
