﻿// Copyright (C) 2003 Daisuke Arai <darai@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: FunctionType.cs 306 2010-03-19 13:21:22Z panacoran $

using System;

namespace Protra.Lib.Lang
{
	/// <summary>
	/// 関数の型を表すクラスです。
	/// 関数名と引数の数を持ちます。
	/// </summary>
	public class FunctionType
	{
		/// <summary>
		/// 関数名
		/// </summary>
		private string name;
		/// <summary>
		/// 引数の数
		/// </summary>
		private int num;

		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <param name="name">関数名</param>
		/// <param name="num">引数の数</param>
		public FunctionType(string name, int num)
		{
			this.name = name;
			this.num = num;
		}

		/// <summary>
		/// 関数名を取得します。
		/// </summary>
		public string Name
		{
			get { return name; }
		}

		/// <summary>
		/// 引数の数を取得します。
		/// </summary>
		public int ArgumentNum
		{
			get { return num; }
		}

		/// <summary>
		/// 指定したオブジェクトと等しいかどうかを判断します。
		/// </summary>
		/// <param name="o">オブジェクト</param>
		/// <returns>等しければtrueになります。</returns>
		public override bool Equals(object o)
		{
			if(o is FunctionType)
				return ((FunctionType)o).name == this.name
					&& ((FunctionType)o).num == this.num;
			return false;
		}

		/// <summary>
		/// ハッシュ値を計算します。
		/// </summary>
		/// <returns>ハッシュ値</returns>
		public override int GetHashCode()
		{
			return name.GetHashCode() + num;
		}

		/// <summary>
		/// 文字列表現です。
		/// </summary>
		/// <returns>文字列表現</returns>
		public override string ToString()
		{
			return name + "(" + num.ToString() + ")";
		}
	}
}
