﻿// Copyright (C) 2010 panacoran <panacoran@users.sourceforge.jp>
// Copyright (C) 2012 Daisuke Arai <darai@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: PtSimConfig.cs 438 2012-06-22 16:54:17Z darai $using System;
using System.Collections.Generic;
using System.Text;
using Protra.Lib.Data;

namespace Protra.Lib.Config
{
    /// <summary>
    /// PtSimの設定を読み書きするクラス。
    /// </summary>
    public class PtSimConfig : ConfigBase
    {
        /// <summary>
        /// システムの実行モードの設定を取得または設定する。
        /// </summary>
        public int Mode { get; set; }

        /// <summary>
        /// 銘柄リストの名前の設定を取得または設定する。
        /// </summary>
        public string BrandListName { get; set; }

        /// <summary>
        /// 売買システム一覧を取得または設定する。
        /// </summary>
        public List<SystemAndTarget> SystemAndTargetList { get; set; }

        /// <summary>
        /// 設定ファイルの名前を取得する。
        /// </summary>
        protected override string ConfigName
        {
            get { return "ptsim"; }
        }

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public PtSimConfig()
        {
        }

        /// <summary>
        /// 古い設定ファイルを読み込む。
        /// </summary>
        protected override void ReadOldConfig()
        {
            ConfigFile ptsim = new ConfigFile("ptsim");
            try
            {
                ptsim.Read();
            }
            catch
            {
                return;
            }
            Mode = int.Parse(ptsim["Mode"]);
            var bl = Db.BrandListTable.GetRecord(int.Parse(ptsim["BrandListId"]));
            BrandListName = bl.Name;
        }
    }

    /// <summary>
    /// 売買システム一覧の要素を表すクラスです。
    /// </summary>
    public class SystemAndTarget
    {
        /// <summary>
        /// 売買システムのファイルパスを取得または設定する。
        /// </summary>
        public string SystemFileName { get; set; }
        /// <summary>
        /// 銘柄リスト名を取得または設定する。
        /// </summary>
        public string BrandListName { get; set; }
        /// <summary>
        /// 期間モードを取得または設定する。
        /// </summary>
        public int Mode { get; set; }
        /// <summary>
        /// 選択状態を取得または設定する。
        /// </summary>
        public bool Checked { get; set; }
        
        public override bool Equals(object o){
            SystemAndTarget sat = o as SystemAndTarget;
            return this.SystemFileName == sat.SystemFileName
                && this.BrandListName == sat.BrandListName
                && this.Mode == sat.Mode;
        }
    }
}
