// Copyright (C) 2003,2005 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2004 M. Ishiguro <mishiguro@users.sourceforge.jp>
// Copyright (C) 2004-2008 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: SimulateTextBox.cs,v 1.14 2008-01-12 14:25:35 panacoran Exp $

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using System.IO;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;
using System.Runtime.InteropServices;
using System.Threading;
using Protra.Lib.Db;
using Protra.Lib.Lang;
using Protra.Lib.Lang.Executer;

namespace Protra.Lib.Controls
{
	/// <summary>
	/// VXẽV~[Vp̃eLXg{bNXłB
	/// </summary>
	public class SimulateTextBox : System.Windows.Forms.TextBox, IExecuterFactory
	{
		/// <summary>
		/// g[fBOVXe
		/// </summary>
		private TradingSystem system;
		/// <summary>
		/// ΏۂƂȂPrice̔z
		/// </summary>
		private Price[] prices;
		/// <summary>
		/// ΏۂƂȂBrand
		/// </summary>
		private Brand brand;
		/// <summary>
		/// ݔ̃CfbNX
		/// </summary>
		private int index;
		/// <summary>
		/// Ogp邩H
		/// </summary>
		private bool useLog;
		/// <summary>
		/// C^v^t@T[h
		/// </summary>
		private InterpreterFacade facade;
		/// <summary>
		/// FunctionTypeDelegateExecuter.Delegate
		/// ΉnbV
		/// </summary>
		private Hashtable hash = new Hashtable();
		/// <summary>
		/// IExecuter𐶐Factory
		/// </summary>
		private ExecuterFactoryUnion factory;

		private delegate void AppendTextDelegate(string msg);
		private AppendTextDelegate appendTextDelegate;

		/// <summary>
		/// KvȃfUCiϐłB
		/// </summary>
		private System.ComponentModel.Container components = null;

		/// <summary>
		/// RXgN^
		/// </summary>
		public SimulateTextBox()
		{
			// ̌ĂяóAWindows.Forms tH[ fUCiŕKvłB
			InitializeComponent();

			// nbVɃfQ[go^܂B
			hash.Add(new FunctionType("Index", 0), new DelegateExecuter.Delegate(Index));
			hash.Add(new FunctionType("Year", 0), new DelegateExecuter.Delegate(Year));
			hash.Add(new FunctionType("Month", 0), new DelegateExecuter.Delegate(Month));
			hash.Add(new FunctionType("Day", 0), new DelegateExecuter.Delegate(Day));
			hash.Add(new FunctionType("DayOfWeek", 0), new DelegateExecuter.Delegate(DayOfWeek));
			hash.Add(new FunctionType("Open", 0), new DelegateExecuter.Delegate(Open));
			hash.Add(new FunctionType("High", 0), new DelegateExecuter.Delegate(High));
			hash.Add(new FunctionType("Low", 0), new DelegateExecuter.Delegate(Low));
			hash.Add(new FunctionType("Close", 0), new DelegateExecuter.Delegate(Close));
			hash.Add(new FunctionType("Volume", 0), new DelegateExecuter.Delegate(Volume));
			hash.Add(new FunctionType("Code", 0), new DelegateExecuter.Delegate(Code));
			hash.Add(new FunctionType("Print", 1), new DelegateExecuter.Delegate(Print));
			hash.Add(new FunctionType("PrintLog", 1), new DelegateExecuter.Delegate(PrintLog));
			hash.Add(new FunctionType("Buy", 2), new DelegateExecuter.Delegate(Buy));
			hash.Add(new FunctionType("Sell", 2), new DelegateExecuter.Delegate(Sell));
			
			// w֐Ƃ̍Factory`
			factory = new ExecuterFactoryUnion();
			factory.Add(this);
			factory.Add(new MathExecuterFactory());

			appendTextDelegate = new AppendTextDelegate(AppendText);
		}

		
		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂B
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		private void InitializeComponent()
		{
			components = new System.ComponentModel.Container();
		}
		#endregion

		/// <summary>
		/// SVXeO폜܂B
		/// </summary>
		public static void DeleteLog()
		{
			SystemLogTable.Delete();
			if(Directory.Exists(Global.DirGlobalCache))
				Directory.Delete(Global.DirGlobalCache, true);
		}

		/// <summary>
		/// w肳ꂽVXẽVXeO폜܂B
		/// </summary>
		public static void DeleteLog(int systemId)
		{
			SystemLogTable.Delete(systemId);
			string dir = Path.Combine(Global.DirGlobalCache, systemId.ToString());
			if(Directory.Exists(dir))
				Directory.Delete(dir, true);
		}

		/// <summary>
		/// V~[Vs܂B
		/// </summary>
		/// <param name="prices">ΏۂƂȂPrice̔z</param>
        /// <param name="worker">̃\bhsBackgroundWorker</param>
        /// <param name="e">BackgroundWorkerDoWorkCxg̈</param>
		public void Simulate(Price[] prices, BackgroundWorker worker, DoWorkEventArgs e)
		{
			if(prices.Length == 0)
				return;
			this.prices = prices;
			brand = prices[0].Brand;
			facade.GlobalVariableTable.Clear();
			index = 0;
			if(useLog)
			{
				LoadGlobalCache();
				Split[] split = SplitTable.GetRecords(brand.Code);
				if (index > 0 && split.Length > 0 &&
					prices[prices.Length - 1].Date >= split[split.Length - 1].Date &&
					prices[index - 1].Date < split[split.Length - 1].Date)
				{
					string msg = string.Format(
						"{0} {1} ̂߃O폜čĎs\r\n",
						brand.Code, brand.Name);
					BeginInvoke(appendTextDelegate, new object[] {msg});
					SystemLogTable.Delete(system.Id, brand.Id);
					index = 0;
					facade.GlobalVariableTable.Clear();
				}
			}
			while(index < prices.Length)
			{
                if (worker.CancellationPending)
                {
                    e.Cancel = true;
                    return;
                }
				facade.Execute();
				index++;
			}
			if(useLog)
				SaveGlobalCache();
		}

		/// <summary>
		/// O[oLbV[h܂B
		/// </summary>
		private void LoadGlobalCache()
		{
			string file =
				Path.Combine(Global.DirGlobalCache,
				system.Id.ToString() + Path.DirectorySeparatorChar 
				+ (brand.Id / 1000) + Path.DirectorySeparatorChar
				+ brand.Id);
			if(File.Exists(file))
			{
				Stream stream = new FileStream(file, FileMode.Open);
				BinaryFormatter formatter = new BinaryFormatter();
				index = (int)formatter.Deserialize(stream);
				facade.GlobalVariableTable =
					(VariableTable)formatter.Deserialize(stream);
				stream.Close();
			}
		}

		/// <summary>
		/// O[oLbVZ[u܂B
		/// </summary>
		private void SaveGlobalCache()
		{
			if(! Directory.Exists(Global.DirGlobalCache))
				Directory.CreateDirectory(Global.DirGlobalCache);
			string dir = Path.Combine(Global.DirGlobalCache, system.Id.ToString());
			if(! Directory.Exists(dir))
				Directory.CreateDirectory(dir);
			dir = Path.Combine(dir, (brand.Id / 1000).ToString());
			if(! Directory.Exists(dir))
				Directory.CreateDirectory(dir);
			string file = Path.Combine(dir, brand.Id.ToString());
			Stream stream = new FileStream(file, FileMode.Create);
			BinaryFormatter formatter = new BinaryFormatter();
			formatter.Serialize(stream, index);
			formatter.Serialize(stream, facade.GlobalVariableTable);
			stream.Close();
		}

		/// <summary>
		/// g[fBOVXe擾܂͐ݒ肵܂B
		/// </summary>
		public TradingSystem System
		{
			get { return system; }
			set
			{
				system = value;
				if(system == null)
				{
					facade = null;
					return;
				}
				// vÕ[h
				string programFile = Path.Combine(Global.DirSystem, system.File);
				facade = new InterpreterFacade(programFile, factory);
			}
		}

		/// <summary>
		/// Ogp邩ǂl擾܂͐ݒ肵܂B
		/// </summary>
		public bool UseLog
		{
			get { return useLog; }
			set { useLog = value; }
		}

		/// <summary>
		/// IExecuter𐶐܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.NoSuchExecuterException">
		/// IExecuter݂Ȃꍇthrow܂B
		/// </exception>
		/// <param name="ft">֐̃^Cv</param>
		/// <returns>֐sIExcecuterłB</returns>
		public IExecuter CreateExecuter(FunctionType ft)
		{
			if(hash.ContainsKey(ft))
				return new DelegateExecuter((DelegateExecuter.Delegate)hash[ft]);
			throw new NoSuchExecuterException();
		}

		/// <summary>
		/// ݔ̃CfbNX擾܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>CfbNXłB</returns>
		private Value Index(Value[] args, int at)
		{
			return new Value(index + at);
		}

		/// <summary>
		/// ݔ̔N擾܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>NłB</returns>
		private Value Year(Value[] args, int at)
		{
			try
			{
				return new Value(prices[index + at].Date.Year);
			}
			catch(IndexOutOfRangeException)
			{
				return null;
			}
		}

		/// <summary>
		/// ݔ̌擾܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>łB</returns>
		private Value Month(Value[] args, int at)
		{
			try
			{
				return new Value(prices[index + at].Date.Month);
			}
			catch(IndexOutOfRangeException)
			{
				return null;
			}
		}

		/// <summary>
		/// ݔ̓t擾܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>tłB</returns>
		private Value Day(Value[] args, int at)
		{
			try
			{
				return new Value(prices[index + at].Date.Day);
			}
			catch(IndexOutOfRangeException)
			{
				return null;
			}
		}

		/// <summary>
		/// ݔ̗j擾܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>jłB</returns>
		private Value DayOfWeek(Value[] args, int at)
		{
			try
			{
				return new Value((int)prices[index + at].Date.DayOfWeek);
			}
			catch(IndexOutOfRangeException)
			{
				return null;
			}
		}

		/// <summary>
		/// nl擾܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>nlłB</returns>
		private Value Open(Value[] args, int at)
		{
			try
			{
				return new Value(prices[index + at].Open);
			}
			catch(IndexOutOfRangeException)
			{
				return null;
			}
		}

		/// <summary>
		/// l擾܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>lłB</returns>
		private Value High(Value[] args, int at)
		{
			try
			{
				return new Value(prices[index + at].High);
			}
			catch(IndexOutOfRangeException)
			{
				return null;
			}
		}

		/// <summary>
		/// l擾܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>lłB</returns>
		private Value Low(Value[] args, int at)
		{
			try
			{
				return new Value(prices[index + at].Low);
			}
			catch(IndexOutOfRangeException)
			{
				return null;
			}
		}

		/// <summary>
		/// Il擾܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>IlłB</returns>
		private Value Close(Value[] args, int at)
		{
			try
			{
				return new Value(prices[index + at].Close);
			}
			catch(IndexOutOfRangeException)
			{
				return null;
			}
		}

		/// <summary>
		/// o擾܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>ołB</returns>
		private Value Volume(Value[] args, int at)
		{
			try
			{
				return new Value(prices[index + at].Volume);
			}
			catch(IndexOutOfRangeException)
			{
				return null;
			}
		}

		/// <summary>
		/// R[h擾܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>R[hłB</returns>
		private Value Code(Value[] args, int at)
		{
			try
			{
				return new Value(brand.Code);
			}
			catch(IndexOutOfRangeException)
			{
				return null;
			}
		}

		/// <summary>
		/// ̒leLXg{bNXɏo͂܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>R[hłB</returns>
		private Value Print(Value[] args, int at)
		{
			BeginInvoke(appendTextDelegate, new object[] {((args[0] == null) ? "null" : args[0].InnerValue.ToString()) + "\r\n"});
			return null;
		}

		/// <summary>
		/// ̒l݂̖ƓťɃeLXg{bNXɏo͂܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>R[hłB</returns>
		private Value PrintLog(Value[] args, int at)
		{
			string msg = string.Format(
				"{0} {1} {2} {3}\r\n",
				brand.Code, brand.Name,
				prices[index + at].Date.ToString("yy/MM/dd"),
				(args[0] == null) ? "null" : args[0].InnerValue.ToString());
			BeginInvoke(appendTextDelegate, new object[] {msg});
			return null;
		}

		/// <summary>
		/// ܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>nullԂ܂B</returns>
		private Value Buy(Value[] args, int at)
		{
			int price = (int)args[0].InnerValue;
			int number = (int)args[1].InnerValue;
			if(useLog)
				SystemLogTable.Add(
					system.Id, brand.Id, prices[index + at].Date, price, number, Order.Buy);
			string msg = string.Format(
				"{0} {1} {2} {3}~ {4} \r\n",
				brand.Code, brand.Name,
				prices[index + at].Date.ToString("yy/MM/dd"),
				price, number);
			BeginInvoke(appendTextDelegate, new object[] {msg});
			return null;
		}

		/// <summary>
		/// ܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>nullԂ܂B</returns>
		private Value Sell(Value[] args, int at)
		{
			int price = (int)args[0].InnerValue;
			int number = (int)args[1].InnerValue;
			if(useLog)
				SystemLogTable.Add(
					system.Id, brand.Id, prices[index + at].Date, price, number, Order.Sell);
			string msg = string.Format(
				"{0} {1} {2} {3}~ {4} \r\n",
				brand.Code, brand.Name,
				prices[index + at].Date.ToString("yy/MM/dd"),
				price, number);
			BeginInvoke(appendTextDelegate, new object[] {msg});
			return null;
		}
	}
}
