// Copyright (C) 2003, 2005 Daisuke Arai <darai@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: ProgramNode.cs,v 1.3 2007-12-27 08:34:39 panacoran Exp $

using System;
using System.Collections;

namespace Protra.Lib.Lang
{
	/// <summary>
	/// vÕm[h\NXłB
	/// </summary>
	public class ProgramNode : Node
	{
		/// <summary>
		/// m[h̃Xg
		/// </summary>
		private ArrayList nodeList = new ArrayList();

		/// <summary>
		/// ͂܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.ParseException">
		/// ɃG[ꍇthrow܂B
		/// </exception>
		/// <param name="context">ReLXg</param>
		public override void Parse(Context context)
		{
			this.ContextToken = (ContextToken)context.Current;

			while(context.MoveNext())
			{
				ContextToken ct = (ContextToken)context.Current;
				string token = ct.ToString();
				if(token == "def ")
				{
					Node node = new FunctionDefinitionNode();
					node.Parse(context);
					nodeList.Add(node);
				}
				else
				{
					Node node = new StatementNode();
					node.Parse(context);
					nodeList.Add(node);
				}
			}
		}

		/// <summary>
		/// \؂ȗ܂B
		/// </summary>
		/// <returns>ȗꂽm[h</returns>
		public override Node Simplify()
		{
			for(int i = 0; i < nodeList.Count; i++)
			{
				Node node = (Node)nodeList[i];
				nodeList[i] = node.Simplify();
			}
			return this;
		}

		/// <summary>
		/// vOs܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrow܂B
		/// </exception>
		/// <param name="resource">\[X</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>s</returns>
		public override Value Execute(Resource resource, int at)
		{
			// [JϐpVariableTablevbV
			resource.Stack.Push(new VariableTable());

			try
			{
				foreach(Node node in nodeList)
					node.Execute(resource, at);
			}
			catch(ReturnStatementExecutedException exc)
			{
				// [JϐpVariableTable|bv
				resource.Stack.Pop();
				return exc.Value;
			}
			catch(BreakStatementExecutedException)
			{
				throw new RuntimeException("unexpected break", this.ContextToken);
			}
			catch(ContinueStatementExecutedException)
			{
				throw new RuntimeException("unexpected continue", this.ContextToken);
			}

			// [JϐpVariableTable|bv
			resource.Stack.Pop();
			return null;
		}
	}
}
