﻿// Copyright (C) 2003 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2013 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: FunctionType.cs 455 2013-06-08 11:52:33Z panacoran $

namespace Protra.Lib.Lang
{
    /// <summary>
    /// 関数の型を表すクラスです。
    /// 関数名と引数の数を持ちます。
    /// </summary>
    public class FunctionType
    {
        /// <summary>
        /// 関数名
        /// </summary>
        private readonly string _name;

        /// <summary>
        /// 引数の数
        /// </summary>
        private readonly int _num;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="name">関数名</param>
        /// <param name="num">引数の数</param>
        public FunctionType(string name, int num)
        {
            _name = name;
            _num = num;
        }

        /// <summary>
        /// 関数名を取得します。
        /// </summary>
        public string Name
        {
            get { return _name; }
        }

        /// <summary>
        /// 引数の数を取得します。
        /// </summary>
        public int ArgumentNum
        {
            get { return _num; }
        }

        /// <summary>
        /// 指定したオブジェクトと等しいかどうかを判断します。
        /// </summary>
        /// <param name="o">オブジェクト</param>
        /// <returns>等しければtrueになります。</returns>
        public override bool Equals(object o)
        {
            var type = o as FunctionType;
            if (type != null)
                return type._name == _name && type._num == _num;
            return false;
        }

        /// <summary>
        /// ハッシュ値を計算します。
        /// </summary>
        /// <returns>ハッシュ値</returns>
        public override int GetHashCode()
        {
            return _name.GetHashCode() + _num;
        }

        /// <summary>
        /// 文字列表現です。
        /// </summary>
        /// <returns>文字列表現</returns>
        public override string ToString()
        {
            return _name + "(" + _num + ")";
        }
    }
}