// Copyright (C) 2003 Daisuke Arai <darai@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: Resource.cs,v 1.2 2007-12-27 08:34:39 panacoran Exp $

using System;

namespace Protra.Lib.Lang
{
	/// <summary>
	/// vOŝɕKvȃ\[XێNXłB
	/// StackArea, VariableTable, FunctionTable, IExecuterFactory ܂݂܂B
	/// </summary>
	public class Resource
	{
		/// <summary>
		/// [Jϐ̃e[uvbVX^bN
		/// </summary>
		public StackArea Stack;
		/// <summary>
		/// O[oϐ̃e[u
		/// </summary>
		public VariableTable GlobalVariableTable;
		/// <summary>
		/// ֐̃e[u
		/// </summary>
		public FunctionTable FunctionTable;
		/// <summary>
		/// IExecuter𐶐Factory
		/// </summary>
		public IExecuterFactory ExecuterFactory;

		/// <summary>
		/// RXgN^
		/// </summary>
		public Resource() {}

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="stack">[Jϐ̃e[uvbVX^bN</param>
		/// <param name="gVarTable">O[oϐђ萔̃e[u</param>
		/// <param name="funcTable">֐̃e[u</param>
		/// <param name="factory">IExecuter𐶐Factory</param>
		public Resource
			(StackArea stack, VariableTable gVarTable, FunctionTable funcTable, IExecuterFactory factory)
		{
			Stack = stack;
			GlobalVariableTable = gVarTable;
			FunctionTable = funcTable;
			ExecuterFactory = factory;
		}
	}
}
