// Copyright (C) 2003, 2005 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2008 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: SuffixedExpressionNode.cs,v 1.5 2008-03-26 22:12:54 panacoran Exp $

using System;
using System.Collections.Generic;

namespace Protra.Lib.Lang
{
	/// <summary>
	/// ũm[h\NXB
	/// </summary>
	public class SuffixedExpressionNode : Node
	{
		/// <summary>
		/// zw
		/// </summary>
		private Node arrayNode;
		/// <summary>
		/// zɑ΂CfbNXƂȂm[h̃Xg
		/// </summary>
        private List<Node> nodeList;

		/// <summary>
		/// \͂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.ParseException">
		/// \͒ɃG[ƂthrowB
		/// </exception>
        /// <return>
        /// ͂ʂ̃m[hB
        /// </return>
		public override Node Parse()
		{
			Token = Scanner.Token;
			Node node = new PrimaryNode().Parse();
            Token t = Scanner.Token;
            if (t.Value != "[")
                return node;
            arrayNode = node;
            nodeList = new List<Node>();
			do
			{
				Scanner.Scan();
				nodeList.Add(new ExpressionNode().Parse());
                t = Scanner.Token;
				if (t.Value != "]")
					throw new ParseException("']' expected.", Token);
				Scanner.Scan();
                t = Scanner.Token;
            }
            while (t.Value == "[");
            return this;
		}

		/// <summary>
		/// vOsB
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrow
		/// </exception>
		/// <param name="resource">\[X</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>s</returns>
		public override Value Execute(Resource resource, int at)
		{
			try 
			{
				Value val = arrayNode.Execute(resource, at);
				for(int i = 0; i < nodeList.Count; i++)
				{
					Value index = nodeList[i].Execute(resource, at);
					val = val[index];
				}
				return val;
			}
			catch (RuntimeException e)
			{
				if (e.Token == null)
					e.Token = Token;
				throw e;
			}		
			catch (NullReferenceException e)
            {
                throw new RuntimeException(e.Message, Token);
            }
		}

		/// <summary>
		/// sB
		/// </summary>
		/// <param name="resource">\[X</param>
		/// <param name="at">@pf̒l</param>
        /// <param name="val">l</param>
		/// <returns>s</returns>
		public Value Assign(Resource resource, int at, Value val)
		{
			try 
			{
				Value arr = arrayNode.Execute(resource, at);
                Value index = nodeList[0].Execute(resource, at);
				for(int i = 1; i < nodeList.Count; i++)
				{
                    arr = arr[index];
					index = nodeList[i].Execute(resource, at);
				}
				return arr[index] = val;
			}
			catch (RuntimeException e)
			{
				if (e.Token == null)
					e.Token = Token;
				throw e;
			}		
			catch (NullReferenceException e)
            {
                throw new RuntimeException(e.Message, Token);
            }
		}
	}
}
