// Copyright (C) 2003, 2005 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2008 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: Node.cs,v 1.5 2008-03-30 16:06:42 panacoran Exp $

using System;
using System.Collections.Generic;

namespace Protra.Lib.Lang
{
	/// <summary>
	/// vO̍\؂̃m[h\ۃNXB
	/// </summary>
	public abstract class Node
	{
        static private Scanner scanner;
        private Token token;
        static private Stack<Dictionary<string, int>> lvtStack = new Stack<Dictionary<string,int>>();

        /// <summary>
        /// ͊擾܂͐ݒ肷B
        /// </summary>
        static public Scanner Scanner
        {
            get { return scanner; }
            set { scanner = value; }
        }

        /// <summary>
        /// [Jϐ̋L\̃X^bN擾B
        /// </summary>
        static public Stack<Dictionary<string, int>> LvtStack
        {
            get { return lvtStack; }
        }

        /// <summary>
        /// ̃m[hg[N擾܂͐ݒ肷B
        /// </summary>
        /// <returns>̃m[hg[N</returns>
        public Token Token
        {
            get { return token; }
            set { token = value; }
        }

		/// <summary>
		/// \͂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.ParseException">
		/// \͒ɃG[ꍇthrowB
		/// </exception>
        /// <return>
        /// ͂ʂ̃m[hB
        /// </return>
        public abstract Node Parse();

		/// <summary>
		/// vOsB
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrowB
		/// </exception>
		/// <param name="resource">\[X</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>s</returns>
		public abstract Value Execute(Resource resource, int at);
	}
}
