// Copyright (C) 2003 Daisuke Arai <darai@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: MathExecuterFactory.cs,v 1.2 2007-12-27 08:34:39 panacoran Exp $

using System;
using System.Collections;

namespace Protra.Lib.Lang.Executer
{
	/// <summary>
	/// w֐sIExecuter𐶐FactoryłB
	/// </summary>
	public class MathExecuterFactory : IExecuterFactory
	{
		/// <summary>
		/// FunctionTypeDelegateExecuter.Delegate
		/// ΉnbV
		/// </summary>
		private Hashtable hash = new Hashtable();

		/// <summary>
		/// RXgN^
		/// </summary>
		public MathExecuterFactory()
		{
			// nbVɃfQ[go^܂B
			hash.Add(new FunctionType("Exp", 1), new DelegateExecuter.Delegate(Exp));
			hash.Add(new FunctionType("Log", 1), new DelegateExecuter.Delegate(Log));
			hash.Add(new FunctionType("Sqrt", 1), new DelegateExecuter.Delegate(Sqrt));
			hash.Add(new FunctionType("Sin", 1), new DelegateExecuter.Delegate(Sin));
			hash.Add(new FunctionType("Cos", 1), new DelegateExecuter.Delegate(Cos));
			hash.Add(new FunctionType("Tan", 1), new DelegateExecuter.Delegate(Tan));
			hash.Add(new FunctionType("Asin", 1), new DelegateExecuter.Delegate(Asin));
			hash.Add(new FunctionType("Acos", 1), new DelegateExecuter.Delegate(Acos));
			hash.Add(new FunctionType("Atan", 1), new DelegateExecuter.Delegate(Atan));
			hash.Add(new FunctionType("Pow", 2), new DelegateExecuter.Delegate(Pow));
		}

		/// <summary>
		/// IExecuter𐶐܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.NoSuchExecuterException">
		/// IExecuter݂Ȃꍇthrow܂B
		/// </exception>
		/// <param name="ft">֐̃^Cv</param>
		/// <returns>֐sIExcecuterłB</returns>
		public IExecuter CreateExecuter(FunctionType ft)
		{
			if(hash.ContainsKey(ft))
				return new DelegateExecuter((DelegateExecuter.Delegate)hash[ft]);
			throw new NoSuchExecuterException();
		}

		/// <summary>
		/// ExpvZ܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>vZʂłB</returns>
		private Value Exp(Value[] args, int at)
		{
			Value val = args[0].Cast(Value.Type.Float);
			double d = (double)val.InnerValue;
			return new Value(Math.Exp(d));
		}

		/// <summary>
		/// LogvZ܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>vZʂłB</returns>
		private Value Log(Value[] args, int at)
		{
			Value val = args[0].Cast(Value.Type.Float);
			double d = (double)val.InnerValue;
			return new Value(Math.Log(d));
		}

		/// <summary>
		/// SqrtvZ܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>vZʂłB</returns>
		private Value Sqrt(Value[] args, int at)
		{
			Value val = args[0].Cast(Value.Type.Float);
			double d = (double)val.InnerValue;
			return new Value(Math.Sqrt(d));
		}

		/// <summary>
		/// SinvZ܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>vZʂłB</returns>
		private Value Sin(Value[] args, int at)
		{
			Value val = args[0].Cast(Value.Type.Float);
			double d = (double)val.InnerValue;
			return new Value(Math.Sin(d));
		}

		/// <summary>
		/// CosvZ܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>vZʂłB</returns>
		private Value Cos(Value[] args, int at)
		{
			Value val = args[0].Cast(Value.Type.Float);
			double d = (double)val.InnerValue;
			return new Value(Math.Cos(d));
		}

		/// <summary>
		/// TanvZ܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>vZʂłB</returns>
		private Value Tan(Value[] args, int at)
		{
			Value val = args[0].Cast(Value.Type.Float);
			double d = (double)val.InnerValue;
			return new Value(Math.Tan(d));
		}

		/// <summary>
		/// AsinvZ܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>vZʂłB</returns>
		private Value Asin(Value[] args, int at)
		{
			Value val = args[0].Cast(Value.Type.Float);
			double d = (double)val.InnerValue;
			return new Value(Math.Asin(d));
		}

		/// <summary>
		/// AcosvZ܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>vZʂłB</returns>
		private Value Acos(Value[] args, int at)
		{
			Value val = args[0].Cast(Value.Type.Float);
			double d = (double)val.InnerValue;
			return new Value(Math.Acos(d));
		}

		/// <summary>
		/// AtanvZ܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>vZʂłB</returns>
		private Value Atan(Value[] args, int at)
		{
			Value val = args[0].Cast(Value.Type.Float);
			double d = (double)val.InnerValue;
			return new Value(Math.Atan(d));
		}

		/// <summary>
		/// PowvZ܂B
		/// </summary>
		/// <param name="args">̔z</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>vZʂłB</returns>
		private Value Pow(Value[] args, int at)
		{
			Value val = args[0].Cast(Value.Type.Float);
			double x = (double)val.InnerValue;
			val = args[1].Cast(Value.Type.Float);
			double y = (double)val.InnerValue;
			return new Value(Math.Pow(x, y));
		}
	}
}
