// Copyright (C) 2003, 2005 Daisuke Arai <darai@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: SuffixedExpressionNode.cs,v 1.4 2007-12-27 08:34:39 panacoran Exp $

using System;
using System.Collections;

namespace Protra.Lib.Lang
{
	/// <summary>
	/// ũm[h\NXłB
	/// </summary>
	public class SuffixedExpressionNode : Node
	{
		/// <summary>
		/// zɑ΂CfbNXƂȂm[h̃Xg
		/// </summary>
		private ArrayList nodeList = new ArrayList();
		/// <summary>
		/// ̃m[h
		/// </summary>
		private Node expNode;

		/// <summary>
		/// ͂܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.ParseException">
		/// ɃG[ꍇthrow܂B
		/// </exception>
		/// <param name="context">ReLXg</param>
		public override void Parse(Context context)
		{
			this.ContextToken = (ContextToken)context.Current;

			expNode = new PrimaryNode();
			expNode.Parse(context);
			ContextToken ct = (ContextToken)context.Current;
			string token = ct.ToString();
			while(token == "[")
			{
				context.MoveNext();
				Node node = new ExpressionNode();
				node.Parse(context);
				nodeList.Add(node);
				ct = (ContextToken)context.Current;
				token = ct.ToString();
				if(token != "]")
					throw new ParseException("']' expected", this.ContextToken);
				context.MoveNext();
				ct = (ContextToken)context.Current;
				token = ct.ToString();
			}
		}

		/// <summary>
		/// \؂ȗ܂B
		/// </summary>
		/// <returns>ȗꂽm[h</returns>
		public override Node Simplify()
		{
			if(nodeList.Count == 0)
				return expNode.Simplify();
			else
			{
				expNode = expNode.Simplify();
				for(int i = 0; i < nodeList.Count; i++)
				{
					Node node = (Node)nodeList[i];
					nodeList[i] = node.Simplify();
				}
				return this;
			}
		}

		/// <summary>
		/// vOs܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrow܂B
		/// </exception>
		/// <param name="resource">\[X</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>s</returns>
		public override Value Execute(Resource resource, int at)
		{
			try 
			{
				Value val = expNode.Execute(resource, at);
				for(int i = 0; i < nodeList.Count; i++)
				{
					Node node = (Node)nodeList[i];
					Value index = node.Execute(resource, at);
					val = val[index];
				}

				return val;
			}
			catch(RuntimeException exc)
			{
				if (exc.ContextToken == null)
					exc = new RuntimeException(exc.Message, this.ContextToken);
				throw exc;
			}		
		}
	}
}
