// Copyright (C) 2003, 2005 Daisuke Arai <darai@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: IfStatementNode.cs 263 2010-01-16 13:12:35Z panacoran $

using System;
using System.Collections.Generic;

namespace Protra.Lib.Lang
{
	/// <summary>
	/// if̃m[h\NXB
	/// </summary>
	public class IfStatementNode : Node
	{
		/// <summary>
		/// ̃m[h
		/// </summary>
		private Node condNode;
		/// <summary>
		/// m[h̃Xg
		/// </summary>
        private List<Node> nodeList = new List<Node>();
		/// <summary>
		/// elsif܂else
		/// </summary>
		private IfStatementNode nextNode;

		/// <summary>
		/// \͂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.ParseException">
		/// \͒ɃG[ƂthrowB
		/// </exception>
        /// <return>
        /// ͂ʂ̃m[hB
        /// </return>
		public override Node Parse()
		{
			Token = Scanner.Token;

			if (!Scanner.Scan())
				throw new ParseException("expression is expected", Token);
			condNode = new ExpressionNode().Parse();
			if (Scanner.Token.Value != ";")
				throw new ParseException("';' expected", Token);

			while (Scanner.Scan())
			{
                string token = Scanner.Token.Value;
				if (token == "end")
				{
					Scanner.Scan();
					if (Scanner.Token.Value != ";")
						throw new ParseException("';' expected", Scanner.Token);
					return this;
				}
				else if (token == "elsif")
				{
                    nextNode = (IfStatementNode)(new IfStatementNode().Parse());
					return this;
				}
				else if(token == "else")
				{
					nextNode = ParseElse();
					return this;
				}
				nodeList.Add(new StatementNode().Parse());
			}
			throw new ParseException("unexpected EOF", Token);
		}

		private IfStatementNode ParseElse()
		{
			Scanner.Scan();
			if (Scanner.Token.Value != ";")
				throw new ParseException("';' expected", Scanner.Token);

			IfStatementNode node = new IfStatementNode();
			node.condNode = new LiteralNode(new Value(true));
			while (Scanner.Scan())
			{
				if (Scanner.Token.Value == "end")
				{
					Scanner.Scan();
					if (Scanner.Token.Value != ";")
						throw new ParseException("';' expected", Scanner.Token);
					return node;
				}
				node.nodeList.Add(new StatementNode().Parse());
			}
			throw new ParseException("unexpected EOF", Token);
		}

		/// <summary>
		/// vOsB
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrowB
		/// </exception>
		/// <param name="resource">\[X</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>s</returns>
		public override Value Execute(Resource resource, int at)
		{
			Value val = condNode.Execute(resource, at);
			if (val != null && val.IsTrue)
                foreach (Node node in nodeList)
                    node.Execute(resource, at);
			else if(nextNode != null)
				nextNode.Execute(resource, at);
			return null;
		}
	}
}
