#include <pspsdk.h>
#include <psptypes.h>
#include <pspkernel.h>
#include <pspdebug.h>

#include <psputilsforkernel.h>
#include <pspthreadman_kernel.h>



#include <pspsysclib.h>
#include <systemctrl.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>


PSP_MODULE_INFO("extBridge_Module", 0x5006, 1, 0);
PSP_MAIN_THREAD_ATTR(0);







enum tagCompressed_Type
{
	Compressed_ERR,
	Compressed_ZIP,
	Compressed_Deflate,
	Compressed_2RLZ,
	Compressed_KL4E,
	Compressed_KL3E,
};




int sceUtilsBufferCopyWithRange(void *inbuf, SceSize insize, void *outbuf, int outsize, int cmd);
int sceNwman_driver_9555D68D(void* buf, SceSize bufsize, int* retSize);
int sceMesgd_driver_102DC8AF(void* buf, SceSize bufsize, int* retSize);
int UtilsForKernel_6C6887EE(void *outbuf, u32 outcapacity, void *inbuf, void *unk);

#define	sceKernelKL4EDecode		UtilsForKernel_6C6887EE
#define	ARG_IBUF				(u8 *)arg[0]
#define	ARG_OBUF				(u8 *)arg[1]
#define	ARG_OCAP				arg[2]




static int (*lzrc)(void *outbuf, u32 outcapacity, void *inbuf, void *unk) = NULL;
static int (*kl3e)(void *outbuf, u32 outcapacity, void *inbuf, void *unk) = NULL;



int DecodeInit()
{
	int ret = 0;

	if (sceKernelDevkitVersion() >= 0x03080000)
	{
		int i;
		u32 *code;
		u32 *mod = (u32 *)sceKernelFindModuleByName("sceNp9660_driver");
		
		if (mod)
		{
			code = (u32 *)mod[27];
			
			for (i = 0; i < 0x8000; i++)
			{
				if (code[i] == 0x27bdf4f0 && code[i+20] == 0x34018080)
				{
					lzrc = (void *)&code[i];
					break;
				} 
			}
			
			if (i == 0x8000)return -2;
		}
	}
	else
	{
		lzrc = (void *)sctrlHENFindFunction("sceSystemMemoryManager", "UtilsForKernel", 0x7DD07271);
	}

	SceModule *module = sceKernelFindModuleByName("sceLoadExec");

	if (module)
	{
		u32 *mod = (u32*)module;

		kl3e = (void*)*(mod+27);

		//ret = ( ( ) *(mod+27) + 0 )(outbuf, outcapacity,inbuf, NULL);
	}

	if( lzrc == NULL ) ret += 1;
	if( kl3e == NULL ) ret += 2;

	return ret;
}



int _Deflate(u32 *arg)
{
	int ret = sceKernelDeflateDecompress(ARG_OBUF, ARG_OCAP, ARG_IBUF, NULL);

	return ret;
}




int _Gzip(u32 *arg)
{
	int ret = sceKernelGzipDecompress(ARG_OBUF, ARG_OCAP, ARG_IBUF, NULL);

	return ret;
}


//sceKernelLzrcDecode
		
int _LZRC(u32 *arg)
{
	int ret = lzrc(ARG_OBUF, ARG_OCAP, ARG_IBUF,NULL);
	
	return ret;
}
		
int _KL4E(u32 *arg)
{
	int ret = sceKernelKL4EDecode(ARG_OBUF, ARG_OCAP, ARG_IBUF, NULL);
	
	return ret;
}
		
int _KL3E(u32 *arg)
{
	int ret = kl3e(ARG_OBUF, ARG_OCAP, ARG_IBUF, NULL);

	return ret;
}




int Decode(u8 *outbuf, u32 outcapacity,const u8 *inbuf,int type)
{
	int res = -1;
	void *func = NULL;
	
	u32 arg[] = { (u32)inbuf,(u32)outbuf,outcapacity };

	switch( type )
	{
		case Compressed_ZIP:	func = _Gzip;							break;
		case Compressed_Deflate:func = _Deflate;						break;
		case Compressed_2RLZ:	func = (lzrc == NULL ? NULL : _LZRC);	break;
		case Compressed_KL4E:	func = _KL4E;							break;
		case Compressed_KL3E:	func = (kl3e == NULL ? NULL : _KL3E);	break;
	}

	if( func )
	{
		int k1 = pspSdkSetK1(0);
		res = sceKernelExtendKernelStack(0x2000, func, arg);
		pspSdkSetK1(k1);
	}

	return res;
}



int ku_sceUtilsBufferCopyWithRange(void *inbuf, SceSize insize, void *outbuf, int outsize, int cmd)
{
	int k1 = pspSdkSetK1(0);

	int ret = sceUtilsBufferCopyWithRange(inbuf,insize,outbuf,outsize,cmd);

	pspSdkSetK1(k1);

	return ret;
}






int ku_sceMesgd_driver_102DC8AF(void* buf, SceSize bufsize, int* retSize)
{
	int k1 = pspSdkSetK1(0);

	int ret = sceMesgd_driver_102DC8AF(buf,bufsize,retSize);

	pspSdkSetK1(k1);

	return ret;
}

int ku_sceNwman_driver_9555D68D(void* buf, SceSize bufsize, int* retSize)
{
	int k1 = pspSdkSetK1(0);

	int ret = sceNwman_driver_9555D68D(buf,bufsize,retSize);

	pspSdkSetK1(k1);

	return ret;
}




int module_start(SceSize args, void *argp)
{
	return 0;
}

int module_stop(void)
{
	return 0;
}

