#include "common.h"
#include "decompres.h"


////////// Decompression //////////





int pspIsCompressed(u8 *buf)
{
	int res	= Compressed_ERR;
	const char *type = NULL;
	
	if (buf[0] == 0x1F && buf[1] == 0x8B)
	{
		res = Compressed_ZIP;
		type ="ZIP";
	}
	else if(buf[0] == 0x78 && buf[1] == 0x9C)
	{
		res = Compressed_Deflate;
		type ="Deflate";
	}
	else if (memcmp(buf, "2RLZ", 4) == 0)
	{
		res = Compressed_2RLZ;
		type = "2RLZ";
	}
	else if (memcmp(buf, "KL4E", 4) == 0)
	{
		res = Compressed_KL4E;
		type = "KL4E";
	}
	else if (memcmp(buf, "KL3E", 4) == 0)
	{
		res = Compressed_KL3E;
		type = "KL3E";
	}

	//printf("comp type = %s\n",type);
		
	return res;
}


int pspDecompress(u8 *inbuf, u8 *outbuf, u32 outcapacity)
{
	int retsize	= -1;
	//int type = pspIsCompressed(inbuf);
	
	switch( pspIsCompressed(inbuf) )
	{
		case Compressed_ZIP:
		{
			retsize = GzipDecompress(outbuf, outcapacity,inbuf);
			break;
		}

		case Compressed_Deflate:
		{
			retsize = DeflateDecompress(outbuf, outcapacity,inbuf);
			break;
		}
		
		case Compressed_2RLZ:
		{
			retsize = LZRCDecode(outbuf, outcapacity,inbuf+4);
			break;
		}
		
		case Compressed_KL4E:
		{
			retsize = KL4EDecode(outbuf, outcapacity,inbuf+4);
			//ErrorExit(0,"Found KL3E\n");
			break;
		}
		
		case Compressed_KL3E:
		{
			retsize = KL3EDecode(outbuf, outcapacity,inbuf+4);
			break;
		}
	}

	//printf("comp ret = %X\n",type);
	
	return retsize;
}


