#ifndef LIB_DEC_H
#define LIB_DEC_H

#ifdef __cplusplus
extern "C" {
#endif



enum DECRYPT_ERR
{
	D_ERR_UNKNOWN_TAG			= -1,
	D_ERR_NOT_BIG_ENOUGH		= -2,
	D_ERR_NOT_ALIGNED			= -3,
	D_ERR_NO_ENOUGH_DATA		= -4,
	D_ERR_SCRAMBLE				= -5,
	D_ERR_SHA1_CALC				= -6,
	D_ERR_SHA1_INCORRECT		= -7,
	D_ERR_DECRYPT				= -8,

};

int pspDecryptPRX(u8 *inbuf, u8 *outbuf, u32 size);
int DecryptReboot(u8 *loadexec,int loadexec_size, u8* out,int out_size);

int pspDecryptIPL1(const u8* pbIn, u8* pbOut, int cbIn);
int pspLinearizeIPL2(const u8* pbIn, u8* pbOut, int cbIn);
int pspDecryptIPL3(const u8* pbIn, u8* pbOut, int cbIn);

int pspIsSignChecked(u8 *buf);
int pspSignCheck(u8 *buf);
int pspUnsignCheck(u8 *buf);

int pspDecryptTable(u8 *buf1, u8 *buf2, int size, int mode);



int KIRK(u32 *buf, int size, u32 code, u32 type, int cmd);


#define	KIRK_Decrypt(in,in_size,out,out_size)		ku_sceUtilsBufferCopyWithRange(in	,in_size	,out	,out_size	,0x01)
#define	KIRK_SHA1(in,in_size,out,out_size)			ku_sceUtilsBufferCopyWithRange(in	,in_size	,out	,out_size	,0x0B)
#define	KIRK_Random(buf)							ku_sceUtilsBufferCopyWithRange(buf	,0x14		,NULL	,0			,0xE)


#define	KIRK_Scramble(buf,size,code)				KIRK(buf	,size	,code	,5	, 0x07)
#define	KIRK_SignCheck(buf,size)					KIRK(buf	,size	,0x100	,4	, 0x05)
#define	KIRK_UnsignCheck(buf,size)					KIRK(buf	,size	,0x100	,5	, 0x08)


#ifdef __cplusplus
}
#endif

#endif