#include "unpackpsar.h"
#include "decompres.h"





//   printf("PSAR Dumper\n");
//   printf(" by PspPet\n");
//  
//printf("2.80 Decryption by Dark_AleX.\n");
//printf("3.00 Decryption by Team Noobz.\n");
//printf("3.03 + 3.10 + 3.30 Decryption by Team C+D.\n");
//printf("3.60 + 3.71 decryption by M33 Team.\n");
//
//printf("Press cross to dump encrypted with sigcheck and decrypted reboot.bin.\n");
//printf("Press circle to dump encrypted without sigcheck and decrypted reboot.bin.\n");
//printf("Press square to decrypt all.\n\n");


////////////////////////////////////////////////////////////////////
// big buffers for data. Some system calls require 64 byte alignment

// big enough for the full PSAR file



#define PSAR_BUFFER_SIZE	9400000	//9MB

#define	BUF_SIZE_g_dataOut	3000000	//3MB
#define	TABLE_SIZE			0x4000
#define	TABLE_COUNT			5
#define	BUF_SIZE_TABLE		(TABLE_SIZE * TABLE_COUNT)

#define	BUF_SIZE_TOTAL		(PSAR_BUFFER_SIZE + (BUF_SIZE_g_dataOut * 2) + BUF_SIZE_TABLE)


#define	com_table			(char*)(table_mem + TABLE_SIZE * 0)
#define	_1g_table			(char*)(table_mem + TABLE_SIZE * 1)
#define	_2g_table			(char*)(table_mem + TABLE_SIZE * 2)
#define	_3g_table			(char*)(table_mem + TABLE_SIZE * 3)
#define	_4g_table			(char*)(table_mem + TABLE_SIZE * 4)




#define SIZE_A				0x110 /* size of uncompressed file entry = 272 bytes */


#define	ErrUnpackPsar(fmt,...)		{									\
										printf( fmt, ## __VA_ARGS__ );	\
										goto Err_ExtractPsar;			\
									}									\


enum
{
	FILE_TABLE_COM,
	FILE_TABLE_1G,
	FILE_TABLE_2G,
	FILE_TABLE_3G,
	FILE_TABLE_4G,
};

typedef struct
{
	const char *ver;
	u8 mode;
}table_info;

static table_info table_list[] =
{
	{ "3.8"	, 1 },
	{ "3.9"	, 1 },
	{ "4.0"	, 2 },
	{ "5.0"	, 3 },
	{ "5.5"	, 3 },
	{ "6.0", 4 },
	{ "6.1", 4 },
	{ "6.2", 4 },
};



static void *table_mem	= NULL;
static int comtable_size = 0;
static int _1gtable_size = 0;
static int _2gtable_size = 0;
static int _3gtable_size = 0;
static int _4gtable_size = 0;




//#define OVERHEAD    0x150 /* size of encryption block overhead */
static int OVERHEAD;
static int iBase, cbChunk, oldschool;
static int psarPosition;
static int decrypted;





static int DecodeBlock(const u8* pIn, int cbIn, u8* pOut)
{
    // pOut also used as temporary buffer for mangled input
    // assert((((u32)pOut) & 0x3F) == 0); // must be aligned
	//printf("DecodeBlock(%p,%d,%p)\n",pIn,cbIn,pOut);

    int ret = -1;
    int cbOut;

	if( decrypted )
	{
		if( pIn != pOut )
		{
			memcpy(pOut, pIn, cbIn);
		}

		return cbIn;
	}

    memcpy(pOut, pIn, cbIn + 0x10); // copy a little more for $10 page alignment

    
    if( !oldschool )
	{
		u8 buffer[20+0x130];
		memcpy(buffer+20, pIn+0x20, 0x130);

		KIRK_Scramble((u32*)buffer,0x130,0x55);

		//printf("kirk = %d\n",ret);

		memcpy(pOut+0x20, buffer, 0x130);
	}

    if( *(u32 *)&pOut[0xD0] == 0x0E000000 )
    {
		ret = ku_sceMesgd_driver_102DC8AF(pOut, cbIn, &cbOut);
	}
	else if( *(u32 *)&pOut[0xD0] == 0x06000000 )
	{
		ret = ku_sceNwman_driver_9555D68D(pOut, cbIn, &cbOut);
	}
	else
	{
		printf("Unknown psar tag. = %X\n",*(u32 *)&pOut[0xD0]);
		return 0xFFFFFFFC;
	}	
        
    if( ret != 0 ) return ret; // error

	return cbOut;
}




int pspPSARInit(u8 *dataPSAR, u8 *dataOut, u8 *dataOut2)
{
    int cbOut;
	int i,ret = 0;
	char *version = NULL;

	if( *((u32*)dataPSAR) != SIGNATURE_PSAR )
    {
		//Err
		return -1;
    }

	// 3.5X M33, and 3.60 unofficial psar's
	decrypted = (*(u32 *)&dataPSAR[0x20] == 0x2C333333);

	if( decrypted )
	{
		OVERHEAD = 0;
	}
	else
	{
		OVERHEAD = 0x150;
	}
	
	/* bogus update */
	oldschool = (dataPSAR[4] == 1);
	
    // at the start of the PSAR file,  there are one or two special version data chunks
    // printf("Special PSAR records:\n");
    cbOut = DecodeBlock(&dataPSAR[0x10], OVERHEAD+SIZE_A, dataOut);

    if( cbOut <= 0 )
    {
		//Err
        return cbOut;
    }

    if( cbOut != SIZE_A )
    {
		//Err
        return -2;
    }

	// after first entry
    iBase = 0x10 + OVERHEAD + SIZE_A;
	// iBase points to the next block to decode (0x10 aligned)

	if( decrypted )
	{
		cbOut = DecodeBlock(&dataPSAR[0x10+OVERHEAD+SIZE_A], *(u32 *)&dataOut[0x90], dataOut2);

		if (cbOut <= 0)
		{
			//Err
			return -3;		
		}
		   
		iBase += OVERHEAD+cbOut; 

		//return 0;
		goto Success_pspPSARInit;
	}
	
	if( !oldschool )
	{
		// second block
		cbOut = DecodeBlock(&dataPSAR[0x10+OVERHEAD+SIZE_A], OVERHEAD+100, dataOut2);

		if( cbOut <= 0 )
		{
			//printf("Performing V2.70 test\n"); // version 2.7 is bigger
			cbOut = DecodeBlock(&dataPSAR[0x10+OVERHEAD+SIZE_A], OVERHEAD+144, dataOut2);

			if( cbOut <= 0 )
			{
				cbOut = DecodeBlock(&dataPSAR[0x10+OVERHEAD+SIZE_A], OVERHEAD+*(u16 *)&dataOut[0x90], dataOut2);

				if( cbOut <= 0 )
				{
					//Err
					return -4;
				}				
			}
		}
	}
       
	cbChunk = (cbOut + 15) & 0xFFFFFFF0;
	iBase += OVERHEAD+cbChunk; 
	psarPosition = 0;

Success_pspPSARInit:


	version = strrchr((char *)(dataOut + 0x10), ',');

	if( version )
	{
		version++;

		for( i = 0 ; i < sizeof(table_list)/sizeof(table_info) ; i++ )
		{
			if ( memcmp(version, table_list[i].ver , 2) == 0 )
			{
				ret = table_list[i].mode;
				break;
			}
		}
	}

	return ret;
}


int pspPSARGetNextFile(u8 *dataPSAR, int cbFile, u8 *dataOut, u8 *dataOut2, char *name, int *retSize, int *retPos, int *signcheck)
{
	int cbOut;
	int ret = -1;

	if( iBase >= (cbFile-OVERHEAD) )
	{
		ret = 0;
		goto Err_pspPSARGetNextFile;
	}

	cbOut = DecodeBlock(&dataPSAR[iBase-psarPosition], OVERHEAD+SIZE_A, dataOut);

	if( cbOut <= 0 || cbOut != SIZE_A ) goto Err_pspPSARGetNextFile;

	strcpy(name, (const char*)&dataOut[4]);
	u32* pl = (u32*)&dataOut[0x100];
	*signcheck = (dataOut[0x10F] == 2);
        
	// pl[0] is 0
	// pl[1] is the PSAR chunk size (including OVERHEAD)
	// pl[2] is true file size (TypeA=272=SIZE_A, TypeB=size when expanded)
	// pl[3] is flags or version?

	if( pl[0] != 0 ) goto Err_pspPSARGetNextFile;

	iBase += OVERHEAD + SIZE_A;
	u32 cbDataChunk = pl[1]; // size of next data chunk (including OVERHEAD)
	u32 cbExpanded = pl[2]; // size of file when expanded

	if( cbExpanded > 0 )
	{
		cbOut = DecodeBlock(&dataPSAR[iBase-psarPosition], cbDataChunk, dataOut);

		if( cbOut > 10 && dataOut[0] == 0x78 && dataOut[1] == 0x9C )
		{
			// standard Deflate header
			const u8* pbIn = &dataOut[2]; // after header
			int ret = DeflateDecompress(dataOut2, cbExpanded, pbIn /*, &pbEnd*/);
			
			if( ret == cbExpanded )
			{
                *retSize = ret;				
			}      
			else
			{
				goto Err_pspPSARGetNextFile;
			}
		}
		else
		{
			iBase -= (OVERHEAD + SIZE_A);
			goto Err_pspPSARGetNextFile;
		}
	}
	else if( cbExpanded == 0 )
	{
        *retSize = 0; 
		// Directory	
	}
	else
	{
		goto Err_pspPSARGetNextFile;
	}
        
	iBase += cbDataChunk; 
	*retPos = iBase;

	ret = 1;
	
Err_pspPSARGetNextFile:

	return ret; // morefiles
}





static int FindTablePath(char *table, int table_size, char *number, char *szOut)
{
	int i, j, k;

	for(i = 0; i < table_size-5; i++)
	{
		if( strncmp(number, table+i, 5) == 0 )
		{
			for(j = 0, k = 0; ; j++, k++)
			{
				if( table[i+j+6] < 0x20 )
				{
					szOut[k] = 0;
					break;
				}

				if( table[i+5] == '|' && !strncmp(table+i+6, "flash", 5) &&	j == 6 )
				{
					szOut[6] = ':';
					szOut[7] = '/';
					k++;
				}
				else if( table[i+5] == '|' && !strncmp(table+i+6, "ipl", 3) && j == 3 )
				{
					szOut[3] = ':';
					szOut[4] = '/';
					k++;
				}
				else
				{				
					szOut[k] = table[i+j+6];
				}
			}

			return 1;
		}
	}

	return 0;
}




void ExtractReboot(const char *loadexec,const char *reboot,u8 *buf1,int buf1_size,u8 *buf2,int buf2_size)
{
	char path[512];
	int size;

	sprintf(path, "%s%s", getPathRoot(),loadexec);

	size = GetSize(path);

	int res = ReadFile(path, buf1, 0, size) ;

	if( res == size )
	{
		res = DecryptReboot(buf1,size, buf2,buf2_size) ;
		printf("ret = %d\n",res);

		sprintf(path, "%s%s", getPathRoot(),reboot);
		
		if( res > 0 ) WriteFile(path, buf2, res);
	}
}








static int is5Dnum(char *str)
{
	int len = strlen(str);
	
	if (len != 5)
		return 0;
	
	int i;
	
	for (i = 0; i < len; i++)
	{
		if (str[i] < '0' || str[i] > '9')
			return 0;
	}
	
	return 1;
}




static int FoundFile(char* name)
{
	int ret = 0;
	int found = 0;

	//ee[ut@CT

	if( is5Dnum(name) && strcmp(name, "00001") != 0 && strcmp(name, "00002") != 0 && strcmp(name, "00003") != 0 && strcmp(name, "00004") != 0 )
	{
		if( _1gtable_size > 0 )
		{
			found = FindTablePath(_1g_table, _1gtable_size, name, name);
		}
		
		if( !found && _2gtable_size > 0 )
		{
			found = FindTablePath(_2g_table, _2gtable_size, name, name);
		}
		
		if( !found && _3gtable_size > 0 )
		{
			found = FindTablePath(_3g_table, _3gtable_size, name, name);
		}
		
		if( !found && _4gtable_size > 0 )
		{
			found = FindTablePath(_4g_table, _4gtable_size, name, name);
		}

		if( !found ) ret = -2;
	}
	else if( is5Dnum(name+4) && ( !strncmp(name, "com:", 4) || !strncmp(name, "01g:", 4) || !strncmp(name, "02g:", 4) ))
	{
		if( comtable_size > 0 )
		{
			found = FindTablePath(com_table, comtable_size, name+4, name);
		}

		if( !found && _1gtable_size > 0 )
		{
			found = FindTablePath(_1g_table, _1gtable_size, name+4, name);
		}

		if( !found && _2gtable_size > 0 )
		{
			found = FindTablePath(_2g_table, _2gtable_size, name+4, name);
		}

		if( !found && strncmp(name, "com:", 4) != 0 ) ret = -1;
	}
	//else
	//{
	//	return 0;
	//}

	return ret;
}

static int ExpandTable( char* file ,u8 *buf1 ,u8 *buf2 ,int size ,int mode )
{
	int isTable = -1;
	int ret = 0;

	if(	!strcmp(file, "com:00000") )
	{
		isTable = FILE_TABLE_COM;
	}
	else if( !strcmp(file, "01g:00000") || !strcmp(file, "00001") )
	{
		isTable= FILE_TABLE_1G;
	}
	else if( !strcmp(file, "02g:00000") || !strcmp(file, "00002") )
	{
		isTable = FILE_TABLE_2G;
	}
	else if( !strcmp(file, "00003") )
	{
		isTable= FILE_TABLE_3G;
	}
	else if( !strcmp(file, "00004") )
	{
		isTable = FILE_TABLE_4G;
	}

	if( isTable == -1 ) return 0;

	int *table_size = NULL;
	char *table_buf = NULL;

	switch( isTable )
	{
		case FILE_TABLE_COM	:
		{
			table_size	= &comtable_size;
			table_buf	= com_table;
			break;
		}

		case FILE_TABLE_1G	:
		{
			table_size	= &_1gtable_size;
			table_buf	= _1g_table;
			break;
		}

		case FILE_TABLE_2G	:
		{
			table_size	= &_2gtable_size;
			table_buf	= _2g_table;
			break;
		}

		case FILE_TABLE_3G	:
		{
			table_size	= &_3gtable_size;
			table_buf	= _3g_table;
			break;
		}

		case FILE_TABLE_4G	:
		{
			table_size	= &_4gtable_size;
			table_buf	= _4g_table;
			break;
		}
	}

	*table_size = pspDecryptTable(buf1, buf2, size, mode);
	
	if( *table_size <= 0 )
	{
		ret = -1;
	}
	else if( *table_size > TABLE_SIZE )
	{
		ret = -2;
	}
	else
	{
		memcpy(table_buf, buf1, *table_size);
		ret = 1;
	}

	return ret;
}




void UnpacktPsar(const char *path_in ,int mode)
{
	u8 *g_dataPSAR	= NULL;
	u8 *g_dataOut	= NULL;
	u8 *g_dataOut2	= NULL;
	table_mem		= NULL;

	pbp_header header;

	SceUID fd = -1;
	u32 psar_pos = 0;
	char name[128];
	int res ,pos ,signcheck ,cbFile ,error = 0,table_mode,cbExpanded;


	if( sceKernelTotalFreeMemSize() < BUF_SIZE_TOTAL ||  sceKernelMaxFreeMemSize() < PSAR_BUFFER_SIZE ) return;

	g_dataPSAR	= memoryAllocEx( "buf_psar"	, MEMORY_USER, 0x40	, PSAR_BUFFER_SIZE, PSP_SMEM_Low );
	g_dataOut	= memoryAllocEx( "buf_out1"	, MEMORY_USER, 0x40	, BUF_SIZE_g_dataOut, PSP_SMEM_Low );
	g_dataOut2	= memoryAllocEx( "buf_out2"	, MEMORY_USER, 0x40	, BUF_SIZE_g_dataOut, PSP_SMEM_Low );
	table_mem	= memoryAlloc( BUF_SIZE_TABLE );

	if( g_dataPSAR == NULL || g_dataOut == NULL || g_dataOut2 == NULL || table_mem == NULL ) ErrUnpackPsar("Work Buffer Alloc Err\n");


	Log(1,"Loading psar... = %s\n",path_in);
	
	//PBPwb_[̓ǂݍ
	if ( ReadFile(path_in, &header, 0,  sizeof(header)) != sizeof(header) ) ErrUnpackPsar("Cannot find EBOOT.PBP at root.\n"); 
	
	fd = sceIoOpen(path_in, PSP_O_RDONLY, 0);

	if( fd < 0 ) ErrUnpackPsar("Cannot Open EBOOT.PBP\n"); 
	
	cbFile = sceIoLseek32(fd, 0, PSP_SEEK_END) - header.pos_psar;
	sceIoLseek32(fd, header.pos_psar, PSP_SEEK_SET);

	if( sceIoRead(fd, g_dataPSAR, PSAR_BUFFER_SIZE) <= 0 ) ErrUnpackPsar("Error Reading EBOOT.PBP.\n");

	
	Log(1,"PSAR file loaded (%d bytes)\n", cbFile);
	
	table_mode = pspPSARInit(g_dataPSAR, g_dataOut, g_dataOut2);

	if( table_mode < 0 ) ErrUnpackPsar("pspPSARInit failed with error 0x%08X!.\n", table_mode);
	
	Log(1,"table_mode = %d\n", table_mode);
	

    Sync_sceIoMkdir(getPathRoot(),"F0", 0777);
	Sync_sceIoMkdir(getPathRoot(),"F0/PSARDUMPER", 0777);
	Sync_sceIoMkdir(getPathRoot(),"F0/data", 0777);
	Sync_sceIoMkdir(getPathRoot(),"F0/dic", 0777);
	Sync_sceIoMkdir(getPathRoot(),"F0/font", 0777);
	Sync_sceIoMkdir(getPathRoot(),"F0/kd", 0777);
	Sync_sceIoMkdir(getPathRoot(),"F0/vsh", 0777);
	Sync_sceIoMkdir(getPathRoot(),"F0/data/cert", 0777);
	Sync_sceIoMkdir(getPathRoot(),"F0/kd/resource", 0777);
	Sync_sceIoMkdir(getPathRoot(),"F0/vsh/etc", 0777);
	Sync_sceIoMkdir(getPathRoot(),"F0/vsh/module", 0777);
	Sync_sceIoMkdir(getPathRoot(),"F0/vsh/resource", 0777);
	Sync_sceIoMkdir(getPathRoot(),"F0/codepage", 0777);
	
	
    while( (res = pspPSARGetNextFile(g_dataPSAR, cbFile, g_dataOut, g_dataOut2, name, &cbExpanded, &pos, &signcheck)) != 0 )
	{
		if( res < 0 )
		{
			if( error ) ErrUnpackPsar("PSAR decode error, pos=0x%08X.\n", pos);
			
			int dpos = pos-psar_pos;
			psar_pos = pos;
			
			error = 1;
			memmove(g_dataPSAR, g_dataPSAR+dpos, PSAR_BUFFER_SIZE-dpos);
			
			if (sceIoRead(fd, g_dataPSAR+(PSAR_BUFFER_SIZE-dpos), dpos) <= 0) ErrUnpackPsar("Error Reading EBOOT.PBP.\n");
			
			psarPosition = psar_pos;

			continue;
		}

		int found = FoundFile(name);

		if( found == -1 )
		{
			ErrUnpackPsar("Error: cannot find path of %s.\n", name);
		}
		else if( found == -2 )
		{
			printf("Warning: cannot find path of %s\n", name);
			error = 0;
			continue;
		}
		
		//t@C\
        Log(1,name);

		
		if( cbExpanded > 0 )
		{
			char szDataPath[128];
			
			if( !strncmp(name, "flash0:/", 8) )
			{
				sprintf(szDataPath, "%sF0/%s",getPathRoot(), name+8);
			}
			else if( !strncmp(name, "flash1:/", 8) )
			{
				sprintf(szDataPath, "%sF1/%s", getPathRoot(),name+8);
			}
			else
			{
				int ret = ExpandTable( name, g_dataOut2, g_dataOut, cbExpanded, table_mode );

				if( ret == 1 )
				{
					sprintf(szDataPath, "%sF0/PSARDUMPER/%s_files_table.bin", getPathRoot(),name);
				}
				else if( ret == -1 )
				{
					ErrUnpackPsar("Cannot decrypt %s table.\n",name);
				}
				else if( ret == -2 )
				{
					ErrUnpackPsar("%s table buffer too small. Recompile with bigger buffer.\n",name);
				}
				else if ( ret == 0 )
				{
					sprintf(szDataPath, "%sF0/PSARDUMPER/%s", getPathRoot(),strrchr(name, '/') + 1);
				}
			}

			
			Log(0,",expanded");
			
			if( signcheck && mode == MODE_ENCRYPT_SIGCHECK )
			{
				pspSignCheck(g_dataOut2);
			}
			
			if( mode != MODE_DECRYPT || *((u32*)g_dataOut2) != SIGNATURE_PSP /*memcmp(g_dataOut2, "~PSP", 4) != 0*/ )
			{
				if (strstr(szDataPath, "ipl") && (strstr(szDataPath, "2000") || strstr(szDataPath, "02h") || strstr(szDataPath, "02g")))
				{
					printf("file = %s\n",name);
					//char name2[128];
					//sprintf(name2,"%s_",szDataPath);
					//WriteFile(name2, g_dataOut2, cbExpanded)  ;
				
					// IPL Pre-decryption
					cbExpanded = pspDecryptPRX(g_dataOut2, g_dataOut, cbExpanded);
					
					if (cbExpanded <= 0)
					{
						printf("Warning: cannot pre-decrypt 2000 IPL.\n");
					}
					else
					{
						memcpy(g_dataOut2, g_dataOut, cbExpanded);
					}
				}
				
				if( WriteFile(szDataPath, g_dataOut2, cbExpanded) != cbExpanded ) ErrUnpackPsar("Cannot write %s.\n", szDataPath);
				
				Log(0,",saved");
			}
			
			if( memcmp(g_dataOut2, "~PSP", 4) == 0 && mode == MODE_DECRYPT )
			{
				int cbDecrypted = pspDecryptPRX(g_dataOut2, g_dataOut, cbExpanded);
				
				// output goes back to main buffer
				// trashed 'g_dataOut2'
				if( cbDecrypted > 0 )
				{
					u8* pbToSave = g_dataOut;
					int cbToSave = cbDecrypted;
					
					Log(0,",decrypted");
                    
					if( pspIsCompressed( g_dataOut ) != Compressed_ERR )
					{
						int cbExp = pspDecompress(g_dataOut, g_dataOut2, BUF_SIZE_g_dataOut);
						
						if( cbExp > 0 )
						{
							Log(0,",expanded");
							pbToSave = g_dataOut2;
							cbToSave = cbExp;
						}
						else
						{
							printf("Decompress error 0x%08X\n" "File will be written compressed.\n", cbExp);
						}
					}
        			
					if( WriteFile(szDataPath, pbToSave, cbToSave) != cbToSave ) ErrUnpackPsar("Error writing %s.\n", szDataPath);
                    
					Log(0,",saved!");
				}
				else
				{
					Log(0,",failed decrypted.");
				}
			}
			else if( strncmp(name, "ipl:", 4) == 0 )
			{
				char* szFileBase = strrchr(name, '/');
				
				if( szFileBase != NULL )
				{
					szFileBase++;  // after slash
				}
				else
				{
					szFileBase = "err.err";
				}

				sprintf(szDataPath, "%sF0/PSARDUMPER/part1_%s",getPathRoot(), szFileBase);
				
				int cb1 = pspDecryptIPL1(g_dataOut2, g_dataOut, cbExpanded);

				if( cb1 > 0 && (WriteFile(szDataPath, g_dataOut, cb1) == cb1) )
				{
					int cb2 = pspLinearizeIPL2(g_dataOut, g_dataOut2, cb1);

					sprintf(szDataPath, "%sF0/PSARDUMPER/part2_%s",getPathRoot(), szFileBase);
					WriteFile(szDataPath, g_dataOut2, cb2);
					
					int cb3 = pspDecryptIPL3(g_dataOut2, g_dataOut, cb2);

					sprintf(szDataPath, "%sF0/PSARDUMPER/part3_%s",getPathRoot(), szFileBase);
					WriteFile(szDataPath,  g_dataOut, cb3);
				}
			}
		}
		else if( cbExpanded == 0 )
		{
			Log(0,",empty");
		}
		
		Log(0,"\n");

		error = 0;
		scePowerTick(0);
	}
	
	// reboot.bin ̒o
	ExtractReboot("F0/kd/loadexec.prx"		, "F0/reboot_01g.bin"	,g_dataOut,BUF_SIZE_g_dataOut,g_dataPSAR,PSAR_BUFFER_SIZE);
	ExtractReboot("F0/kd/loadexec_01g.prx"	, "F0/reboot_01g.bin"	,g_dataOut,BUF_SIZE_g_dataOut,g_dataPSAR,PSAR_BUFFER_SIZE);
	ExtractReboot("F0/kd/loadexec_02g.prx"	, "F0/reboot_02g.bin"	,g_dataOut,BUF_SIZE_g_dataOut,g_dataPSAR,PSAR_BUFFER_SIZE);
	ExtractReboot("F0/kd/loadexec_03g.prx"	, "F0/reboot_03g.bin"	,g_dataOut,BUF_SIZE_g_dataOut,g_dataPSAR,PSAR_BUFFER_SIZE);
	ExtractReboot("F0/kd/loadexec_04g.prx"	, "F0/reboot_04g.bin"	,g_dataOut,BUF_SIZE_g_dataOut,g_dataPSAR,PSAR_BUFFER_SIZE);


Err_ExtractPsar:

	if( fd >= 0	   ) sceIoClose(fd);
	if( g_dataPSAR ) memoryFree(g_dataPSAR);
	if( g_dataOut  ) memoryFree(g_dataOut);
	if( g_dataOut2 ) memoryFree(g_dataOut2);
	if( table_mem  ) memoryFree(table_mem);

}


//int IsTableFile( const char *name )
//{
//	int ret = -1;
//
//	if(	!strcmp(name, "com:00000") )
//	{
//		ret = FILE_TABLE_COM;
//	}
//	else if( !strcmp(name, "01g:00000") || !strcmp(name, "00001") )
//	{
//		ret = FILE_TABLE_1G;
//	}
//	else if( !strcmp(name, "02g:00000") || !strcmp(name, "00002") )
//	{
//		ret = FILE_TABLE_2G;
//	}
//	else if( !strcmp(name, "00003") )
//	{
//		ret = FILE_TABLE_3G;
//	}
//	else if( !strcmp(name, "00004") )
//	{
//		ret = FILE_TABLE_4G;
//	}
//
//	return ret;
//}

			//int table = IsTableFile(name);

			//
			//if( !strncmp(name, "flash0:/", 8) )
			//{
			//	sprintf(szDataPath, "%sF0/%s",GetWriteRoot(), name+8);
			//}
			//else if( !strncmp(name, "flash1:/", 8) )
			//{
			//	sprintf(szDataPath, "%sF1/%s", GetWriteRoot(),name+8);
			//}
			//else if( table != -1 )
			//{
			//	int *table_size = NULL;
			//	char *table_buf = NULL;

			//	switch( table )
			//	{
			//		case TABLE_COM	:
			//		{
			//			table_size	= &comtable_size;
			//			table_buf	= com_table;
			//			break;
			//		}

			//		case TABLE_1G	:
			//		{
			//			table_size	= &_1gtable_size;
			//			table_buf	= _1g_table;
			//			break;
			//		}

			//		case TABLE_2G	:
			//		{
			//			table_size	= &_2gtable_size;
			//			table_buf	= _2g_table;
			//			break;
			//		}

			//		case TABLE_3G	:
			//		{
			//			table_size	= &_3gtable_size;
			//			table_buf	= _3g_table;
			//			break;
			//		}

			//		case TABLE_4G	:
			//		{
			//			table_size	= &_4gtable_size;
			//			table_buf	= _4g_table;
			//			break;
			//		}
			//	}


			//	*table_size = pspDecryptTable(g_dataOut2, g_dataOut, cbExpanded, table_mode);
			//	
			//	if( *table_size <= 0 ) ErrUnpackPsar("Cannot decrypt %s table.\n",name);
			//	
			//	if( *table_size > BUF_SIZE_TABLE ) ErrUnpackPsar("%s table buffer too small. Recompile with bigger buffer.\n",name);
			//	
			//	memcpy(table_buf, g_dataOut2, *table_size);

			//	sprintf(szDataPath, "%sF0/PSARDUMPER/%s_files_table.bin", GetWriteRoot(),name);
			//}
			//else
			//{
			//	sprintf(szDataPath, "%sF0/PSARDUMPER/%s", GetWriteRoot(),strrchr(name, '/') + 1);
			//}


		//if( (is5Dnum(name) || is5Dnum(name+4)) && strcmp(name, "00001") != 0 && strcmp(name, "00002") != 0 && strcmp(name, "00003") != 0 && strcmp(name, "00004") != 0 )
		//{
		//	int found = 0;
		//	printf("%s\n",name);
		//	
		//	//e[u(1g,2g,3g,4g)t@CT

		//	if( !strncmp(name, "com:", 4) || !strncmp(name, "01g:", 4) || !strncmp(name, "02g:", 4) )
		//	{
		//		//printf("%s\n",name+4);

		//		if( comtable_size > 0 )
		//		{
		//			found = FindTablePath(com_table, comtable_size, name+4, name);
		//		}

		//		if( !found && _1gtable_size > 0 )
		//		{
		//			found = FindTablePath(_1g_table, _1gtable_size, name+4, name);
		//		}

		//		if( !found && _2gtable_size > 0 )
		//		{
		//			found = FindTablePath(_2g_table, _2gtable_size, name+4, name);
		//		}

		//		if( !found && strncmp(name, "com:", 4) != 0 ) ErrUnpackPsar("Error: cannot find path of %s.\n", name);
		//	}
		//	else
		//	{
		//		//printf("%s\n",name);

		//		if( _1gtable_size > 0 )
		//		{
		//			found = FindTablePath(_1g_table, _1gtable_size, name, name);
		//		}
		//		
		//		if( !found && _2gtable_size > 0 )
		//		{
		//			found = FindTablePath(_2g_table, _2gtable_size, name, name);
		//		}
		//		
		//		if( !found && _3gtable_size > 0 )
		//		{
		//			found = FindTablePath(_3g_table, _3gtable_size, name, name);
		//		}
		//		
		//		if( !found && _4gtable_size > 0 )
		//		{
		//			found = FindTablePath(_4g_table, _4gtable_size, name, name);
		//		}

		//		if( !found )
		//		{
		//			printf("Warning: cannot find path of %s\n", name);
		//			//sceKernelDelayThread(2*1000*1000);
		//			error = 0;
		//			continue;
		//		}
		//	}
		//}

	//int VolatileMemSize;

	//printf("ext mem try = 0x%08X\n",res);
	//printf("pasr = 0x%08X\n" "dataout = 0x%08X\n" "table = 0x%08X\n",(u32)g_dataPSAR,(u32)g_dataOut,(u32)table_mem);
	//ꃁobt@2Ɋ蓖Ă
	//res = sceKernelVolatileMemTryLock(0, (void *)&g_dataOut2, &VolatileMemSize);
	//sceKernelVolatileMemLock(0, (void *)&g_dataOut2, &VolatileMemSize);
	//printf("Alloc Extora Mem = %d\n",s);
	//sceKernelDelayThread(10000000);

	//if( g_dataOut2 ) sceKernelVolatileMemUnlock(0);


		//else if( res == 0 ) /* no more files */
		//{
		//	break;
		//}

		//if( is5Dnum(name) )
		//{
		//}


//void pspPSARSetBufferPosition(int position)
//{
//	psarPosition = position;
//}




		//else if( !strncmp(name, "com:", 4) && comtable_size > 0 )
		//{
		//	printf("%s\n",name+4);

		//	if( !FindTablePath(com_table, comtable_size, name+4, name) )
		//	{
		//		printf("Warning: cannot find path of %s\n", name);
		//		//sceKernelDelayThread(2*1000*1000);
		//		error = 0;
		//		continue;
		//		//ErrorExit(5000, "Error: cannot find path of %s.\n", name);
		//	}
		//}
		//else if( !strncmp(name, "01g:", 4) && _1gtable_size > 0 )
		//{
		//	printf("%s\n",name+4);

		//	if( !FindTablePath(_1g_table, _1gtable_size, name+4, name) ) ErrUnpackPsar("Error: cannot find path of %s.\n", name);
		//}
		//else if( !strncmp(name, "02g:", 4) && _2gtable_size > 0 )
		//{
		//	printf("%s\n",name+4);

		//	if( !FindTablePath(_2g_table, _2gtable_size, name+4, name) ) ErrUnpackPsar("Error: cannot find path of %s.\n", name);
		//}

			//else if( !strcmp(name, "com:00000") )
			//{
			//	comtable_size = pspDecryptTable(g_dataOut2, g_dataOut, cbExpanded, table_mode);
			//	
			//	if( comtable_size <= 0 ) ErrUnpackPsar("Cannot decrypt common table.\n");
			//	
			//	if( comtable_size > BUF_SIZE_TABLE ) ErrUnpackPsar("Com table buffer too small. Recompile with bigger buffer.\n");
			//	
			//	memcpy(com_table, g_dataOut2, comtable_size);

			//	sprintf(szDataPath, "%sF0/PSARDUMPER/common_files_table.bin", GetWriteRoot());
			//}
			//else if( !strcmp(name, "01g:00000") || !strcmp(name, "00001") )
			//{
			//	_1gtable_size = pspDecryptTable(g_dataOut2, g_dataOut, cbExpanded, table_mode);
			//		
			//	if( _1gtable_size <= 0 ) ErrUnpackPsar("Cannot decrypt 1g table.\n");
			//	
			//	if( _1gtable_size > BUF_SIZE_TABLE ) ErrUnpackPsar("1g table buffer too small. Recompile with bigger buffer.\n");
			//	
			//	memcpy(_1g_table, g_dataOut2, _1gtable_size);

			//	sprintf(szDataPath, "%sF0/PSARDUMPER/1000_files_table.bin", GetWriteRoot());
			//}
			//else if( !strcmp(name, "02g:00000") || !strcmp(name, "00002") )
			//{
			//	_2gtable_size = pspDecryptTable(g_dataOut2, g_dataOut, cbExpanded, table_mode);
			//				
			//	if ( _2gtable_size <= 0 ) ErrUnpackPsar("Cannot decrypt 2g table %08X.\n", _2gtable_size);
			//	
			//	if ( _2gtable_size > BUF_SIZE_TABLE ) ErrUnpackPsar("2g table buffer too small. Recompile with bigger buffer.\n");
			//	
			//	memcpy(_2g_table, g_dataOut2, _2gtable_size);

			//	sprintf(szDataPath, "%sF0/PSARDUMPER/2000_files_table.bin", GetWriteRoot());
			//}
			//else if( !strcmp(name, "00003") )
			//{
			//	_3gtable_size = pspDecryptTable(g_dataOut2, g_dataOut, cbExpanded, table_mode);
			//				
			//	if( _3gtable_size <= 0 )
			//	{
			//		// We don't have yet the keys for table of 3000, they are only in mesg_led03g.prx
			//		printf("Cannot decrypt 3g table %08X.\n", _3gtable_size);
			//		error = 0;
			//		continue;
			//	}
			//	
			//	if( _3gtable_size > BUF_SIZE_TABLE ) ErrUnpackPsar("3g table buffer too small. Recompile with bigger buffer.\n");
			//	
			//	memcpy(_3g_table, g_dataOut2, _3gtable_size);

			//	sprintf(szDataPath, "%sF0/PSARDUMPER/3000_files_table.bin", GetWriteRoot());
			//}
			//else if( !strcmp(name, "00004") )
			//{
			//	_4gtable_size = pspDecryptTable(g_dataOut2, g_dataOut, cbExpanded, table_mode);
			//				
			//	if( _4gtable_size <= 0 )
			//	{
			//		printf("Cannot decrypt 4g table %08X.\n", _4gtable_size);
			//		error = 0;
			//		continue;
			//	}
			//	
			//	if( _4gtable_size > BUF_SIZE_TABLE ) ErrUnpackPsar("4g table buffer too small. Recompile with bigger buffer.\n");
			//	
			//	memcpy(_4g_table, g_dataOut2, _4gtable_size);

			//	sprintf(szDataPath, "%sF0/PSARDUMPER/4000_files_table.bin", GetWriteRoot());
			//}