#ifndef TOOL_COMMON_H
#define TOOL_COMMON_H

#ifdef __cplusplus
extern "C" {
#endif


#include <pspsdk.h>
#include <pspkernel.h>
#include <pspdebug.h>
#include <pspctrl.h>
#include <pspsuspend.h>
#include <psppower.h>
#include <psprtc.h>




#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <math.h>



#include "../Bridge/main.h"
#include "decrypt.h"


#define printf    pspDebugScreenPrintf


#define	SIGNATURE_ERR	0x00000000
#define	SIGNATURE_PSP	0x5053507E	//~PSP
#define	SIGNATURE_PBP	0x50425000	//.PBP
#define	SIGNATURE_ELF	0x464C457F	//.ELF
#define	SIGNATURE_PSAR	0x52415350	//PSAR
#define	SIGNATURE_PSF	0x46535000	//.PSF
#define	SIGNATURE_SCE	0x4543537E	//~SCE


#define	OFS_FILE_SIZE	0xB0
#define	OFS_FILE_TAG	0xD0

#define	PSP_MODULE_VSH	0x0800
#define	PSP_MODULE_DEMO	0x0200
#define	PSP_MODULE_POPS	0x0200


#define	WRITE_TARGET_PC	"host0:/"
#define	WRITE_TARGET_MS	"ms0:/"


#define	EXT_PATH_ROOT	"ms0:/PSPExT"
#define	EXT_PATH(X)		EXT_PATH_ROOT X
#define	FILE_TMP_NAME	EXT_PATH("/tmp")
//#define	FILE_TMP2_NAME	"ms0:/PSPExT/tmp2"

#define MEMORY_PAGE_SIZE					256
#define MEMORY_ALIGN_ADDR( align, addr )	( ( (uintptr_t)( addr ) + ( align ) - 1 ) & ( ~( ( align ) - 1 ) ) )
#define MEMORY_POWER_OF_TWO( x )			( ! ( ( x ) & ( ( x ) - 1 ) ) )



#define	COLOR_R	0x0000FF
#define	COLOR_G	0x00FF00
#define COLOR_B	0xFF0000

#define	COLOR_W	0xFFFFFF


#define	DARKBLUE		0x800000          //  F
#define	LIGHTBLUE		0xFA0000          //  F
#define	BROWN			0x404080          //  F
#define	PINK			0xFF80FF          //  F
#define	DARKGREEN		0x008000          //  [ΐF
#define	YELLOGREEN		0x00FF80          //  ΐF
#define	PURPLE			0xFF0080          //  F
#define	ORANGE			0x4080FF          //  F
#define	LEMON			0x80FFFF          //  F
#define	YELLOW			0x00FFFF          //  F
#define	SKYBLUE			0xFFFF00          //  F
#define	PEARLORANGE		0x75BAFF          //  F
#define	GRAY			0x808080          //  DF
#define	SILVER			0xC0C0C0          //  F
#define	GOLD			0x20C0E6          //  F


//extern const char *root;

typedef enum
{
	WMODE_PC,
	WMODE_MS
} WMODE;


typedef struct
{
	u32	signature;	//0x00
	u32	unk;		//0x04
	u32	pos_sfo;	//0x08
	u32	pos_icon0;	//0x0C
	u32	pos_icon1;	//0x10
	u32	pos_pic0;	//0x14
	u32	pos_pic1;	//0x18
	u32	pos_snd0;	//0x1C
	u32	pos_psp;	//0x20
	u32	pos_psar;	//0x24
} __attribute__((packed)) pbp_header;



typedef struct extDirEnt
{
	SceIoDirent entry;
	struct extDirEnt *ent_next;
	struct extDirEnt *ent_prev;
} extDirEnt;

typedef struct
{
	SceUID dp;
	extDirEnt *ent_root;
	extDirEnt *ent_old;
	//char root[128];
} extDirObj;

#define	FIO_S_INVALID 0x00000000

enum extErr
{
	extErr_GetFSize	= -1,
	extErr_GetSig	= -2,
	extErr_GetPbpH	= -3,
	extErr_GetTag	= -4,
	extErr_UnkTag	= -5,
	extErr_UnkSig	= -6,
	extErr_Pack		= -7,
	extErr_Unpack	= -8,
	extErr_NotElf	= -9,
	extErr_NotPsp	= -10,
	extErr_NotPack	= -11,
	//extErr_MakeH	= -12,
	extErr_Packed	= -13,
	extErr_Write	= -14,
	extErr_GetElfH	= -15,
	extErr_GetMInfo	= -16,
	extErr_GetSg	= -17,
	extErr_GetSc	= -18,
	extErr_GetSList	= -19,
	extErr_VshPrx	= -20,
	extErr_PbpK		= -21,
	extErr_PbpAttr	= -22,
	extErr_BssNotF	= -23,
	extErr_NotSup	= -24,
	extErr_MPspH	= -24,
};



enum
{
	MODE_DEFLATE,
	MODE_INFLATE
};

typedef enum
{
	MEMORY_KERN_HI = 1,
	MEMORY_USER,
	MEMORY_KERN_HI_MIRROR,
	MEMORY_KERN_LO,
	MEMORY_VOLATILE,
	MEMORY_USER_MIRROR
} MemoryPartition;



//void read_dir(const char *path);


int Sync_sceIoMkdir(const char *root,const char *dir,SceMode mode);
void ErrorExit(int milisecs, char *fmt, ...);

int ReadFile(const char *file,  void *buf, SceSize seek, SceSize size);
int Write(u8 flag, SceUID fd_out, const char *file, void *buf, int size);
u32 WriteAppend(u8 type_file, u8 flag, const char *out, SceUID fd_out, const char *in, int seek, u8 *buf, SceSize size);



#define	WriteFile(name, buf, size)						Write(0	,-1		,name	,buf	,size)
#define	WriteFileUID(uid, buf, size)					Write(1	,uid	,NULL	,buf	,size)
#define WriteBufAppend(out, buf, size)					WriteAppend(0	,0	,out	,-1		,NULL	,0		,buf	,size)
#define	WriteBufAppendUID(uid, buf, size)				WriteAppend(0	,1	,NULL	,uid	,NULL	,0		,buf	,size)
#define	WriteFileAppend(out, in, seek, size)			WriteAppend(1	,0	,out	,-1		,in		,seek	,NULL	,size)
#define	WriteFileAppendUID(uid, in, seek, size)			WriteAppend(1	,1	,NULL	,uid	,in		,seek	,NULL	,size)


u32 gz(u8 type, const char *file_out, SceUID fd,const char *file_in,  int seek_in, int size_in );


#define	gzComppresFile(out,in,  seek_in, size_in)		gz(MODE_DEFLATE	,out	,-1		,in	,seek_in	,size_in)
#define	gzComppresUID(uid, in, seek_in, size_in)		gz(MODE_DEFLATE	,NULL	,uid	,in	,seek_in	,size_in)
#define	gzDeComppresFile(out,in,  seek_in, size_in)		gz(MODE_INFLATE	,out	,-1		,in	,seek_in	,size_in)
#define	gzDeComppresUID(uid, in, seek_in, size_in)		gz(MODE_INFLATE	,NULL	,uid	,in	,seek_in	,size_in)




SceSize GetSize( const char *file );

const char* bulidOutPath( const char *file );

void setPathRoot( const char *path );
void setPathTmp( const char *path );
const char* getPathRoot();
const char* getPathTmp();

void Log(u8 use_time, const char *format, ...);




void* memoryAlloc( SceSize size );
void* memoryAllocEx( const char *name, MemoryPartition partition, unsigned int align, SceSize size, int type );
int memoryFree( void *memblock );

int GetFileSig( const char *file ,int seek );

extDirObj* extDirOpen(const char *path);
extDirEnt* extDirNext( extDirObj *obj );
void extDirClose( extDirObj *obj );
int extDirEntType( extDirEnt *ent );

#ifdef __cplusplus
}
#endif

#endif