﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

namespace PsychlopsSilverlight4.Pages
{
	public partial class BinomialSolver : ChildWindow
	{
		System.Windows.Shapes.Line line;
		int func_selected;
		Psychlops.Solver.Constants.Func1 func1;
		Psychlops.Solver.Constants.Func2 func2;
		Psychlops.Solver.Constants.Func3 func3;


		public ObservableCollection<Data> data = new ObservableCollection<Data>();
		public ObservableCollection<Data> fitted = new ObservableCollection<Data>();
		public ObservableCollection<Data> data_ { get { return data; } }
		public ObservableCollection<Data> fitted_ { get { return fitted; } }


		public BinomialSolver(Psychlops.Solver.Constants.Func1 f)
		{
			InitializeComponent();
			initialize();
			func_selected = 1;
			func1 = f;
		}
		public BinomialSolver(Psychlops.Solver.Constants.Func2 f)
		{
			InitializeComponent();
			initialize();
			func_selected = 2;
			func2 = f;
		}
		public BinomialSolver(Psychlops.Solver.Constants.Func3 f)
		{
			InitializeComponent();
			initialize();
			func_selected = 3;
			func3 = f;
		}
		public void initialize()
		{
			dataGrid.RowHeight = 20;
			data = Data.GetDataList();
			dataGrid.ItemsSource = data;

			chart1.DataContext = data;
			solver = new Psychlops.Solver.BinomialLikelihood();
			line = new Line();
			line.X1 = 0;
			line.Y1 = 0;
			line.X2 = ChartCanvas.ActualWidth;
			line.Y2 = 0;
			ChartCanvas.Children.Add(line);
			OText.DataContext = OrdinateSlider;
		}
		public class Data
		{
			public double c_abscissa { get; set; }
			public double c_ratio { get; set; }
			public double abscissa { get; set; }
			public int positive { get; set; }
			public int negative { get; set; }
			public double ratio { get { return (double)(positive) / (positive+negative); } }


			public Data(double absc, int posi, int nega)
			{
				this.abscissa = absc;
				this.positive = posi;
				this.negative = nega;
				c_abscissa = 0.0;
				c_ratio = 0.0;
			}

			public static ObservableCollection<Data> GetDataList()
			{
				return new ObservableCollection<Data>(new Data[] {
					new Data(-5, 0, 10),
					new Data(0, 1, 9),
					new Data(1, 3, 7),
					new Data(2, 5, 5),
					new Data(3, 7, 3),               
					new Data(5, 9, 1),                
					new Data(10, 10, 0)                
				});
			}
		}

		private void OKButton_Click(object sender, RoutedEventArgs e)
		{
			this.DialogResult = true;
		}

		double minimum, maximum;
		Psychlops.Solver.BinomialLikelihood solver;
		private void CalcButton_Click(object sender, RoutedEventArgs e)
		{
			var ber = new Psychlops.Solver.BernoulliProcess();
			ber.elems = new Psychlops.Solver.BernoulliProcess.Data[data.Count];
			int i = 0;

			minimum = Double.PositiveInfinity;
			maximum = Double.NegativeInfinity;
			foreach (var d in data)
			{
				if (d.abscissa < minimum) { minimum = d.abscissa; }
				if (d.abscissa > maximum) { maximum = d.abscissa; }
				ber.elems[i].x = d.abscissa;
				ber.elems[i].pos = d.positive;
				ber.elems[i].neg = d.negative;
				i++;
			}

			solver.data = ber;


			Psychlops.Interval itvl = new Psychlops.Interval();
			solver.itvl[0] = (-100 <= itvl <= 100);
			solver.itvl[1] = (-100 <= itvl <= 100);
			solver.itvl[2] = (-100 <= itvl <= 100);

			switch (func_selected)
			{
				case 1:
					solver.begin(func1);
					break;
				case 2:
					solver.begin(func2);
					break;
				case 3:
					solver.begin(func3);
					break;
			}

			reFunc();
		}
		private void reFunc()
		{
			Data dd;
			fitted = new ObservableCollection<Data>();
			foreach (var d in data)
			{
				dd = new Data(d.abscissa, d.positive, d.negative);
				dd.c_abscissa = minimum;
				dd.c_ratio = 0.0;
				fitted.Add(dd);
			}
			switch (func_selected)
			{
				case 1:
					for (double j = minimum; j < maximum; j += (maximum - minimum)/ 100 )
					{
						dd = new Data(0, 0, 0);
						dd.c_abscissa = j;
						dd.c_ratio = func1(j, solver.champ[0]);
						fitted.Add(dd);
					}
					break;
				case 2:
					for (double j = minimum; j < maximum; j += (maximum - minimum)/ 100 )
					{
						dd = new Data(0, 0, 0);
						dd.c_abscissa = j;
						dd.c_ratio = func2(j, solver.champ[0], solver.champ[1]);
						fitted.Add(dd);
					}
					break;
				case 3:
					for (double j = minimum; j < maximum; j += (maximum - minimum)/ 100 )
					{
						dd = new Data(0, 0, 0);
						dd.c_abscissa = j;
						dd.c_ratio = func3(j, solver.champ[0], solver.champ[1], solver.champ[2]);
						fitted.Add(dd);
					}
					break;
			}


			chart1.DataContext = null;
			chart1.DataContext = fitted;

			OrdinateSlider.Maximum = 1.0;
			OrdinateSlider.Minimum = 0.0;
			OrdinateSlider.Value = 0.5;

			AbscissaSlider.Maximum = maximum;
			AbscissaSlider.Minimum = minimum;
			AbscissaSlider.Value = solver.champ[0];

			Parameter0.Text = String.Format("{0:D4}", solver.champ[0].ToString());
			Parameter1.Text = String.Format("{0, 4:F}", solver.champ[1].ToString());

			//chart1.UpdateLayout();
		}

		private void AddConditionButton_Click(object sender, RoutedEventArgs e)
		{
			data.Add(new Data(0, 0, 0));
			this.UpdateLayout();
		}

		private void RemoveConditionButton_Click(object sender, RoutedEventArgs e)
		{
			data.RemoveAt(data.Count-1);
			this.UpdateLayout();
		}

		private void OrdinateSlider_MouseLeftButtonUp(object sender, MouseButtonEventArgs e)
		{
			if (solver.champ[0] == 0.0) return;
			int dir = 1, pdir, dirr=0, ii = 0;
			double d = (maximum - minimum) * 0.25;
			double refval = OrdinateSlider.Value;
			double x1 = solver.champ[0], x2= x1 + d, v1, v2, tmp;
			switch (func_selected)
			{
				case 1:
					break;
				case 2:
					while (dirr < 32)
					{
						pdir = dir;
						v1 = Math.Abs(refval - func2(x1, solver.champ[0], solver.champ[1]));
						v2 = Math.Abs(refval - func2(x2, solver.champ[0], solver.champ[1]));
						if (v1 > v2)
						{
							tmp = x2;
							x1 = x2;
							x2 = tmp + d;
							dir = 1;
						}
						else
						{
							tmp = x1;
							x2 = x1;
							x1 = tmp - d;
							dir = -1;
						}
						if (ii>32 || dir != pdir) { d /= 2; dirr++; ii = 0; }
						ii++;
					}
					break;
				case 3:
					break;
			}

			AbscissaSlider.Value = (x1+x2)/2.0;
			Parameter0.Text = AbscissaSlider.Value.ToString();
			line.Y1 = refval * 200;
			line.Y2 = refval * 200;
		}

	}
}

