﻿using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Windows.Browser;

using System.Collections.Generic;
 


namespace Psychlops
{

	internal static partial class CONST
	{
		internal static readonly Int32 MAX_OBJ_N = 1500;
		internal static readonly Int32 MOBJ_N = 1000;
		internal static readonly Int32 COBJ_N = 300;
		internal static readonly Int32 HOBJ_N = 100;
	}

	namespace Templates
	{

		public class StackableDrawable : Drawable
		{
//			protected System.Collections.Generic.Queue<Internal.PrimitiveFigure> stack;
			internal Internal.PrimitiveFigure[] stack;
			internal int stackN = 0;
			internal Line[] lineStack;
			internal int lineStackN = 0;
			internal Rectangle[] rectStack;
			internal int rectStackN = 0;
			internal ShaderField[] shaderStack;
			internal int shaderStackN = 0;
			internal Ellipse[] ellipseStack;
			internal int ellipseStackN = 0;
			internal Polygon[] polygonStack;
			internal int polygonStackN = 0;
			internal Letters[] lettersStack;
			internal int lettersStackN = 0;
			internal Image[] imageStack;
			internal int imageStackN = 0;
			internal Group[] groupStack;
			internal int groupStackN = 0;

			public StackableDrawable()
			{
				stack = new Internal.PrimitiveFigure[CONST.MAX_OBJ_N];
				lineStack = new Line[CONST.MOBJ_N];
				rectStack = new Rectangle[CONST.MOBJ_N];
				ellipseStack = new Ellipse[CONST.MOBJ_N];
				shaderStack = new ShaderField[CONST.COBJ_N];
				polygonStack = new Polygon[CONST.COBJ_N];
				lettersStack = new Letters[CONST.COBJ_N];
				imageStack = new Image[CONST.HOBJ_N];
				groupStack = new Group[CONST.HOBJ_N];
				for (int i = 0; i < CONST.MOBJ_N; i++)
				{
					lineStack[i] = new Line(0,0,0,0);
					rectStack[i] = new Rectangle();
					ellipseStack[i] = new Ellipse();
				}
				for (int i = 0; i < CONST.COBJ_N; i++)
				{
					shaderStack[i] = new ShaderField();
					polygonStack[i] = new Polygon();
					lettersStack[i] = new Letters();
				}
				for (int i = 0; i < CONST.HOBJ_N; i++)
				{
					imageStack[i] = new Image();
//					groupStack[i] = new Group();
				}


			}

			public void clear() { clear(Color.black); }
			public virtual void clear(Color col) { } //rect(back_panel, col); }
			public virtual void pix(int x, int y, Color col) { }
			public virtual void line(Line drawee) { drawee.copyToStack(this); }
			public virtual void rect(Rectangle drawee) { drawee.copyToStack(this); }
			public virtual void ellipse(Ellipse drawee) { drawee.copyToStack(this); }
			public virtual void oval(Ellipse drawee) { drawee.copyToStack(this); }
			public virtual void polygon(Polygon drawee) { drawee.copyToStack(this); }
			public virtual void letters(Letters drawee) { drawee.copyToStack(this); }
			public virtual void image(Image drawee) { drawee.copyToStack(this); }
			public virtual void group(Group drawee) { drawee.copyToStack(this); }
			public virtual void shader(ShaderField drawee) { drawee.copyToStack(this); }

			public void msg(string str, double x, double y) { msg(str, x, y, Color.white); }
			public virtual void msg(string dstr, double x, double y, Color col)
			{
				var let = new Letters(dstr);
				let.locate(x, y);
				let.fill = col;
				this.letters(let);
			}
			public void var<Type>(Type val, double x, double y) { msg(val.ToString(), x, y, Color.white); }
			public void var<Type>(Type val, double x, double y, Color col) { msg(val.ToString(), x, y, col); }

			public virtual Point getCenter() { return new Point(0, 0, 0); }
		}

	}

	public class Canvas : Templates.StackableDrawable
	{
		internal System.Windows.Controls.Canvas masterPool, prevPool;
		internal System.Windows.Point[] pointPool;
		internal int pointPoolN;
		internal SolidColorBrush[] brushPool;
		internal int brushPoolN;

		internal System.Windows.Controls.Canvas[] UIElementPool;
		internal int UIElementPoolN;
		internal int lastVisibleN;

		internal System.Windows.Shapes.Line[] linePool;
		internal int linePoolN;
		internal System.Windows.Shapes.Rectangle[] dummyRectPool;
		internal System.Windows.Shapes.Rectangle[] rectPool;
		internal int rectPoolN;
		internal System.Windows.Shapes.Rectangle[] shaderPool;
		internal int shaderPoolN;
		internal System.Windows.Shapes.Ellipse[] ellipsePool;
		internal int ellipsePoolN;
		internal System.Windows.Shapes.Polygon[] polygonPool;
		internal int polygonPoolN;
		internal System.Windows.Controls.TextBlock[] lettersPool;
		internal int lettersPoolN;
		internal System.Windows.Controls.Image[] imagePool;
		internal int imagePoolN;
		internal Dictionary<int, bool> imagePoolT;
		internal System.Windows.Controls.Canvas[] groupPool;
		internal int groupPoolN;

		#region initializer

		Action flipexec;
		public static IList<Action> initialize_at_canvas_initialize__ = new List<Action>();

		public static System.Windows.Controls.UserControl default_panel;
		public static System.Windows.Controls.Canvas default_api_canvas;
		public static WriteableBitmap default_buffer;
		internal System.Windows.Controls.Canvas api_canvas;
		internal System.Windows.Controls.UserControl panel;
		Rectangle back_panel;
		double width_, height_;
		Clock before;

		public Canvas(int wid, int hei)
		{
			panel = default_panel;
			api_canvas = default_api_canvas;
			initialize(wid, hei);
		}
		public Canvas(int wid, int hei, System.Windows.Controls.Canvas apicnvs, System.Windows.Controls.UserControl system)
		{
			panel = system;
			api_canvas = apicnvs;
			initialize(wid, hei);
		}

		protected bool AsyncInitBool;
		internal void beginInvoke(Action a) { api_canvas.Dispatcher.BeginInvoke(a); }
		protected void initialize(int wid, int hei)
		{
			before = new Clock();
			before.update();
			var after = new Clock();
			AsyncInitBool = false;
			width_ = wid;
			height_ = hei;
			api_canvas.Dispatcher.BeginInvoke(new Action<int,int>(initialize__), wid, hei);
			while (!AsyncInitBool)
			{
				after.update();
				if ((after - before).at_msec() > 1000) break;
			}
			Mouse._prime = api_canvas;
			Main.drawable = this;
			Main.canvas = this;

			back_panel = new Rectangle(wid, hei);

			flipexec = new Action(executeFlip);
		}
		protected void initialize__(int wid, int hei)
		{
			api_canvas.Width = wid;
			api_canvas.Height = hei+20;
			api_canvas.MouseMove += Mouse.Canvas_MousePos;
			api_canvas.MouseLeftButtonDown += Mouse.Canvas_LDown;
			api_canvas.MouseLeftButtonUp += Mouse.Canvas_LUp;
			api_canvas.MouseWheel += Mouse.Canvas_MouseWheel;
			panel.KeyDown += Keyboard.Canvas_KeyDown;
			panel.KeyUp += Keyboard.Canvas_KeyUp;

			HtmlElement htmlHost = HtmlPage.Document.GetElementById("silverlightControlHost");
			//if (htmlHost != null) HtmlPage.Window.Alert("silverlightControlHost is null");
			htmlHost.SetStyleAttribute("width", (wid).ToString()+"px");
			htmlHost.SetStyleAttribute("height", (hei).ToString() + "px");
			htmlHost.SetStyleAttribute("margin", "2em auto auto auto");

			pointPool = new System.Windows.Point[CONST.MOBJ_N];
			brushPool = new SolidColorBrush[CONST.MOBJ_N];
			linePool = new System.Windows.Shapes.Line[CONST.MOBJ_N];
			rectPool = new System.Windows.Shapes.Rectangle[CONST.MOBJ_N];
			ellipsePool = new System.Windows.Shapes.Ellipse[CONST.MOBJ_N];
			for (int i = 0; i < CONST.MOBJ_N; i++)
			{
				pointPool[i] = new System.Windows.Point();
				brushPool[i] = new SolidColorBrush();
				linePool[i] = new System.Windows.Shapes.Line();
				rectPool[i] = new System.Windows.Shapes.Rectangle();
				ellipsePool[i] = new System.Windows.Shapes.Ellipse();
			}
			shaderPool = new System.Windows.Shapes.Rectangle[CONST.COBJ_N];
			polygonPool = new System.Windows.Shapes.Polygon[CONST.COBJ_N];
			lettersPool = new System.Windows.Controls.TextBlock[CONST.COBJ_N];
			for (int i = 0; i < CONST.COBJ_N; i++)
			{
				shaderPool[i] = new System.Windows.Shapes.Rectangle();
				polygonPool[i] = new System.Windows.Shapes.Polygon();
				lettersPool[i] = new System.Windows.Controls.TextBlock();
			}
			imagePool = new System.Windows.Controls.Image[CONST.HOBJ_N];
			imagePoolT = new Dictionary<int, bool>(CONST.HOBJ_N);
			groupPool = new System.Windows.Controls.Canvas[CONST.HOBJ_N];
			for (int i = 0; i < CONST.HOBJ_N; i++)
			{
				imagePool[i] = new System.Windows.Controls.Image();
				imagePoolT.Add(imagePool[i].GetHashCode(), false);
				groupPool[i] = new System.Windows.Controls.Canvas();
			}

			masterPool = new System.Windows.Controls.Canvas();
			prevPool = new System.Windows.Controls.Canvas();
			api_canvas.Children.Add(masterPool);

			//api_canvas.Children.Remove(Internal.Main.widgetStack);
			Psychlops.Internal.Main.widgetStack = new StackPanel();
			Psychlops.Internal.Main.widgetStack.Orientation = Orientation.Vertical;
			Psychlops.Internal.Main.widgetStack.Height = hei;
			api_canvas.Children.Add(Psychlops.Internal.Main.widgetStack);
			Internal.Main.statusBar.Visibility = Visibility.Collapsed;


			UIElementPool = new System.Windows.Controls.Canvas[CONST.MAX_OBJ_N];
			dummyRectPool = new System.Windows.Shapes.Rectangle[CONST.MAX_OBJ_N];
			for (int i = 0; i < CONST.MAX_OBJ_N; i++)
			{
				UIElementPool[i] = new System.Windows.Controls.Canvas();
				masterPool.Children.Add(UIElementPool[i]);
				dummyRectPool[i] = new System.Windows.Shapes.Rectangle();
				UIElementPool[i].Children.Add(dummyRectPool[i]);
				dummyRectPool[i].Visibility = Visibility.Collapsed;
			}

			AsyncInitBool = true;

			// initialize at Canvas initializing
			//Figures.ShaderGabor.initialize__();
		}

		internal int findEmptyInPool(Dictionary<int, bool> pool)
		{
			/*
			foreach( KeyValuePair<int, bool> elem in pool)
			{
				if(elem) 
			}*/
			return 0;
		}

		#endregion

		#region static initializer
		/*
		static Canvas()
		{
		}
		*/
		#endregion


		public override void clear(Color col)
		{
			back_panel.fill = col;
			stackN = 0;
			rect(back_panel);
		}

		int nextIntervalFrame = 1, chacked = 0;
		public void flip(int n)
		{
			lock (this)
			{
				nextIntervalFrame = n;
				chacked = 1;
			}
			//pointStackN = 0;
			lineStackN = 0;
			rectStackN = 0;
			shaderStackN = 0;
			polygonStackN = 0;
			ellipseStackN = 0;
			lettersStackN = 0;
			imageStackN = 0;
			groupStackN = 0;

			UIElementPoolN = 0;
			brushPoolN = 0;
			/*
			pointPoolN = 0;
			brushPoolN = 0;
			linePoolN = 0;
			rectPoolN = 0;
			ellipsePoolN = 0;
			polygonPoolN = 0;
			lettersPoolN = 0;
			imagePoolN = 0;
			groupPoolN = 0;
			 * */

			//executeFlip();
			Internal.Main.canvas_flag.WaitOne();
		}
		public void flip()
		{
			flip(1);
		}


		#region version modifyNative2
		public void executeFlip()
		{
//			Clock after = new Clock();
//			after.update();
//			AppState.statusBar = ((after - before).at_msec().ToString()) + " msec";

			Line lineS;
			ShaderField shaderS;
			Rectangle rectS;
			Ellipse ellipseS;
			Polygon polygonS;
			Letters lettersS;
			Image imageS;
			Group groupS;
			System.Windows.Shapes.Line lineP;
			System.Windows.Shapes.Rectangle rectP;
			System.Windows.Shapes.Rectangle shaderP;
			System.Windows.Shapes.Ellipse ellipseP;
			System.Windows.Shapes.Polygon polygonP;
			System.Windows.Controls.TextBlock lettersP;
			System.Windows.Controls.Image imageP;
			System.Windows.Controls.Canvas groupP;

			lock (this)
			{
				nextIntervalFrame--;
			}

			var cnv = UIElementPool[0];
			if (nextIntervalFrame <= 0)
			{
				if (chacked > 0)
				{
					if (stackN > 0)
					{
						for (int i = 0; i < stackN; i++)
						{
							if (null != (shaderS = stack[i] as ShaderField))
							{
								if (null != (shaderP = cnv.Children[0] as System.Windows.Shapes.Rectangle))
								{
									shaderS.modifyNative(shaderP, this);
								}
								else
								{
									cnv.Children.Clear();
									cnv.Children.Add(stack[i].poolNative(this));
								}
							}
							else if( null != (rectS = stack[i] as Rectangle) )
							{
								if (null != (rectP = cnv.Children[0] as System.Windows.Shapes.Rectangle))
								{
									rectS.modifyNative(rectP, this);
								}
								else
								{
									cnv.Children.Clear();
									cnv.Children.Add(stack[i].poolNative(this));
								}
							}
							else if (null != (lineS = stack[i] as Line))
							{
								if (null != (lineP = cnv.Children[0] as System.Windows.Shapes.Line))
								{
									lineS.modifyNative(lineP, this);
								}
								else
								{
									cnv.Children.Clear();
									cnv.Children.Add(stack[i].poolNative(this));
								}
							}
							else if (null != (ellipseS = stack[i] as Ellipse))
							{
								if (null != (ellipseP = cnv.Children[0] as System.Windows.Shapes.Ellipse))
								{
									ellipseS.modifyNative(ellipseP, this);
								}
								else
								{
									cnv.Children.Clear();
									cnv.Children.Add(stack[i].poolNative(this));
								}
							}
							else if (null != (polygonS = stack[i] as Polygon))
							{
								if (null != (polygonP = cnv.Children[0] as System.Windows.Shapes.Polygon))
								{
									polygonS.modifyNative(polygonP, this);
								}
								else
								{
									cnv.Children.Clear();
									cnv.Children.Add(stack[i].poolNative(this));
								}
							}
							else if (null != (lettersS = stack[i] as Letters))
							{
								if (null != (lettersP = cnv.Children[0] as System.Windows.Controls.TextBlock))
								{
									lettersS.modifyNative(lettersP, this);
								}
								else
								{
									cnv.Children.Clear();
									cnv.Children.Add(stack[i].poolNative(this));
								}
							}
							else if (null != (imageS = stack[i] as Image))
							{
								if (null != (imageP = cnv.Children[0] as System.Windows.Controls.Image))
								{
									imageS.modifyNative(imageP, this);
								}
								else
								{
									cnv.Children.Clear();
									cnv.Children.Add(stack[i].poolNative(this));
								}
							}
							else if (null != (groupS = stack[i] as Group))
							{
								if (null != (groupP = cnv.Children[0] as System.Windows.Controls.Canvas))
								{
									groupS.modifyNative(groupP, this);
								}
								else
								{
									cnv.Children.Clear();
									cnv.Children.Add(stack[i].poolNative(this));
								}
							}
							cnv.Visibility = Visibility.Visible;
							UIElementPoolN++;
							cnv = UIElementPool[UIElementPoolN];
						}
						for (int i = UIElementPoolN; i < lastVisibleN; i++)
						{
							cnv = UIElementPool[i];
							cnv.Visibility = Visibility.Collapsed;
						}
						lastVisibleN = UIElementPoolN;
						stackN = 0;
					}
					lock (this)
					{
						chacked = 0;
					}
					Psychlops.Internal.Main.canvas_flag.Set();
				}
			}
			System.Threading.Thread.Sleep(0);
		}
		#endregion



		#region version modifyNative
		/*
		public void executeFlip()
		{
			Line lineS;
			Rectangle rectS;
			Ellipse ellipseS;
			Polygon polygonS;
			Letters lettersS;
			Image imageS;
			Group groupS;
			System.Windows.Shapes.Line lineP;
			System.Windows.Shapes.Rectangle rectP;
			System.Windows.Shapes.Ellipse ellipseP;
			System.Windows.Shapes.Polygon polygonP;
			System.Windows.Controls.TextBlock lettersP;
			System.Windows.Controls.Image imageP;
			System.Windows.Controls.Canvas groupP;

			lock (this)
			{
				nextIntervalFrame--;
			}

			var en = masterPool.Children.GetEnumerator();
			bool full = en.MoveNext();
			if (nextIntervalFrame <= 0)
			{
				if (chacked > 0)
				{
					//masterPool.Children.Clear();
					if (stackN > 0)
					{
						for (int i = 0; i < stackN - 2; i++)
						{
							if (full == false)
							{
								masterPool.Children.Add(stack[i].poolNative(this));
							}
							else
							{
								if( null != (rectS = stack[i] as Rectangle) )
								{
									if (null != (rectP = en.Current as System.Windows.Shapes.Rectangle))
									{
										rectS.modifyNative(rectP, this);
									}
								}
								else if (null != (lineS = stack[i] as Line))
								{
									if (null != (lineP = en.Current as System.Windows.Shapes.Line))
									{
										lineS.modifyNative(lineP, this);
									}
								}
								else if (null != (ellipseS = stack[i] as Ellipse))
								{
									if (null != (ellipseP = en.Current as System.Windows.Shapes.Ellipse))
									{
										ellipseS.modifyNative(ellipseP, this);
									}
									else
									{
										masterPool.Children.Add(stack[i].poolNative(this));
									}
								}
								else if (null != (polygonS = stack[i] as Polygon))
								{
									if (null != (polygonP = en.Current as System.Windows.Shapes.Polygon))
									{
										polygonS.modifyNative(polygonP, this);
									}
								}
								else if (null != (lettersS = stack[i] as Letters))
								{
									if (null != (lettersP = en.Current as System.Windows.Controls.TextBlock))
									{
										lettersS.modifyNative(lettersP, this);
									}
								}
								else if (null != (imageS = stack[i] as Image))
								{
									if (null != (imageP = en.Current as System.Windows.Controls.Image))
									{
										imageS.modifyNative(imageP, this);
									}
								}
								else if (null != (groupS = stack[i] as Group))
								{
									if (null != (groupP = en.Current as System.Windows.Controls.Canvas))
									{
										groupS.modifyNative(groupP, this);
									}
								}
								full = en.MoveNext();
							}
						}
						stackN = 0;
					}
					lock (this)
					{
						chacked = 0;
					}
					Psychlops.Internal.Main.canvas_flag.Set();
				}
			}
			System.Threading.Thread.Sleep(0);
		}
		 * */
		#endregion

		#region version poolNative 2
		/*
		public void executeFlip()
		{

			lock (this)
			{
				nextIntervalFrame--;
			}
			UIElementPoolN = 0;
			if (nextIntervalFrame <= 0)
			{
				if (chacked > 0)
				{
					//masterPool.Children.Clear();
					if (stackN > 0)
					{
						for (int i = 0; i < stackN - 2; i++)
						{
							UIElementPool[UIElementPoolN] = stack[i].poolNative(this);
							UIElementPool[UIElementPoolN].Visibility = Visibility.Visible;
							UIElementPoolN++;

						}
						for (int i = stackN - 2; i < 10000; i++)
						{
							UIElementPool[UIElementPoolN] = rectPool[i];
							UIElementPool[UIElementPoolN].Visibility = Visibility.Collapsed;
							UIElementPoolN++;
						}
						stackN = 0;
					}
					lock (this)
					{
						chacked = 0;
					}
					Psychlops.Internal.Main.canvas_flag.Set();
				}
			}
			System.Threading.Thread.Sleep(0);
		}
		*/
		#endregion


		#region Properties

		public double width { get { return width_; } }
		public double height { get { return height_; } }
		public Point center { get { return new Point(width / 2.0, height / 2.0, 0); } }
		public double getWidth() { return width; }
		public double getHeight() { return height; }
		public override Point getCenter() { return center; }
		public double getHCenter() { return width / 2; }
		public double getVCenter() { return height / 2; }
		public double getRefreshRate() { return 60; }

		#endregion


		#region compatibitily trick

		public enum Mode { window, fullscreen }
		public static readonly Mode window = Mode.window, fullscreen = Mode.fullscreen;

		public Canvas(int wid, int hei, Mode mod)
		{
			panel = default_panel;
			api_canvas = default_api_canvas;
			initialize(500, 500);
		}
		public Canvas(Mode mod)
			: base()
		{
			panel = default_panel;
			api_canvas = default_api_canvas;
			initialize(500, 500);
		}

		public Canvas(int wid, int hei, Mode mod, Display.DisplayName name)
		{
			panel = default_panel;
			api_canvas = default_api_canvas;
			initialize(500, 500);
		}
		public Canvas(Mode mod, Display.DisplayName name)
			: base()
		{
			panel = default_panel;
			api_canvas = default_api_canvas;
			initialize(500, 500);
		}


		public void showFPS(bool sw = true) { }
		public void watchFPS(bool sw = true) { }


		public void clear(double lum)
		{
			clear(new Color(lum));
		}

		#endregion


	}



	#region primitive tokenizer


	#region primitive

	partial struct Point
	{
		public static implicit operator System.Windows.Point(Point d)
		{
			return new System.Windows.Point(d.x, d.y);
		}


		public Point datum { get { return this; } set { this = value; } }
		public Point shift(Point p) { this = this + p; return this; }
		public Point centering(Point p) { this = p; return this; }
		public Point getDatum() { return this; }
		public Point setDatum(Point p) { this = p; return p; }
		public Point shift(double x, double y, double z = 0.0) { return shift(new Point(x, y, z)); }
		public Point centering() { return centering(Main.drawable.getCenter()); }
		public Point centering(double x, double y, double z = 0.0) { return centering(new Point(x, y, z)); }
	}

	partial struct Color
	{
		public static implicit operator System.Windows.Media.Color(Color d)
		{
			return System.Windows.Media.Color.FromArgb((byte)(d.a * 255), (byte)(d.r * 255), (byte)(d.g * 255), (byte)(d.b * 255));
		}
		public static implicit operator System.Windows.Media.SolidColorBrush(Color d)
		{
			return new SolidColorBrush { Color = d };
		}
		public System.Windows.Media.SolidColorBrush getNativeFromStack(Canvas d)
		{
			var tmp = d.brushPool[d.brushPoolN];
			tmp.Color = this;
			d.brushPoolN++;
			return tmp;
		}

	}

	partial struct Stroke
	{
		public void apply(System.Windows.Shapes.Shape target)
		{
			target.Stroke = this;
			//target.StrokeDashArray
			target.StrokeThickness = thick;
		}
		public static implicit operator SolidColorBrush(Stroke d)
		{
			return new SolidColorBrush { Color = d.color };
		}
		public System.Windows.Media.SolidColorBrush getNativeFromStack(Canvas d)
		{
			var tmp = d.brushPool[d.brushPoolN];
			tmp.Color = this.color;
			d.brushPoolN++;
			return tmp;
		}
	}
	
	#endregion
	
	#region Line

	partial class Line
	{
		public Line dup()
		{
			return (Line)MemberwiseClone();
		}
		public Line clone()
		{
			return (Line)MemberwiseClone();
		}
		public static implicit operator System.Windows.Shapes.Line(Line d)
		{
			var tmp =  new System.Windows.Shapes.Line() { X1 = d.begin.x, Y1 = d.begin.y, X2 = d.end.x, Y2 = d.end.y };
			if (d.stroke.thick == 0.0) tmp.Stroke = d.fill;
			else d.stroke.apply(tmp);
			return tmp;
		}
		public UIElement toNative() { return this; }

		public void copyToStack(Templates.StackableDrawable d)
		{
			var tmp = d.lineStack[d.lineStackN];
			tmp.begin.x = begin.x;
			tmp.begin.y = begin.y;
			tmp.end.x = end.x;
			tmp.end.y = end.y;
			tmp.fill = fill;
			tmp.stroke = stroke;
			d.stack[d.stackN] = tmp;
			d.lineStackN++;
			d.stackN++;
		}
		public UIElement poolNative(Canvas d)
		{
			var tmp = d.linePool[d.linePoolN];
			tmp.X1 = begin.x;
			tmp.Y1 = begin.y;
			tmp.X2 = end.x;
			tmp.Y2 = end.y;
			if (stroke.thick == 0.0) tmp.Stroke = fill.getNativeFromStack(d);
			else stroke.apply(tmp);
			System.Windows.Controls.Canvas.SetLeft(tmp, left);
			System.Windows.Controls.Canvas.SetTop(tmp, top);
			tmp.Visibility = Visibility.Visible;
			d.linePoolN++;
			return tmp;
		}
		public void modifyNative(System.Windows.Shapes.Line tmp, Canvas d)
		{
			tmp.X1 = begin.x;
			tmp.Y1 = begin.y;
			tmp.X2 = end.x;
			tmp.Y2 = end.y;
			if (stroke.thick == 0.0) tmp.Stroke = fill.getNativeFromStack(d);
			else stroke.apply(tmp);
			System.Windows.Controls.Canvas.SetLeft(tmp, left);
			System.Windows.Controls.Canvas.SetTop(tmp, top);
			tmp.Visibility = Visibility.Visible;
		}
	}
	
	#endregion
		
	#region Rectangle

	partial class Rectangle
	{
		public Rectangle dup()
		{
			return (Rectangle)MemberwiseClone();
		}
		public Rectangle clone()
		{
			return (Rectangle)MemberwiseClone();
		}
		public static implicit operator System.Windows.Rect(Rectangle d)
		{
			return new System.Windows.Rect(d.v1.x, d.v1.y, d.v2.x, d.v2.y);
		}
		public static implicit operator System.Windows.Shapes.Rectangle(Rectangle d)
		{
			var tmp = new System.Windows.Shapes.Rectangle { Width = d.width, Height = d.height, Fill = d.fill };
			d.stroke.apply(tmp);
			System.Windows.Controls.Canvas.SetLeft(tmp, d.left);
			System.Windows.Controls.Canvas.SetTop(tmp, d.top);
			return tmp;
		}

		public UIElement toNative() { return this; }
		public void copyToStack(Templates.StackableDrawable d)
		{
			var tmp = d.rectStack[d.rectStackN];
			tmp.v1 = v1;
			tmp.v2 = v2;
			tmp.fill = fill;
			d.stack[d.stackN] = tmp;
			d.rectStackN++;
			d.stackN++;
		}
		public UIElement poolNative(Canvas d)
		{
			var tmp = d.rectPool[d.rectPoolN];
			tmp.Width = width;
			tmp.Height = height;
			tmp.Fill = fill.getNativeFromStack(d);
			System.Windows.Controls.Canvas.SetLeft(tmp, left);
			System.Windows.Controls.Canvas.SetTop(tmp, top);
			tmp.Visibility = Visibility.Visible;
			d.rectPoolN++;
			return tmp;
		}
		public void modifyNative(System.Windows.Shapes.Rectangle tmp, Canvas d)
		{
			tmp.Width = width;
			tmp.Height = height;
			tmp.Fill = fill.getNativeFromStack(d);
			System.Windows.Controls.Canvas.SetLeft(tmp, left);
			System.Windows.Controls.Canvas.SetTop(tmp, top);
			tmp.Visibility = Visibility.Visible;
		}
	}
	
	#endregion
	
	#region ShaderField

	partial class ShaderField
	{
		public System.Windows.Media.Effects.Effect shader;
		protected static System.Windows.Media.SolidColorBrush dummyfill = null;

		protected static void initializeShader()
		{
			dummyfill = new SolidColorBrush(System.Windows.Media.Colors.Blue);
		}

		public UIElement toNative() { return null; }
		public void copyToStack(Templates.StackableDrawable d)
		{
			var tmp = d.shaderStack[d.shaderStackN];
			tmp.initialize__ = initialize__;
			tmp.setParameters = setParameters;
			tmp.v1 = v1;
			tmp.v2 = v2;
			tmp.shader = shader;
			d.stack[d.stackN] = tmp;
			d.shaderStackN++;
			d.stackN++;
		}
		public UIElement poolNative(Canvas d)
		{
			var tmp = d.shaderPool[d.shaderPoolN];
			tmp.Width = width;
			tmp.Height = height;
			if (!initialized) { initialize__(); }
			setParameters();
			tmp.Effect = shader;
			tmp.Fill = dummyfill;
			System.Windows.Controls.Canvas.SetLeft(tmp, left);
			System.Windows.Controls.Canvas.SetTop(tmp, top);
			tmp.Visibility = Visibility.Visible;
			d.shaderPoolN++;
			return tmp;
		}
		public void modifyNative(System.Windows.Shapes.Rectangle tmp, Canvas d)
		{
			tmp.Width = width;
			tmp.Height = height;
			if (!initialized) { initialize__(); }
			setParameters();
			tmp.Effect = shader;
			tmp.Fill = dummyfill;
			System.Windows.Controls.Canvas.SetLeft(tmp, left);
			System.Windows.Controls.Canvas.SetTop(tmp, top);
			tmp.Visibility = Visibility.Visible;
		}
	}

	#endregion

	#region Ellipse

	partial class Ellipse
	{
		public Ellipse dup()
		{
			return (Ellipse)MemberwiseClone();
		}
		public Ellipse clone()
		{
			return (Ellipse)MemberwiseClone();
		}
		public static implicit operator System.Windows.Shapes.Ellipse(Ellipse d)
		{
			var tmp = new System.Windows.Shapes.Ellipse { Width = d.width, Height = d.height, Fill = d.fill };
			d.stroke.apply(tmp);
			System.Windows.Controls.Canvas.SetLeft(tmp, d.left);
			System.Windows.Controls.Canvas.SetTop(tmp, d.top);
			return tmp;
		}

		public UIElement toNative() { return this; }

		public void copyToStack(Templates.StackableDrawable d)
		{
			var tmp = d.ellipseStack[d.ellipseStackN];
			tmp.datum = datum;
			tmp.xdiameter = xdiameter;
			tmp.ydiameter = ydiameter;
			tmp.fill = fill;
			d.stack[d.stackN] = tmp;
			d.ellipseStackN++;
			d.stackN++;
		}
		public UIElement poolNative(Canvas d)
		{
			var tmp = d.ellipsePool[d.ellipsePoolN];
			tmp.Width = width;
			tmp.Height = height;
			tmp.Fill = fill.getNativeFromStack(d);
			System.Windows.Controls.Canvas.SetLeft(tmp, left);
			System.Windows.Controls.Canvas.SetTop(tmp, top);
			tmp.Visibility = Visibility.Visible;
			d.ellipsePoolN++;
			return tmp;
		}
		public void modifyNative(System.Windows.Shapes.Ellipse tmp, Canvas d)
		{
			tmp.Width = width;
			tmp.Height = height;
			tmp.Fill = fill.getNativeFromStack(d);
			System.Windows.Controls.Canvas.SetLeft(tmp, left);
			System.Windows.Controls.Canvas.SetTop(tmp, top);
			tmp.Visibility = Visibility.Visible;
		}
	}

	#endregion

	#region Polygon

	partial class Polygon
	{
		public Polygon dup()
		{
			return (Polygon)MemberwiseClone();
		}
		public Polygon clone()
		{
			return (Polygon)MemberwiseClone();
		}
		public static implicit operator System.Windows.Shapes.Polygon(Polygon d)
		{
			var tmp = new System.Windows.Shapes.Polygon { Fill = d.fill };
			d.stroke.apply(tmp);
			foreach (Point p in d.vertices)
			{
				tmp.Points.Add(p);
			}
			System.Windows.Controls.Canvas.SetLeft(tmp, d.datum.x);
			System.Windows.Controls.Canvas.SetTop(tmp, d.datum.y);
			return tmp;
		}
		public UIElement toNative() { return this; }

		public void copyToStack(Templates.StackableDrawable d)
		{
			var tmp = d.polygonStack[d.polygonStackN];
			tmp.datum = datum;
			tmp.vertices.Clear();
			foreach (var v in vertices)
			{
				tmp.vertices.Add(v);
			}
			tmp.fill = fill;
			d.stack[d.stackN] = tmp;
			d.polygonStackN++;
			d.stackN++;
		}
		public UIElement poolNative(Canvas d)
		{
			var tmp = d.polygonPool[d.polygonPoolN];
			tmp.Fill = fill.getNativeFromStack(d);
			tmp.Points.Clear();
			foreach (var v in vertices)
			{
				tmp.Points.Add(v);
			}
			System.Windows.Controls.Canvas.SetLeft(tmp, datum.x);
			System.Windows.Controls.Canvas.SetTop(tmp, datum.y);
			tmp.Visibility = Visibility.Visible;
			d.polygonPoolN++;
			return tmp;
		}
		public void modifyNative(System.Windows.Shapes.Polygon tmp, Canvas d)
		{
			tmp.Fill = fill.getNativeFromStack(d);
			tmp.Points.Clear();
			foreach (var v in vertices)
			{
				tmp.Points.Add(v);
			}
			System.Windows.Controls.Canvas.SetLeft(tmp, datum.x);
			System.Windows.Controls.Canvas.SetTop(tmp, datum.y);
			tmp.Visibility = Visibility.Visible;
		}

	}
		
	#endregion

	#region Letters

	partial class Letters
	{
		#region static initializer
		internal static System.Collections.Generic.Dictionary<int, System.Windows.FontWeight> FONT_WEIGHT_BRIDGE;
		internal static System.Collections.Generic.Dictionary<Font.Style, System.Windows.FontStyle> FONT_STYLE_BRIDGE;
		internal static System.Collections.Generic.Dictionary<Letters.HorizontalAlign, TextAlignment> LETTERS_H_ALIGN_BRIDGE;
		static Letters()
		{
			FONT_WEIGHT_BRIDGE = new System.Collections.Generic.Dictionary<int, System.Windows.FontWeight>();
			FONT_WEIGHT_BRIDGE.Add((int)Font.Weight.normal, System.Windows.FontWeights.Normal);
			FONT_WEIGHT_BRIDGE.Add((int)Font.Weight.bold, System.Windows.FontWeights.Bold);
			FONT_STYLE_BRIDGE = new System.Collections.Generic.Dictionary<Font.Style, System.Windows.FontStyle>();
			FONT_STYLE_BRIDGE.Add(Font.Style.normal, System.Windows.FontStyles.Normal);
			FONT_STYLE_BRIDGE.Add(Font.Style.italic, System.Windows.FontStyles.Italic);
			FONT_STYLE_BRIDGE.Add(Font.Style.oblique, System.Windows.FontStyles.Italic);
			LETTERS_H_ALIGN_BRIDGE = new System.Collections.Generic.Dictionary<Letters.HorizontalAlign, TextAlignment>();
			LETTERS_H_ALIGN_BRIDGE.Add(Letters.HorizontalAlign.left, TextAlignment.Left);
			LETTERS_H_ALIGN_BRIDGE.Add(Letters.HorizontalAlign.center, TextAlignment.Center);
			LETTERS_H_ALIGN_BRIDGE.Add(Letters.HorizontalAlign.right, TextAlignment.Right);
			LETTERS_H_ALIGN_BRIDGE.Add(Letters.HorizontalAlign.not_specified, TextAlignment.Left);
		}
		#endregion
		public Letters dup()
		{
			return (Letters)MemberwiseClone();
		}
		public Letters clone()
		{
			return (Letters)MemberwiseClone();
		}
		public static implicit operator System.Windows.Controls.TextBlock(Letters d)
		{
			//var zapi_shape = new System.Windows.Documents.Glyphs();
			var tmp = new System.Windows.Controls.TextBlock {
				Text = d.str, Width = 500, Height = 500,
				FontSize = d.font.size,
				//tmp.FontFamily = ,
				FontStyle = FONT_STYLE_BRIDGE[d.font.style],
				FontWeight = FONT_WEIGHT_BRIDGE[d.font.weight],
				TextAlignment = LETTERS_H_ALIGN_BRIDGE[d.align],
				Foreground = d.fill
			};
			double left = 0;
			switch (d.align)
			{
				case Letters.HorizontalAlign.left: break;
				case Letters.HorizontalAlign.center: left = tmp.Width / 2; break;
				case Letters.HorizontalAlign.right: left = tmp.Width; break;
			}
			System.Windows.Controls.Canvas.SetLeft(tmp, d.datum.x - left);
			System.Windows.Controls.Canvas.SetTop(tmp, d.datum.y - d.font.size);
			return tmp;
		}
		public UIElement toNative() { return this; }

		public void copyToStack(Templates.StackableDrawable d)
		{
			var tmp = d.lettersStack[d.lettersStackN];
			tmp.str = str;
			tmp.datum = datum;
			tmp.fill = fill;
			d.stack[d.stackN] = tmp;
			d.lettersStackN++;
			d.stackN++;
		}
		public UIElement poolNative(Canvas d)
		{
			var tmp = d.lettersPool[d.lettersPoolN];
			tmp.Text = str;
			tmp.Width = 500;
			tmp.Height = 500;
			tmp.FontSize = font.size;
			//tmp.FontFamily = ,
			tmp.FontStyle = FONT_STYLE_BRIDGE[font.style];
			tmp.FontWeight = FONT_WEIGHT_BRIDGE[font.weight];
			tmp.TextAlignment = LETTERS_H_ALIGN_BRIDGE[align];
			tmp.Foreground = fill.getNativeFromStack(d);
			System.Windows.Controls.Canvas.SetLeft(tmp, datum.x);
			System.Windows.Controls.Canvas.SetTop(tmp, datum.y);
			tmp.Visibility = Visibility.Visible;
			d.lettersPoolN++;
			return tmp;
		}
		public void modifyNative(System.Windows.Controls.TextBlock tmp, Canvas d)
		{
			tmp.Text = str;
			tmp.Width = 500;
			tmp.Height = 500;
			tmp.FontSize = font.size;
			//tmp.FontFamily = ,
			tmp.FontStyle = FONT_STYLE_BRIDGE[font.style];
			tmp.FontWeight = FONT_WEIGHT_BRIDGE[font.weight];
			tmp.TextAlignment = LETTERS_H_ALIGN_BRIDGE[align];
			tmp.Foreground = fill.getNativeFromStack(d);
			System.Windows.Controls.Canvas.SetLeft(tmp, datum.x);
			System.Windows.Controls.Canvas.SetTop(tmp, datum.y);
			tmp.Visibility = Visibility.Visible;
		}
	}
	
	#endregion
	
	#region Image

	partial class Image
	{
		internal void initialize__(int wid, int hei)
		{
			AsyncBool = false;
			Canvas.default_api_canvas.Dispatcher.BeginInvoke(new Action<int,int>(create__), wid, hei);
			while (!AsyncBool) { System.Threading.Thread.Sleep(10); }
		}
		internal void create__(int wid, int hei)
		{
			buffer = new WriteableBitmap(wid, hei);
			AsyncBool = true;
		}
		internal void load__(string uri)
		{
			AsyncBool = false;
			var ur = new System.Uri(uri,  System.UriKind.RelativeOrAbsolute);
			Canvas.default_api_canvas.Dispatcher.BeginInvoke(new Action<Uri>(load_), ur);
			while (!AsyncBool) { System.Threading.Thread.Sleep(10); }
		}
		internal void load_(Uri uri)
		{
			var bitmap = new BitmapImage();
			bitmap.CreateOptions = BitmapCreateOptions.None;
			bitmap.UriSource = uri;
			//try
			//{
				var wbm = new System.Windows.Media.Imaging.WriteableBitmap(bitmap);
				buffer = wbm;
			//}
			//catch (Exception e)
			//{
			//	buffer = new WriteableBitmap(64, 64);
			//	buffer.ForEach(bitmap_drawChecker);
			//}
			self_rect.set(buffer.PixelWidth, buffer.PixelHeight);
			AsyncBool = true;
		}
		static System.Windows.Media.Color[] CHECKER_C;
		static Image()
		{
			CHECKER_C = new System.Windows.Media.Color[2];
			CHECKER_C[0] = System.Windows.Media.Color.FromArgb(0, 0, 0, 0);
			CHECKER_C[1] = System.Windows.Media.Color.FromArgb(128,128,128,128);
		}
		static System.Windows.Media.Color bitmap_drawChecker(int x, int y)
		{
			return ((x / 4) + (y / 4)) % 2 == 0 ? CHECKER_C[0] : CHECKER_C[1];
		}
		delegate void FieldFunc1(System.Func<int, int, System.Windows.Media.Color> func);
		delegate void FieldFunc2(System.Func<int, int, System.Windows.Media.Color, System.Windows.Media.Color> func);
		public void field__(System.Func<int, int, System.Windows.Media.Color> func)
		{
			Canvas.default_api_canvas.Dispatcher.BeginInvoke(new FieldFunc1(field___), func);
			//buffer.ForEach(func);
		}
		public void field__(System.Func<int, int, System.Windows.Media.Color, System.Windows.Media.Color> func)
		{
			Canvas.default_api_canvas.Dispatcher.BeginInvoke(new FieldFunc2(field___), func);
			//buffer.ForEach(func);
		}
		public void field___(System.Func<int, int, System.Windows.Media.Color> func)
		{
			buffer.ForEach(func);
		}
		public void field___(System.Func<int, int, System.Windows.Media.Color, System.Windows.Media.Color> func)
		{
			buffer.ForEach(func);
		}

		public Image clone()
		{
			return (Image)MemberwiseClone();
		}
		public static implicit operator System.Windows.Controls.Image(Image d)
		{
			var tmp = new System.Windows.Controls.Image();
			tmp.Source = d.buffer;
			System.Windows.Controls.Canvas.SetLeft(tmp, d.datum.x);
			System.Windows.Controls.Canvas.SetTop(tmp, d.datum.y);
			return tmp;
		}
		public UIElement toNative() { return this; }

		public void copyToStack(Templates.StackableDrawable d)
		{
			var tmp = d.imageStack[d.imageStackN];
			tmp.datum = datum;
			tmp.buffer = buffer;
			tmp.self_rect = self_rect;
			d.stack[d.stackN] = tmp;
			d.imageStackN++;
			d.stackN++;
		}
		public UIElement poolNative(Canvas d)
		{
			var tmp = d.imagePool[d.imagePoolN];
			tmp.Source = buffer;
			System.Windows.Controls.Canvas.SetLeft(tmp, datum.x);
			System.Windows.Controls.Canvas.SetTop(tmp, datum.y);
			tmp.Visibility = Visibility.Visible;
			d.imagePoolN++;
			return tmp;
		}
		public void modifyNative(System.Windows.Controls.Image tmp, Canvas d)
		{
			tmp.Source = buffer;
			System.Windows.Controls.Canvas.SetLeft(tmp, datum.x);
			System.Windows.Controls.Canvas.SetTop(tmp, datum.y);
			tmp.Visibility = Visibility.Visible;
		}

	}

	#endregion

	#region Group

	partial class Group
	{
		internal void initialize__()
		{
			Canvas.default_api_canvas.Dispatcher.BeginInvoke(new Action(create__));
		}
		internal void create__()
		{
			cnvs = new System.Windows.Controls.Canvas();
			trans = new System.Windows.Media.TransformGroup();
			transF = new System.Windows.Media.TransformCollection();
			rotateF = new System.Windows.Media.RotateTransform();
			scaleF = new System.Windows.Media.ScaleTransform();
			translateF = new System.Windows.Media.TranslateTransform();
			transF.Add(rotateF);
			transF.Add(scaleF);
			transF.Add(translateF);
			trans.Children = transF;
			cnvs.RenderTransform = trans;
			AsyncBool = true;
		}
		public Group clone()
		{
			return (Group)MemberwiseClone();
		}

		delegate void AppendFunc1(Internal.PrimitiveFigure func);
		void append__(Internal.PrimitiveFigure fig)
		{
			fig.centering(0, 0);
			UIElement e = fig.toNative();
			cnvs.Children.Add(e);
			System.Windows.Controls.Canvas.SetLeft(e, fig.datum.x);
			System.Windows.Controls.Canvas.SetTop(e, fig.datum.y);
		}
		delegate void SimpleProcedure();
		void getRotation__() { rotation_ = rotateF.Angle; }
		void setRotation__() { rotateF.Angle = rotation_; }
		//void getTranslation__() { rotation_ = rotateF.Angle; }
		void setTranslation__() { translateF.X = datum.x; translateF.Y = datum.y; }
		void setScaling__() { scaleF.ScaleX = scaling_.x; scaleF.ScaleY = scaling_.y; }

		public static implicit operator System.Windows.Controls.Canvas(Group d)
		{
			var tmp = d.cnvs;//new System.Windows.Controls.Canvas();
			System.Windows.Controls.Canvas.SetLeft(d.cnvs, d.datum.x);
			System.Windows.Controls.Canvas.SetTop(d.cnvs, d.datum.y);
			return tmp;
		}
		public UIElement toNative() { return this; }

		public void copyToStack(Templates.StackableDrawable d)
		{
			var tmp = d.groupStack[d.groupStackN];
			tmp.datum = datum;
			tmp.cnvs = cnvs;
			d.stack[d.stackN] = tmp;
			d.groupStackN++;
			d.stackN++;
		}
		public UIElement poolNative(Canvas d)
		{
			//d.groupPool[d.groupPoolN] = cnvs;
			//var tmp = d.groupPool[d.groupPoolN];
			var tmp = cnvs;
			System.Windows.Controls.Canvas.SetLeft(tmp, datum.x);
			System.Windows.Controls.Canvas.SetTop(tmp, datum.y);
			tmp.Visibility = Visibility.Visible;
			//d.groupPoolN++;
			return tmp;
		}
		public void modifyNative(System.Windows.Controls.Canvas tmp, Canvas d)
		{
			d.groupPool[d.groupPoolN] = cnvs;
			System.Windows.Controls.Canvas.SetLeft(cnvs, datum.x);
			System.Windows.Controls.Canvas.SetTop(cnvs, datum.y);
			tmp.Visibility = Visibility.Visible;
		}

	}
	#endregion
	
	#endregion


}