﻿using System;

namespace Psychlops
{
	namespace ColorSpaces
	{
		/*
		 * CIE 1931
		 * R: 700 nm
		 * G: 546.1 nm
		 * B: 435.8 nm
		 * White Point: Illuminant E
		 */
		public struct CIERGB
		{
			public double R, G, B;

			public CIEXYZ convertToCIEXYZ()
			{
				double[,] b =
			{ 
				{ 0.49, 0.31, 0.20 },
				{ 0.17697, 0.81240, 0.01063 },
				{ 0.00, 0.01, 0.99 }
			};

				CIEXYZ v;

				v.X = b[0, 0] * R + b[0, 1] * G + b[0, 2] * B;
				v.Y = b[1, 0] * R + b[1, 1] * G + b[1, 2] * B;
				v.Z = b[2, 0] * R + b[2, 1] * G + b[2, 2] * B;

				return v;
			}
		}

		/*
		 * CIE 1931
		 */
		public struct CIEXYZ
		{
			public double X, Y, Z;

			public CIExyY convertToCIExyY()
			{
				CIExyY v;

				double denominator = X + Y + Z;
				v.x = X / denominator;
				v.y = Y / denominator;
				v.Y = Y;

				return v;
			}
		}

		public struct CIExyY
		{
			public double x, y, Y;

			public CIEXYZ convertToCIEXYZ()
			{
				CIEXYZ v;

				v.X = Y / y * x;
				v.Y = Y;
				v.Z = Y / y * (1 - x - y);

				return v;
			}

			// Yn = 1.0 when RGB of white point is { 1, 1, 1 }
			public CIELuv convertToCIELuv(double Yn = 1.0)
			{

				CIELuv v;

				double denominator = (-2 * x + 12 * y + 3);
				double up = 4 * x / denominator;
				double vp = 9 * y / denominator;

				double Yd = Y / Yn;
				v.L = Yd > System.Math.Pow(6 / 29, 3) ? 116 * System.Math.Pow(Yd, 3) : System.Math.Pow(29 / 3, 3) * Yd;
				v.u = 13 * v.L * (up - 0.2009);
				v.v = 13 * v.L * (vp - 0.4610);

				return v;
			}
		}

		/* L*u*v*
		 * CIE 1976
		 * standard illuminant C
		 */
		public struct CIELuv
		{
			public double L, u, v;

		}

		public struct CIELab
		{
			public double L, a, b;

		}

	}
}