﻿using System;

namespace Psychlops
{


	public abstract class Matrix
	{
		public static Matrix gen(int row, int col)
		{
			return new Internal.MatrixImplementation(row, col);
		}

		public abstract double this[int row, int col]
		{
			get;
			set;
		}

		/*
		public abstract Internal.MatrixExpression this[Interval row, Interval col]
		{
			get;
			set;
		}


		/*
		public static Matrix operator +(Matrix m, double d)
		{
			return new Internal.MatrixExpression();
		}
		*/
		public void each(Func<double, double> f)
		{
			for (int i = 1; i <= getRows(); i++)
			{
				for (int j = 1; j <= getCols(); j++)
				{
					this[i, j] = f(this[i, j]);
				}
			}
		}

		public abstract int rows { get; }
		public abstract int cols { get; }
		public int getRows() { return rows; }
		public int getCols() { return cols; }

	}


	namespace Internal
	{

		public class MatrixImplementation : Matrix
		{
			internal double[,] elements;

			public MatrixImplementation(int dnrow, int dncol)
			{
				elements = new double[dnrow, dncol];
			}

			public override double this[int row, int col]
			{
				get
				{
					return elements[row - 1, col - 1];
				}
				set
				{
					elements[row - 1, col - 1] = value;
				}
			}
			/*
			public override MatrixExpression this[Interval row, Interval col]
			{
				get
				{
					return new MatrixExpression(this, row.int_floor(), col.int_floor(), row.int_ceil(), col.int_ceil());
				}
				set
				{
					for(int r = 0, r<)
					elements[row - 1, col - 1] = value;
				}
			}
			 * */

			public override int rows { get { return elements.GetLength(0); } }
			public override int cols { get { return elements.GetLength(1); } }

		}

		public class MatrixExpression : Matrix
		{
			MatrixImplementation imp;
			readonly int brow, bcol;
			readonly int erow, ecol;

			internal MatrixExpression(MatrixImplementation target, int dbrow, int dbcol, int derow, int decol)
			{
				brow = dbrow;
				bcol = dbcol;
				erow = derow;
				ecol = decol;
				imp = target;
			}

			public override double this[int row, int col]
			{
				get
				{
					return imp.elements[(row - 1 - brow), (col - 1 - bcol)];
				}
				set
				{
					imp.elements[(row - 1 - brow), (col - 1 - bcol)] = value;
				}
			}

			public override int rows { get { return erow - brow + 1; } }
			public override int cols { get { return ecol - bcol + 1; } }
		}
	}

}