/*
 *  psychlops_devices_crs_bits.h
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2009/07/30 by Kenchi HOSOKAWA
 *  (C) 2009 Kenchi HOSOKAWA, Kazushi MARUYA, Takao SATO
 */

#ifndef HEADER_PSYCHLOPS_DEVICES_CRS_BITS
#define HEADER_PSYCHLOPS_DEVICES_CRS_BITS

#include "../../core/graphic/psychlops_graphic.h"
#include "../../core/devices/psychlops_io_analog.h"
#include "../../core/devices/psychlops_io_clock.h"

namespace Psychlops {
namespace Devices {


	struct BitsTlock
	{
		static const unsigned char COMMAND_R[8];// = { 69,40,19,119,52,233,41,183 };
		static const unsigned char COMMAND_G[8];// = { 33,230,190,84,12,108,201,124 };
		static const unsigned char COMMAND_B[8];// = { 56,208,102,207,192,172,80,221};
		static const unsigned char PALLETE_R[8];// = { 69,40,19,119,52,233,41,183 };
		static const unsigned char PALLETE_G[8];// = { 33,230,190,84,12,108,201,124 };
		static const unsigned char PALLETE_B[8];// = { 56,208,102,207,192,172,80,221};
	};


	struct BitsTimer
	{
	};


	struct BitsPallete
	{
		Image tlock;
		bool is_initialized;
		void initialize();

		BitsPallete();
		void set(double *val);
	};


	struct BitsTrigger
	{
		Image tlock;
		bool is_initialized;
		void initialize();

		BitsTrigger();
		void set(double val);
		void out();
	};


/*
	struct BitsResponseBox
	{
		struct Key {
			const int code;
			Key(const int code_);
			bool pressed() const;
			bool pushed() const;
			bool released() const;
			bool get(KeyState state) const;
		};

		CBBOXRECORD C;
		Image tlock;
		bool is_initialized;
		void initialize();

		BitsResponseBox();
		BitsResponseBox(unsigned long BoxType);
		~BitsResponseBox();
		void open(unsigned long BoxType = 8);
		void close();

		void reset();
		void buzzer(unsigned long Period, unsigned long Frequency);
		void sendback();
		void check();
		void flush();
	};
*/



}

}	/*	<- namespace Psycholops 	*/



#endif
