/*
 *  psychlops_io_API_OSX.h
 *  Psychlops Standard Library (MacOSX)
 *
 *  Last Modified 2006/01/04 by Kenchi HOSOKAWA
 *  (C) 2006 Kenchi HOSOKAWA, Kazushi MARUYA and Takao SATO
 */

#ifndef HEADER_PSYCHLOPS_IO_API_OSX
#define HEADER_PSYCHLOPS_IO_API_OSX

#include <Carbon/Carbon.h>
#include <ApplicationServices/ApplicationServices.h>
#include <CoreServices/CoreServices.h>

#include "psychlops_io_clock_OSX.h"
#include "../../core/devices/psychlops_io_hid.h"

#if !defined(PANTHER)
#define PSYCHLOPS_SNOW_LEOPARD_PATCH
#endif

namespace Psychlops {

	class APIHIDProperties {
		friend class Mouse;
		friend class Keyboard;
		friend class HumanInterfaceDevice;
		
		private:
		static MPTaskID inputListnerTask, inputListnerTask2;
		static bool refresh_needed;
		
		public:
		static void initialize();
		static void finalize();

		static void startListener();
		static void stopListener();
		static void bindKeyCode();

		static bool get(Keyboard::Key code, Keyboard::KeyState state);
		static bool get(Mouse::Button button, Mouse::ButtonState state);
		static void setPointerPosition(int x, int y);
		static void update();

#if (defined(PANTHER) && ( PANTHER==1 )) || defined(PSYCHLOPS_SNOW_LEOPARD_PATCH)
		static void lisnerProcedure();
		static void updateKeyboard();
		static void updateMouse();
		static UInt32 key[4][4];
		static unsigned long keybinder[128][2];
		enum KeyCodeBinder_OSX{
			BIG=0, SMALL=1
		};
#endif
#if !defined(PANTHER)
		static void loopListener();
		static CGEventRef listenToKeyboard(CGEventTapProxy proxy, CGEventType type, CGEventRef event, void *refcon);
		static CGEventRef listenToMouse   (CGEventTapProxy proxy, CGEventType type, CGEventRef event, void *refcon);
		static CFRunLoopSourceRef listenerKey, listenerMouse;
#if !defined(PSYCHLOPS_SNOW_LEOPARD_PATCH)
		static int keybinder[128];
#endif
#endif
	};

/*
	class APIMouseProperties {
		friend class APIHIDProperties;
		private:
		static ::Point position_;

		public:
		static void initialize();

		static void update();

		static bool get(Mouse::Button button, HumanInterfaceDevice::ButtonState state);
		static void getPosition(int &x, int &y);
		static void setPosition(int x, int y);
	};
*/


}	/*	<- namespace Psycholops 	*/


#endif
