/*
 *  psychlops_code_snippets.cpp
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 208/09/22 by Kenchi HOSOKAWA
 *  (C) 2008 Kenchi HOSOKAWA, Kazushi MARUYA, Takao SATO
 */


#include "psychlops_code_snippets.h"


#include <string>
#include <algorithm>


namespace Psychlops {


	std::wstring StringToWString(const std::string& s)
	{
		std::wstring temp(s.length(),L' ');
		std::copy(s.begin(), s.end(), temp.begin());
		return temp;
	}


	std::string WStringToString(const std::wstring& s)
	{
		std::string temp(s.length(), ' ');
		std::copy(s.begin(), s.end(), temp.begin());
		return temp;
	}


}	/*	<- namespace Psychlops 	*/

