/*
 *  psychlops_figure_standard.cpp
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2005/10/05 by Kenchi HOSOKAWA
 *  (C) 2005 Kenchi HOSOKAWA, Kazushi MARUYA, Takao SATO
 */

#include "psychlops_figure_standard.h"



namespace Psychlops {
namespace Figures {



	////////	Arrow	////////
	Polygon Arrow::default_head;

	void Arrow::createDefaultHead() {
		default_head.append(Point(0,0));
		default_head.append(Point( 5,20));
		default_head.append(Point(-5,20));
	}
	void Arrow::setDefaultHead() {
		if(default_head.empty()) createDefaultHead();
		if(head==0) head = &default_head;
		gr.append(head);
	}

	Arrow::Arrow() : Line(), head(0) {
		setDefaultHead();
	}
	Arrow::Arrow(const double x1, const double y1, const double x2, const double y2) : Line(x1, y1, x2, y2), head(0) {
		setDefaultHead();
	}
	Arrow::Arrow(const Point &dbegin, const Point &dvec) : Line(dbegin, dvec), head(0) {
		setDefaultHead();
	}
	Arrow& Arrow::set(const double x1, const double y1, const double x2, const double y2) {
		Point b(x1, y1), e(x2, y2);
		return set(b, e);
	}
	Arrow& Arrow::set(const Point &dbegin, const Point &dend) {
		datum = dbegin, end = dend;
		setDefaultHead();
		return *this;
	}

	Arrow& Arrow::draw(Drawable& target) {
		Shape::draw_base(target);
		return *this;
	}
	Arrow& Arrow::draw(const Color &col, Drawable& target) {
		target.line(*this, col);
		gr.centering(this->end);
		Point vec = this->end-this->datum;
		gr.rotation = 180-atan2(vec.x, vec.y)/2.0/PI*360;
		head->fill = col;
		head->stroke = Stroke::null_line;
		target.figures(gr);
		return *this;
	}
	Arrow& Arrow::draw(const Stroke &strk, Drawable& target) {
		target.line(*this, strk);
		gr.centering(this->end);
		Point vec = this->end-this->datum;
		gr.rotation = 180-atan2(vec.x, vec.y)/2.0/PI*360;
		head->fill = strk.color;
		head->stroke = Stroke::null_line;
		target.figures(gr);
		return *this;
	}



	////////	Cross	////////
	Cross::Cross() { stroke = Stroke::hair_line; }
	Cross::Cross(const Rectangle& rect, Stroke dstrk) {
		set(rect, dstrk);
	}
	Cross::Cross(double wid, double hei, Stroke dstrk) {
		set(wid, hei, dstrk);
	}
	Cross::~Cross() {}
	Cross& Cross::set(const Rectangle& rect, Stroke dstrk) {
		width = rect.getWidth();
		height = rect.getHeight();
		stroke = dstrk;
		return *this;
	}
	Cross& Cross::set(double wid, double hei, Stroke dstrk) {
		width = wid;
		height = hei;
		stroke = dstrk;
		return *this;
	}
	Cross& Cross::centering(const Point &p) {
		datum = p;
		return *this;
	}
	Cross& Cross::draw(Drawable &target) {
		draw(stroke, target);
		return *this;
	}
	Cross& Cross::draw(const Color &col, Drawable &target) {
		Line lx(datum.x - width/2, datum.y, datum.x + width/2, datum.y);
		Line ly(datum.x, datum.y - height/2, datum.x, datum.y + height/2);
		target.line(lx, col);
		target.line(ly, col);
		return *this;
	}
	Cross& Cross::draw(const Stroke &strk, Drawable &target) {
		Line lx(datum.x - width/2, datum.y, datum.x + width/2, datum.y);
		Line ly(datum.x, datum.y - height/2, datum.x, datum.y + height/2);
		target.line(lx, strk);
		target.line(ly, strk);
		return *this;
	}

}
}	/*	<- namespace Psycholops 	*/


