#include <psychlops.h>
using namespace Psychlops;

/*
namespace Psychlops {
	Point toGround(Point p, double high) {
		Point r;
		r.z = 0;
		r.x = p.x / ((high-p.z)/high);
		r.y = p.y / ((high-p.z)/high);
		return r;
	}
}
void psychlops_main() {
	Canvas cnv(Canvas::window);
	Psychlops::Point p[4];
	p[0]= toGround(Psychlops::Point(60, 60, 60), 120);
	p[1]= toGround(Psychlops::Point(-60, 60, 60), 120);
	p[2]= toGround(Psychlops::Point(-60, 60, 0), 120);
	p[3]= toGround(Psychlops::Point(60, 60, 0), 120);
	for(int i=0; i<4; i++) { p[i].x+=100; }
	Image img("monalisa1.png");
	img.cache();
	cnv.clear();
	cnv.drawImage(img, p[0], p[1], p[2], p[3]);
	cnv.flip();
	while(!Keyboard::esc.pushed()) {
	}
}
*/

namespace Psychlops {
namespace VirtualReality {

	class Light {
	public:
		enum { AMBIENT, DIRECTIONAL };
		enum Material { DIFFUSE, SPECULAR };
		Point position, direction;
		void lookAt(Point target);
		void locateToLook(Psychlops::Point pos, Point target);
		void apply(Drawable3D &target = *Drawable3D::prime);
	};

	class Camera {
	public:
		double top, bottom, left, right, near, far;
//		Point datum, direction;
		double topdir;
		Camera() {
			top = 100;
			bottom = -100;
			left = -100;
			right = 100;
			near = 100;
			far = 200;
		}
		void set(Point position, Point target, double top_direction) {
		}
		void lookAt(Point target, double top_direction) {
		}
		void draw(Canvas &target = *Canvas::prime);

		Group contents;
		Light lights[4];
	};
	void Camera::draw(Canvas &target) {
		target.popMatrices();
		target.RenderModeSmooth3D(left, right, top, bottom, near, far);
		contents.draw(target);
		target.popMatrices();
		target.pushPixToPixProjection();
	}
}
}

double x=0, y=0;

void psychlops_main() {
	Canvas cnvs(Canvas::window);
	Mouse::show();

	Interval rng;
	Widgets::Button but(L"テスト");
	but.centering().shift(100,100);
	Widgets::Dial dial(40);
	dial.link(y, 360);
	dial.centering().shift(-100,0);

	Image gabor(200,200, Image::RGBA);
	for(int iy=0; iy<200; iy++) {
		for(int ix=0; ix<200; ix++) {
			gabor.pix(ix,iy,Color(.5+.5*sin(ix/10.0)));
			gabor.alpha(ix,iy, exp( -((ix-100)*(ix-100)+(iy-100)*(iy-100)) /2.0 / (30*30) ) );
		}
	}
	gabor.cache();
	gabor.centering(0,0);

	VirtualReality::Camera cam;
	Group h[6];
	cam.contents.axis.set(1,1,0);
	cam.contents.scaling.set(.5,.5,.5);
	cam.contents.centering(0,0,0).shift(0,0,100);
	Widgets::Slider
		sl1(cam.contents.scaling.x, 0<=rng<=100, 1.0, 10.0),
		sl2(cam.contents.scaling.y, 0<=rng<=100, 1.0, 10.0),
		sl3(cam.contents.scaling.z, 0<=rng<=100, 1.0, 10.0);
	sl1.shift(100,10);
	sl2.shift(100,30);
	sl3.shift(100,50);
	Widgets::Slider
		sl11(cam.left, -1000<=rng<=1000, 1.0, 10.0),
		sl12(cam.right, -1000<=rng<=1000, 1.0, 10.0),
		sl13(cam.top, -1000<=rng<=1000, 1.0, 10.0),
		sl14(cam.bottom, -1000<=rng<=1000, 1.0, 10.0),
		sl15(cam.near, -1000<=rng<=1000, 1.0, 10.0),
		sl16(cam.far, -1000<=rng<=1000, 1.0, 10.0);
	sl11.shift(100,110);
	sl12.shift(100,130);
	sl13.shift(100,150);
	sl14.shift(100,170);
	sl15.shift(100,190);
	sl16.shift(100,210);
	
	for(int i=0; i<6; i++) {
		h[i].append(gabor);
		cam.contents.append(h[i]);
	}
	h[0].shift(0,0,100);
	h[1].shift(0,0,-100);
	h[2].shift(0,100,0);
	h[2].axis.set(1,0,0);
	h[2].rotation = 90;
	h[3].shift(0,-100,0);
	h[3].axis.set(1,0,0);
	h[3].rotation = 90;
	h[4].shift(100,0,0);
	h[4].axis.set(0,1,0);
	h[4].rotation = 90;
	h[5].shift(-100,0,0);
	h[5].axis.set(0,1,0);
	h[5].rotation = 90;
	
	while(!Keyboard::esc.pushed()) {
		cnvs.clear( but.pushed() ? Color::red : Color::gray );
		sl1.draw();
		sl2.draw();
		sl3.draw();
		sl11.draw();
		sl12.draw();
		sl13.draw();
		sl14.draw();
		sl15.draw();
		sl16.draw();
		cnvs.var(x, 200, 100);
		cnvs.var(y, 200, 130);
		cam.contents.rotation = y;
		cam.draw(cnvs);
		but.draw();
		dial.draw();
		cnvs.flip();
	}
}
