/*
 *  psychlops_io_clock_Win32.cpp
 *  Psychlops Standard Library (MacOSX)
 *
 *  Last Modified 2005/12/21 by Kenchi HOSOKAWA
 *  (C) 2005 Kenchi HOSOKAWA, Kazushi MARUYA, Takao SATO
 */

#include <stdlib.h>
#include <Math.h>
#include <time.h>
#include <iostream>

#include <Windows.h>

#include "../../core/ApplicationInterfaces/psychlops_code.h"

#include "psychlops_io_clock_Win32.h"
#include "../../core/devices/psychlops_io_clock.h"


namespace Psychlops {

	void Clock::initialize() {
		if(QueryPerformanceFrequency((_LARGE_INTEGER *)&clocks_per_a_milisecond_)==0) {
			throw Exception(typeid(Clock), "HARDWARE NOT SUPPORTED", "This computer does not support high-resolution performance counter.");
		}
		clocks_per_a_milisecond_.QuadPart /= 1000;
	}

	Clock::Clock() {
		update();
	}
	Clock::Clock(CLOCK_UNIT native_clock) {
		clock_ = native_clock;
	}
	Clock::~Clock() {}
	void Clock::update() {
		QueryPerformanceCounter((_LARGE_INTEGER *)&clock_);
	}
//	Clock Clock::operator -() {
//		return Clock(-clock_);
//	}
	Clock Clock::operator +(Clock &rhs) {
		CLOCK_UNIT tmp;
		tmp.QuadPart = clock_.QuadPart + rhs.clock_.QuadPart;
		return Clock(tmp);
	}
	Clock Clock::operator -(Clock &rhs) {
		CLOCK_UNIT tmp;
		tmp.QuadPart = clock_.QuadPart - rhs.clock_.QuadPart;
		return Clock(tmp);
	}
	Clock & Clock::operator +=(Clock &rhs) {
		(*this) = (*this) + rhs;
		return *this;
	}
	Clock & Clock::operator -=(Clock &rhs) {
		(*this) = (*this) - rhs;
		return *this;
	}
	bool Clock::operator ==(Clock &rhs) {
		return (clock_.QuadPart==rhs.clock_.QuadPart);
	}

	bool Clock::operator !=(Clock &rhs) {
		return (clock_.QuadPart!=rhs.clock_.QuadPart);
	}
	bool Clock::operator >(Clock &rhs) {
		return (clock_.QuadPart>rhs.clock_.QuadPart);
	}
	bool Clock::operator <(Clock &rhs) {
		return (clock_.QuadPart<rhs.clock_.QuadPart);
	}
	bool Clock::operator >=(Clock &rhs) {
		return (clock_.QuadPart>=rhs.clock_.QuadPart);
	}
	bool Clock::operator <=(Clock &rhs) {
		return (clock_.QuadPart<=rhs.clock_.QuadPart);
	}
	double Clock::at_msec() {
		return (double)clock_.QuadPart/(double)clocks_per_a_milisecond_.QuadPart;
	}

	CLOCK_UNIT Clock::clocks_per_a_milisecond_;


	long Gettime_ms() {
		Clock tmp;
		return tmp.at_msec();
	}


}	/*	<- namespace Psycholops 	*/
