/*
 *  psychlops_app_info.cpp
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2005/12/17 by Kenchi HOSOKAWA
 *  (C) 2005 Kenchi HOSOKAWA, Kazushi MARUYA, Takao SATO
 */


#include <string>

#include "psychlops_app_info.h"
#include "../devices/psychlops_io_file.h"

#define PSYCHLOPS_APPSTATE_API_PLATFORM
#include "../../platform/psychlops_platform_selector.h"
#include "psychlops_app_thread.h"

namespace Psychlops {



	APIApplicationProperties *(AppState::api_);
	bool AppState::shouldBeClose = false;

	void AppState::initialize() {
		api_ = &(APIApplicationProperties::startupinfo);
		setThreadPriority(NORMAL);
	}
	void AppState::setThreadPriority( ThreadPriority priority ) {
		api_->setThreadPriority(priority);
		//Prototype::Thread::priority( priority );
	}
	AppState::ThreadPriority AppState::getThreadPriority() {
		return (ThreadPriority)api_->getThreadPriority();
		//return Prototype::Thread::priority();
	}

	int AppInfo::argc;
	char **(AppInfo::argv);
	std::vector<std::string> AppInfo::args;
	std::string AppInfo::appname = "Psychlops";
	std::string AppInfo::expname = "";


}	/*	<- namespace Psychlops 	*/

