/*
 *  psychlops_devices_nidaqmxbase.cpp
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2009/04/14 by Kenchi HOSOKAWA
 *  (C) 2009 Kenchi HOSOKAWA, Kazushi MARUYA, Takao SATO
 */

#include "../../core/ApplicationInterfaces/psychlops_code_exception.h"
#include "../../core/devices/psychlops_io_hid.h"
#include "../../core/graphic/psychlops_g_canvas.h"
#include "../../core/math/psychlops_math.h"
#include "../../platform/gl/extension/psychlops_g_shader_gl.h"

#include "psychlops_devices_crs_bits.h"

#if defined(__APPLE__)
#else
//#include "C:\Program Files\Cambridge Research Systems\VSGV7\Windows\WIN32\MSC\include\bits++.h"
#endif



namespace Psychlops {

namespace Devices {

	const unsigned char BitsTlock::COMMAND_R[8] = { 69 ,40 ,19 ,119,52 ,233,41 ,183 };
	const unsigned char BitsTlock::COMMAND_G[8] = { 33 ,230,190,84 ,12 ,108,201,124 };
	const unsigned char BitsTlock::COMMAND_B[8] = { 56 ,208,102,207,192,172,80 ,221 };

	const unsigned char BitsTlock::PALLETE_R[8] = { 36 ,63 , 8 ,211,3  ,112,56 ,34 };
	const unsigned char BitsTlock::PALLETE_G[8] = {106 ,136,19 ,25 ,115,68, 41, 156};
	const unsigned char BitsTlock::PALLETE_B[8] = {133 ,163,138,46 ,164,9  ,49, 208};

	inline double CTB(int param)
	{
		return param / 255.0;
	}

	void BitsPallete::initialize()
	{
		if(!is_initialized)
		{
		Color::setGammaValue(1.0,1.0,1.0);
			tlock.set(20,1,Image::RGB);
			for(int i=0; i<8; i++) {
				tlock.pix(i, 0, Color(CTB(BitsTlock::COMMAND_R[i]), CTB(BitsTlock::COMMAND_G[i]), CTB(BitsTlock::COMMAND_B[i])) );
			}
		Color::setGammaValue(1.0,1.0,1.0, Color::BITS_MONO);
		}
	}

	BitsPallete::BitsPallete()
	{
		is_initialized = false;
		initialize();
	}

	void BitsPallete::set(double *val)
	{
		Color::setGammaValue(1.0,1.0,1.0);
		int packet_length = 1;
		tlock.pix(8, 0, Color(CTB(0), CTB(0), CTB(packet_length-1)));
		tlock.pix(9, 0, Color(CTB(6), CTB(0), CTB(2)));
		tlock.pix(10, 0, Color(CTB(0), CTB(0), CTB(0)));
		tlock.pix(11, 0, Color(CTB(7), CTB(255), CTB(255)));

		tlock.pix(12, 0, Color(CTB(0), CTB(0), CTB(0)));
		//tlock.pix(14, 0, Color(CTB(0), CTB(0), CTB(0));
		//tlock.pix(16, 0, Color(CTB(0), CTB(0), CTB(0));
		//tlock.pix(18, 0, Color(CTB(0), CTB(0), CTB(0));

		short w = val[0];
		tlock.pix(13, 0, Color(CTB(7), w >> 8 / 255, w >> 255 ));
		Color::setGammaValue(1.0,1.0,1.0, Color::BITS_MONO);
	}


	void BitsTrigger::initialize()
	{
		if(!is_initialized)
		{
		Color::setGammaValue(1.0,1.0,1.0);
			tlock.set(20,1,Image::RGB);
			for(int i=0; i<8; i++) {
				tlock.pix(i, 0, Color(CTB(BitsTlock::COMMAND_R[i]), CTB(BitsTlock::COMMAND_G[i]), CTB(BitsTlock::COMMAND_B[i])) );
			}
		Color::setGammaValue(1.0,1.0,1.0, Color::BITS_MONO);
		}
	}

	BitsTrigger::BitsTrigger()
	{
		is_initialized = false;
		initialize();
	}

	void BitsTrigger::set(double val)
	{
		Color::setGammaValue(1.0,1.0,1.0);
		int packet_length = 1;
		tlock.pix(8, 0, Color(CTB(0), CTB(0), CTB(packet_length-1)));
		tlock.pix(9, 0, Color(CTB(6), CTB(0), CTB(2)));
		tlock.pix(10, 0, Color(CTB(0), CTB(0), CTB(0)));
		tlock.pix(11, 0, Color(CTB(7), CTB(255), CTB(255)));

		tlock.pix(12, 0, Color(CTB(0), CTB(0), CTB(0)));
		//tlock.pix(14, 0, Color(CTB(0), CTB(0), CTB(0));
		//tlock.pix(16, 0, Color(CTB(0), CTB(0), CTB(0));
		//tlock.pix(18, 0, Color(CTB(0), CTB(0), CTB(0));

		short w = val;
		tlock.pix(13, 0, Color(CTB(7), w >> 8 / 255, w >> 255 ));
		tlock.setDatum(Point(0, Display::getHeight()-1));
		Color::setGammaValue(1.0,1.0,1.0, Color::BITS_MONO);
	}

	void BitsTrigger::out()
	{
		tlock.draw();
	}



/*

	void BitsResponseBox::initialize()
	{
		if(!is_initialized)
		{
			tlock.set(12,1,Image::RGB);
			for(int i=0; i<8; i++) {
				tlock.pix(i, 0, Color(CTB(BitsTlock::COMMAND_R[i]), CTB(BitsTlock::COMMAND_G[i]), CTB(BitsTlock::COMMAND_B[i])) );
			}
			tlock.pix(8, 0, Color(CTB(0), CTB(0), CTB(1)));
			tlock.pix(9, 0, Color(CTB(6), CTB(12), CTB(0)));
			tlock.pix(10, 0, Color(CTB(0), CTB(0), CTB(0)));
			tlock.pix(11, 0, Color(CTB(0), CTB(0), CTB(0)));
		}
	}

	BitsResponseBox::BitsResponseBox()
	{
		is_initialized = false;
		initialize();
	}
	BitsResponseBox::BitsResponseBox(unsigned long BoxType)
	{
		is_initialized = false;
		initialize();
		open(BoxType);
	}
	BitsResponseBox::~BitsResponseBox()
	{
		close();
	}
	void BitsResponseBox::buzzer(unsigned long Period, unsigned long Frequency)
	{
		bitsCbboxBuzzer(Period, Frequency);  /* Buzz CB1 buzzer
	}
	void BitsResponseBox::sendback()
	{
		bitsCbboxSendback();                 /* Ask explicitly for switch settings
	}

	int  changeA;
	int  switchA;
	int  changeB;
	int  switchB;
	int  changeC;
	int  switchC;
	long counter;

	void BitsResponseBox::reset()
	{
		bitsResetTimer();
	}
	void BitsResponseBox::check()
	{
		bitsCbboxCheck(&C);                  /* Check if any switches have changed
	}
	void BitsResponseBox::flush()
	{
		bitsCbboxFlush();                            /* Flush the input buffer
	}

	void BitsResponseBox::open(unsigned long BoxType)
	{
		DWORD res = bitsCbboxOpen(BoxType);
		std::cout << res << std::endl;
	}
	void BitsResponseBox::close()
	{
		bitsCbboxClose();                            /* Reset interrupt vectors
	}
	*/




	////////	Construct and Destruct  ////////
	class DirectGetColor {
		public:
		inline static unsigned char round8bit(double value) {
			double val = value*255.0+0.5, integer_part, frac;
			frac = modf(val, &integer_part);
			if(frac!=0.0) return (unsigned char)integer_part;
			if((int)(integer_part)%2==0) return (unsigned char)integer_part; else return (unsigned char)integer_part-1;
		}
		static void setColor4ub(const Color &color) {
			glColor4ub(round8bit(color.getR()), round8bit(color.getG()), round8bit(color.getB()), round8bit(color.getA()));
		}
		static void setColorClear4ub(const Color &color) {
			glClearColor((GLclampf)round8bit(color.getR())/255.0, (GLclampf)round8bit(color.getG())/255.0, (GLclampf)round8bit(color.getB())/255.0, (GLclampf)round8bit(color.getA())/255.0);
		}
		static void setColor4Through(const Color &color) {
			glColor4d(color.getR(), color.getG(), color.getB(), color.getA());
		}
		static void setColorClaer4Through(const Color &color) {
			glClearColor(color.getR(), color.getG(), color.getB(), color.getA());
		}
	};


	CanvasBits::CanvasBits(void) : Canvas() {
	}
	CanvasBits::CanvasBits(CanvasMode mode) : Canvas(mode) {
	}
	CanvasBits::CanvasBits(int d_width, int d_height, int d_colordepth, double d_refreshrate, CanvasMode mode)
	 : Canvas(d_width, d_height, d_colordepth, d_refreshrate) {
	}
	CanvasBits::~CanvasBits(void) {
		release();
	}

/*
	void CanvasBits::popMatrixes() {
		glMatrixMode(GL_MODELVIEW);
		glPopMatrix();
		glMatrixMode(GL_PROJECTION);
		glPopMatrix();
	}
	void CanvasBits::loadOrthoProjection() {
		glMatrixMode(GL_PROJECTION);
		glPushMatrix();
		glOrtho(-0.375, Width-0.375, Height-0.375, -0.375, -1000, 1000);
		glMatrixMode(GL_MODELVIEW);
		glPushMatrix();
//		glDisable(GL_LIGHTING);
//		glDisable(GL_DEPTH_TEST);
	}
*/
	void CanvasBits::initAPIprop() {
		switch(colordepth) {
		case 24:
		case 32:
			APIsetColor = &(DirectGetColor::setColor4Through);
			APIsetColorClear = &(DirectGetColor::setColorClaer4Through);
			break;
		default:
			APIsetColor = &(DirectGetColor::setColor4Through);
			APIsetColorClear = &(DirectGetColor::setColorClaer4Through);
			break;
		}

		glDrawBuffer(GL_BACK);
		glReadBuffer(GL_BACK);
		//glMatrixMode(GL_PROJECTION);
		//glLoadIdentity();
//		glOrtho(0, Width, Height, 0, -1, 1);
		//glOrtho(-0.375, Width-0.375, Height-0.375, 0-0.375, -1, 1);
		//glMatrixMode(GL_MODELVIEW);
		//glLoadIdentity();
//		glTranslated(0.375, 0.375, 0.0);
//		glPushMatrix();

        pushPixToPixProjection();
		initAPIattributes();

		glEnableClientState(GL_VERTEX_ARRAY);
		//std::string source = ShaderAPI::shader_core_pix;
		std::string source = ShaderAPI::shader_core_pix_bitscolor;
		source += "void main(void){ pix( gl_Color.r, gl_Color.g, gl_Color.b, gl_Color.a ); }";
		std::string sourcev = "";
		sourcev +=
		"#version 140\r\n"
		"uniform mat4 projectionMatrix;\r\n"
		"uniform mat4 modelviewMatrix;\r\n"
		"in vec3 position;\r\n"
		"void main(void){\r\n"
		"  vec4 base_pos = projectionMatrix * modelviewMatrix * vec4(position, 1.0);\r\n"
		"  base_pos.x = base_pos.x * 2.0;\r\n;"
		"  gl_Position = base_pos;\r\n"
		"}\r\n";
		std::vector<std::string> vars;
		try{
			//shader.cacheVertex(sourcev, *this);
			shader.cache(source, vars, *this);
		} catch(Exception *e)
		{
			std::cout << sourcev << std::endl << std::endl;
			std::cout << e->toString();
			exit(0);
		}
		glUseProgram(shader.gl2Program);


		GLclampf red=0.0, green=0.0, blue=0.0, alpha=1.0;
//		default_drawing_mode_ = GL_POINTS;
		glClearColor(red,green,blue,alpha);
		clear(Color::black);
		flip(2);
		clear(Color::black);
		flip(2);
	}

	void CanvasBits::initAPIattributes() {
		glPushAttrib(GL_ALL_ATTRIB_BITS);

		////	default settings	////
		glShadeModel(GL_FLAT);
		glEnable(GL_ALPHA_TEST);
		glEnable(GL_BLEND);
		glEnable(GL_LINE_STIPPLE);
		glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
		glDisable(GL_POINT_SMOOTH);
		glDisable(GL_LINE_SMOOTH);
		glDisable(GL_POLYGON_SMOOTH);
		glDisable(GL_DEPTH_TEST);
		glDisable(GL_DITHER);
		glDisable(GL_FOG);
		glDisable(GL_LIGHTING);
		glDisable(GL_LOGIC_OP);
		glDisable(GL_STENCIL_TEST);
		glDisable(GL_TEXTURE_1D);
		glDisable(GL_TEXTURE_2D);
		glPixelTransferi(GL_MAP_COLOR, GL_FALSE);
		glPixelTransferi(GL_MAP_STENCIL, GL_FALSE);
		glPixelTransferi(GL_RED_SCALE, 1);
		glPixelTransferi(GL_RED_BIAS, 0);
		glPixelTransferi(GL_GREEN_SCALE, 1);
		glPixelTransferi(GL_GREEN_BIAS, 0);
		glPixelTransferi(GL_BLUE_SCALE, 1);
		glPixelTransferi(GL_BLUE_BIAS, 0);
		glPixelTransferi(GL_ALPHA_SCALE, 1);
		glPixelTransferi(GL_ALPHA_BIAS, 0);
		glPixelStorei(GL_UNPACK_ROW_LENGTH, 0);
		glPixelStorei(GL_UNPACK_SKIP_ROWS, 0);
		glPixelStorei(GL_UNPACK_SKIP_PIXELS, 0);
		glPixelStorei(GL_UNPACK_ALIGNMENT, 4);
		glPixelStoref(GL_UNPACK_ALIGNMENT, 4);
		glPixelStorei(GL_PACK_ALIGNMENT, 4);
		glPixelStoref(GL_PACK_ALIGNMENT, 4);
		glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
	}

	CanvasBits& CanvasBits::clear(const Color &col)
	{
		Rectangle r(getWidth()+1, getHeight()+1);
		r.draw(col);
		return *this;
	}


	inline float setVertex(double x)
	{
		return Math::round(x)*2;
	}


	CanvasBits& CanvasBits::rect(const Rectangle &drawee, const Color &color)
	{
		float verts[12] = {
							setVertex(drawee.getLeft()), drawee.getTop(), 0,
							setVertex(drawee.getLeft()), drawee.getBottom()+1, 0,
							setVertex(drawee.getRight()+1), drawee.getBottom()+1, 0,
							setVertex(drawee.getRight()+1), drawee.getTop(), 0
		                 };
		glVertexPointer(3, GL_FLOAT, 0, verts);

		APIsetColor(color);
//		glColor4f(color.getR(), color.getG(), color.getB(), color.getA());
		glDrawArrays(GL_QUADS,0,4);
		return *this;
	}

	CanvasBits& CanvasBits::rect(const Rectangle &drawee, const Stroke &strk)
	{
		float verts[12] = {
							setVertex(drawee.getLeft()), drawee.getTop(), 0,
							setVertex(drawee.getLeft()), drawee.getBottom()+1, 0,
							setVertex(drawee.getRight()+1), drawee.getBottom()+1, 0,
							setVertex(drawee.getRight()+1), drawee.getTop(), 0
		                 };
		glVertexPointer(3, GL_FLOAT, 0, verts);

		APIsetColor(strk.color);
		glDrawArrays(GL_LINE_LOOP,0,4);
		return *this;
	}


	CanvasBits& CanvasBits::image(const Image &img) {
		drawImage(img, img.targetarea_.getLeft(), img.targetarea_.getTop());
		return *this;
	}
	CanvasBits& CanvasBits::image(const Image &img, const double left, const double top) {
		drawImage(img, left, top);
		return *this;
	}

	void CanvasBits::drawImage(const Image &img, const double left, const double top) {
		//int left = Math::round(left__);
		//int top = Math::round(top__);
		if(img.caches.count(this)==0) {
			//img.cache(*this);
		}

		if(img.caches.count(this)!=0) {
			APIImageCache *api_ = img.caches[this].id;
			double tex_top = 1.0;
			double tex_bottom = ((double)api_->tex_height-img.height_)/api_->tex_height;

			glUseProgram(0);
			glColor4f(1.0,1.0,1.0,1.0);
			glEnable(GL_TEXTURE_2D);
			glBindTexture(GL_TEXTURE_2D, api_->getTexIndex());
			glBegin(GL_QUADS);

				glTexCoord2d(0, tex_top);
					glVertex2f(left, top);
				glTexCoord2d((double)img.width_/api_->tex_width , tex_top);
					glVertex2f(left+img.targetarea_.getWidth(), top);
				glTexCoord2d((double)img.width_/api_->tex_width , tex_bottom);
					glVertex2f(left+img.targetarea_.getWidth(), top+img.targetarea_.getHeight());
				glTexCoord2d(0 , tex_bottom);
					glVertex2f(left, top+img.targetarea_.getHeight());

			glEnd();
			glDisable(GL_TEXTURE_2D);
			glUseProgram(shader.gl2Program);
		} else {
			glRasterPos2d(left,img.height_+top);
			if( img.pixcomp_==Image::RGBA ) {
				glPushAttrib(GL_ALL_ATTRIB_BITS);
				glEnable(GL_BLEND);
				glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
				glDrawPixels((GLsizei)img.getWidth(), (GLsizei)img.getHeight(), APIImageProperties::PixCompGL_[img.pixcomp_], APIImageProperties::PixPrecGL_[img.pixprec_], img.getBitmapPtr());
				glDisable(GL_BLEND);
				glPopAttrib();
			} else {
				glDrawPixels((GLsizei)img.getWidth(), (GLsizei)img.getHeight(), APIImageProperties::PixCompGL_[img.pixcomp_], APIImageProperties::PixPrecGL_[img.pixprec_], img.getBitmapPtr());
			}
		}
	}
/*
	void CanvasBits::drawImage(Image &img, const Rectangle &target_area)
	{
		if(img.caches.count(this)==0) {
			img.cache(*this);
		}
		APIImageCache *api_ = img.caches[this].id;
		double tex_top = 1.0;
		double tex_bottom = ((double)api_->tex_height-img.height_)/api_->tex_height;

		glColor4f(1.0,1.0,1.0,1.0);
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, api_->getTexIndex());
		glBegin(GL_QUADS);
			glTexCoord2d(0, tex_top);
				glVertex2f(target_area.left, target_area.top);
			glTexCoord2d((double)img.width_/api_->tex_width , tex_top);
				glVertex2f(target_area.right, target_area.top);
			glTexCoord2d((double)img.width_/api_->tex_width , tex_bottom);
				glVertex2f(target_area.right, target_area.bottom);
			glTexCoord2d(0 , tex_bottom);
				glVertex2f(target_area.left, target_area.bottom);

		glEnd();
		glDisable(GL_TEXTURE_2D);
	}

	CanvasBits& CanvasBits::image(Image &img, const Rectangle &target_area, const Rectangle &source_rect)
	{
		if(img.caches.count(this)==0) {
			img.cache(*this);
		}
		APIImageCache *api_ = img.caches[this].id;
//		double right = left + source_rect.getWidth();
//		double bottom = top + source_rect.getHeight();
		double tex_top = 1.0;
		double tex_bottom = ((double)api_->tex_height-img.height_)/api_->tex_height;
		double tex_left = 0.0;
		double tex_right = (double)img.width_/api_->tex_width;
		double tex_height = tex_top - tex_bottom;
		double tex_width  = tex_right - tex_left;
		tex_left = tex_width * source_rect.getLeft() / (img.getWidth()-1.0);
		tex_top = 1.0 - tex_height * source_rect.getTop() / (img.getHeight()-1.0);
		tex_right = tex_width * source_rect.getRight() / (img.getWidth()-1.0);
		tex_bottom = 1.0 - tex_height * source_rect.getBottom() / (img.getHeight()-1.0);
//std::cout << "D   " << tex_left << " " << tex_top << " " << tex_right << " " << tex_bottom << std::endl;

		glColor4f(1.0,1.0,1.0,1.0);
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, api_->getTexIndex());
		glBegin(GL_QUADS);

		glTexCoord2d(tex_left, tex_top);
//		glVertex2f(left, top);
		glVertex2f(target_area.left, target_area.top);

		glTexCoord2d(tex_right, tex_top);
//		glVertex2f(right, top);
		glVertex2f(target_area.right+1, target_area.top);

		glTexCoord2d(tex_right , tex_bottom);
//		glVertex2f(right, bottom);
		glVertex2f(target_area.right+1, target_area.bottom+1);

		glTexCoord2d(tex_left , tex_bottom);
//		glVertex2f(left, bottom);
		glVertex2f(target_area.left, target_area.bottom+1);


		glEnd();
		glDisable(GL_TEXTURE_2D);
		return *this;
	}
*/

	void CanvasBits::cacheImageBody(Image &img) {
		APIImageCache *api_ = 0;
		int tex_width = 0, tex_height = 0;

		if(img.caches.count(this)==0) {
			int i;
			i=0;
			while(pow(2.0,++i)<img.width_*2) {}
			tex_width = pow(2.0,i);
			i=0;
			while(pow(2.0,++i)<img.height_) {}
			tex_height = pow(2.0,i);
		} else {
			api_ = img.caches[this].id;
			tex_width = api_->tex_width;
			tex_height = api_->tex_height;
		}

		Image *tmp = new Image(tex_width, tex_height, img.pixcomp_, Image::BYTE);
		int ra, hir, lor, hig, log, hib, lob;
		double r, g, b, alpha;
		for(int y=0; y<img.height_; y++) {
			for(int x=0; x<img.width_; x++) {
				img.getPix(x,y).get(r, g, b, alpha);
				ra = (int)(r * 65535);
				hir = (ra & 0xff00) >> 8;
				lor = (ra & 0xff);
				ra = (int)(g * 65535);
				hig = (ra & 0xff00) >> 8;
				log = (ra & 0xff);
				ra = (int)(b * 65535);
				hib = (ra & 0xff00) >> 8;
				lob = (ra & 0xff);
				tmp->pix(x*2  ,y, Color(hir/255.0, hig/255.0, hib/255.0, alpha));
				tmp->pix(x*2+1,y, Color(lor/255.0, log/255.0, lob/255.0, alpha));
			}
		}

		if(img.caches.count(this)!=0) {
			glEnable(GL_TEXTURE_2D);
			glBindTexture(GL_TEXTURE_2D, api_->VRAMoffset);
			glTexSubImage2D(GL_TEXTURE_2D, 0, 0, 0, api_->tex_width, api_->tex_height, APIImageProperties::PixCompGL_[img.pixcomp_], APIImageProperties::PixPrecGL_[Image::BYTE], tmp->getBitmapPtr());
			glDisable(GL_TEXTURE_2D);
		} else {
			api_ = new APIImageCache;
			img.caches.insert(std::pair<DrawableWithCache*, ImageCache_>(this, ImageCache_(api_, false)));
			api_->tex_width = tex_width;
			api_->tex_height = tex_height;
			glEnable(GL_TEXTURE_2D);
			glGenTextures(1, &api_->VRAMoffset);
			glBindTexture(GL_TEXTURE_2D, api_->VRAMoffset);
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
			glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
//				glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
//				glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
			glTexImage2D(GL_TEXTURE_2D, 0, Image::PixCompSize_[img.pixcomp_], api_->tex_width, api_->tex_height, 0, APIImageProperties::PixCompGL_[img.pixcomp_], APIImageProperties::PixPrecGL_[Image::BYTE], tmp->getBitmapPtr());
			glDisable(GL_TEXTURE_2D);

//				APIImageProperties::regist((int)Display::getWidth(), (int)Display::getHeight(), width_, height_, VRAMleft_, VRAMtop_);
//				glDisable(GL_BLEND);
//				glDrawBuffer(GL_AUX1);
//				for(int y=0; y<height_; y++) {
//					for(int x=0; x<width_; x++) {
//						Display::pix(x+VRAMleft_, y+VRAMtop_, getPix(x, y));
//					}
//				}
//				glDrawBuffer(GL_BACK);
//				glEnable(GL_BLEND);

		}
		glDrawBuffer(GL_AUX1);
		glColor4f(1.0,1.0,1.0,1.0);
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, api_->getTexIndex());
		glBegin(GL_QUADS);
			glTexCoord2d(0 , img.height_);
				glVertex2f(img.targetarea_.getLeft() , img.targetarea_.getTop());
			glTexCoord2d(img.width_ , img.height_);
				glVertex2f(img.targetarea_.getRight()+1, img.targetarea_.getTop());
			glTexCoord2d(img.width_ , 0);
				glVertex2f(img.targetarea_.getRight()+1, img.targetarea_.getBottom()+1);
			glTexCoord2d(0, 0);
				glVertex2f(img.targetarea_.getLeft() , img.targetarea_.getBottom()+1);
		glEnd();
		glDisable(GL_TEXTURE_2D);
		glDrawBuffer(GL_BACK);
		delete tmp;
	}




}


}	/*	<- namespace Psycholops 	*/


