/*
 *  psychlops_g_font.cpp
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2005/09/25 by Kenchi HOSOKAWA
 *  (C) 2005 Kenchi HOSOKAWA, Kazushi MARUYA, Takao SATO
 */

#include <Math.h>

#include <string>
#include <iostream>
#include <sstream>

#define PSYCHLOPS_WINDOW_API_PLATFORM
#include "../../platform/psychlops_platform_selector.h"

#include "psychlops_g_font.h"
#include "psychlops_g_canvas.h"
#include "psychlops_g_image.h"


#include "../../extension/standard/widgets/psychlops_widgets.h"



namespace Psychlops {

	/*
	 Font::~Font() {}
	 double Font::getWidthOf(char * str) {
	 return getWidthOf(std::string(str));
	 }
	 */

	Font::Font() {}
	Font::Font(double size_, int weight_, Style style_, std::wstring family_) : size(size_), weight(weight_), style(style_) {
		family.push_back(family_!=L"default" ? family_ : default_font.family.at(0));
	}
	Font::Font(std::wstring family_, double size_, int weight_, Style style_) : size(size_), weight(weight_), style(style_) {
		family.push_back(family_!=L"default" ? family_ : default_font.family.at(0));
	}
	Font::Font(const wchar_t* family_, double size_, int weight_, Style style_) : size(size_), weight(weight_), style(style_) {
		family.push_back(wcsncmp(family_, L"default", 7) ? std::wstring(family_) : default_font.family.at(0));
	}
	Font::~Font() {
	}
	Font& Font::set(double size_, int weight_, Style style_, std::wstring family_)
	{
		size = size_;
		weight = weight_;
		style = style_;
		if(family_.length()!=0) family.push_back(family_!=L"default" ? family_ : default_font.family.at(0));
		return *this;
	}
	Font& Font::set(std::wstring family_, double size_, int weight_, Style style_)
	{
		size = size_;
		weight = weight_;
		style = style_;
		if(family_.length()!=0) family.push_back(family_!=L"default" ? family_ : default_font.family.at(0));
		return *this;
	}
	Font& Font::set(const wchar_t* family_, double size_, int weight_, Style style_)
	{
		size = size_;
		weight = weight_;
		style = style_;
		if(family_!=L"") family.push_back(family_!=L"default" ? std::wstring(family_) : default_font.family.at(0));
		return *this;
	}


	extern std::wstring LocalEncodingtoWCHAR(const char*);
	extern std::wstring LocalEncodingtoWCHAR(const char*, int);

	Letters::Cache::Cache() : id(0), dirty(false) {}
	Letters::Cache::Cache(APIFontProperties* id__, bool dirty__) : id(id__), dirty(dirty__) {}

	Letters::Letters()
	: str(), font(Font::default_font), width_(0), height_(0), vertical_align(BASELINE)
	{
	}
	Letters::Letters(const char *init_str, const Font& init_font)
	: font(init_font), width_(0), height_(0), vertical_align(BASELINE)
	{
		str = LocalEncodingtoWCHAR(init_str);
		cache();
	}
	Letters::Letters(const char *init_str, int size_, const Font& init_font)
	: font(init_font), width_(0), height_(0), vertical_align(BASELINE)
	{
		str = LocalEncodingtoWCHAR(init_str, size_);
		cache();
	}
	Letters::Letters(const std::wstring &init_str, const Font& init_font)
	: str(init_str), font(init_font), width_(0), height_(0), vertical_align(BASELINE)
	{
		cache();
	}
	//	Letters::Letters(const std::wstring init_str, const Font& init_font, Canvas &cnvs) : str(init_str), font(init_font) {
	//		cnvs.loadLetters(init_str, init_font);
	//	}
	Letters::~Letters() {
		if(!caches.empty()) {
			std::vector<DrawableWithCache*> tmp;
			for(CacheID::iterator i=caches.begin(); i!=caches.end(); i++) tmp.push_back(i->first);
			for(int i=0; i<tmp.size(); i++) tmp[i]->uncacheLetters(*this);
		}
	}
	Font& Letters::getFont() {
		return font;
	}
	std::wstring& Letters::getString() {
		return str;
	}
	Letters& Letters::setFont(const Font &init_font) {
		font = init_font;
		cache();
		return *this;
	}
	Letters& Letters::setString(const char *init_str) {
		str = LocalEncodingtoWCHAR(init_str);
		cache();
		return *this;
	};
	Letters& Letters::setString(const char *init_str, int size_) {
		str = LocalEncodingtoWCHAR(init_str, size_);
		cache();
		return *this;
	};
	Letters& Letters::setString(const std::wstring &init_str) {
		str.assign(init_str);
		cache();
		return *this;
	};
		Letters& Letters::string(const char *init_str) {
			str = LocalEncodingtoWCHAR(init_str);
			cache();
			return *this;
		};
		Letters& Letters::string(const char *init_str, int size_) {
			str = LocalEncodingtoWCHAR(init_str, size_);
			cache();
			return *this;
		};
		Letters& Letters::string(const std::wstring &init_str) {
			str.assign(init_str);
			cache();
			return *this;
		};
	Letters& Letters::operator =(const std::wstring &init_str) {
		return setString(init_str);
	}
	Letters& Letters::cache(DrawableWithCache &target) {
		if(0!=&target) target.cacheLetters(*this);
		return *this;
	}
	Letters& Letters::uncache(DrawableWithCache &target) {
		if(0!=&target) target.uncacheLetters(*this);
		return *this;
	}
	Letters& Letters::centering(const Point& p) {
		align = TEXT_ALIGN_CENTER;
		vertical_align = TEXT_ALIGN_MIDDLE;
		FigureDatum::centering(p);
		return *this;
	}
	Letters& Letters::centering(const Point& p, bool realign_flag) {
		if(realign_flag) align = TEXT_ALIGN_CENTER;
		vertical_align = TEXT_ALIGN_MIDDLE;
		FigureDatum::centering(p);
		return *this;
	}
	Letters& Letters::locate(const Point& p) {
		FigureDatum::setDatum(p);
		vertical_align = BASELINE;
		return *this;
	}
	Letters& Letters::locate(double x, double y, double z) {
		FigureDatum::setDatum(Point(x,y,z));
		vertical_align = BASELINE;
		return *this;
	}
	Letters& Letters::centering(const Figure& fig) { centering(fig.getDatum()); return *this; }
	Letters& Letters::centering(const Drawable &target) { centering(target.getCenter()); return *this; }
	Letters& Letters::centering(const double x, const double y, const double z) { centering(Point(x,y,z)); return *this; }
	Letters& Letters::shift(const double x, const double y, const double z) { Point n=getDatum(); n=n+Point(x,y,z); setDatum(n); return *this; }

	Letters& Letters::draw(Drawable &target) {
		Shape::draw_base(target);
		return *this;
	}
	Letters& Letters::draw(const Color &col, Drawable &target) {
		target.letters(*this, col);
		return *this;
	}
	Letters& Letters::draw(const Stroke &strk, Drawable &target) {
		target.letters(*this, strk.color);
		return *this;
	}
	Letters& Letters::draw(const Color &col, HorizontalAlign horiz_align, Drawable &target) {
		//		HorizontalAlign halign = (horiz_align==NOT_SPECIFIED ? align : horiz_align);
		HorizontalAlign t_align = align;
		align = horiz_align;
		target.letters(*this, col);
		align = t_align;
		return *this;
	}


	bool Font::initialized = false;
	Image *Font::font_minimum = 0;
	const size_t Font::font_minimum_proportion[ASCII_NUM] = {
	5,5,5,5,5,5,5,5,5,15,5,5,5,5,5,5,
	5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
	7,5,7,7,7,7,7,5,5,5,7,7,5,5,5,5, //  !"#$%&'()*+,-./
	7,7,7,7,7,7,7,7,7,7,5,5,5,5,5,7, // 0123456789:;<=>?
	7,7,7,7,7,7,7,7,7,5,5,7,7,9,7,7, // @ABCDEFGHIJKLMNO
	7,7,7,7,7,7,7,9,7,7,7,5,5,5,5,5, // PQRSTUVWXYZ[\]^_
	5,7,7,6,7,7,6,7,7,5,5,7,5,9,7,7, // `abcdefghijklmno
	7,7,6,7,5,7,7,9,7,7,7,5,5,5,7,5, // pqrstuvwxyz{|}~
	/*
	 4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
	 4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
	 6,4,6,6,6,6,6,4,4,4,6,6,4,4,4,4, //  !"#$%&'()*+,-./
	 6,6,6,6,6,6,6,6,6,6,4,4,4,4,4,6, // 0123456789:;<=>?
	 6,6,6,6,6,6,6,6,6,4,4,6,6,8,6,6, // @ABCDEFGHIJKLMNO
	 6,6,6,6,6,6,6,8,6,6,6,4,4,4,4,4, // PQRSTUVWXYZ[\]^_
	 4,6,6,5,6,6,5,6,6,4,4,6,4,8,6,6, // `abcdefghijklmno
	 6,6,5,6,4,6,6,8,6,6,6,4,4,4,6,4, // pqrstuvwxyz{|}~
	 */
	};
	void Font::initializeFontMinimum() {
		const unsigned char font_minimum_GEN[ASCII_NUM][7] = {
			{0,0,96,96,0,0,0},{0,0,96,96,0,0,0},{0,0,96,96,0,0,0},{0,0,96,96,0,0,0},
			{0,0,96,96,0,0,0},{0,0,96,96,0,0,0},{0,0,96,96,0,0,0},{0,0,96,96,0,0,0},
			{0,0,96,96,0,0,0},{0,0, 0, 0,0,0,0},{0,0,96,96,0,0,0},{0,0,96,96,0,0,0},
			{0,0,96,96,0,0,0},{0,0,96,96,0,0,0},{0,0,96,96,0,0,0},{0,0,96,96,0,0,0},
			{0,0,96,96,0,0,0},{0,0,96,96,0,0,0},{0,0,96,96,0,0,0},{0,0,96,96,0,0,0},
			{0,0,96,96,0,0,0},{0,0,96,96,0,0,0},{0,0,96,96,0,0,0},{0,0,96,96,0,0,0},
			{0,0,96,96,0,0,0},{0,0,96,96,0,0,0},{0,0,96,96,0,0,0},{0,0,96,96,0,0,0},
			{0,0,96,96,0,0,0},{0,0,96,96,0,0,0},{0,0,96,96,0,0,0},{0,0,96,96,0,0,0},

			{0,0,0,0,0,0,0}, // SPC
			{96,96,96,0,96,96,0}, // !
			{108,108,0,0,0,0,0}, // "
			{0,108,252,108,252,108,0}, // #
			{16,124,208,120,20,248,16}, // $
			{0,204,24,48,96,204,0}, // %
			{120,196,120,200,220,124,0}, // &
			{48,96,0,0,0,0,0}, // '
			{48,96,96,96,96,48,0}, // (
			{192,96,96,96,96,192,0}, // )
			{0,216,112,112,216,0,0}, // *
			{0,0,48,252,48,0,0}, // +
			{0,0,0,0,0,48,96}, // ,
			{0,0,0,240,0,0,0}, // -
			{0,0,0,0,0,96,0}, // .
			{48,48,96,96,192,192,0}, // /
			{120,204,220,236,204,120,0}, // 0
			{48,112,48,48,48,120,0}, // 1
			{120,204,24,48,96,252,0}, // 2
			{248,12,120,12,12,248,0}, // 3
			{24,56,88,216,252,24,0}, // 4
			{252,192,248,12,12,248,0}, // 5
			{124,192,248,204,204,120,0}, // 6
			{252,12,12,24,48,96,0}, // 7
			{120,204,120,204,204,120,0}, // 8
			{120,204,204,120,24,48,0}, // 9
			{0,0,96,0,96,0,0}, // :
			{0,0,96,0,96,192,0}, // ;
			{48,96,192,192,96,48,0}, // <
			{0,0,240,0,240,0,0}, // =
			{192,96,48,48,96,192,0}, // >
			{124,204,56,48,0,48,0}, // ?
			{120,196,212,218,192,120,0}, // @
			{120,204,204,252,204,204,0}, // A
			{248,204,248,204,204,248,0}, // B
			{124,192,192,192,192,124,0}, // C
			{248,204,204,204,204,248,0}, // D
			{252,192,252,192,192,252,0}, // E
			{252,192,248,192,192,192,0}, // F
			{124,192,192,204,204,124,0}, // G
			{204,204,252,204,204,204,0}, // H
			{240,96,96,96,96,240,0}, // I
			{240,48,48,48,48,224,0}, // J
			{204,204,216,240,216,204,0}, // K
			{192,192,192,192,192,252,0}, // L
			{231,219,219,219,219,219,0}, // M
			{236,236,220,220,220,204,0}, // N
			{120,204,204,204,204,120,0}, // O
			{248,204,204,248,192,192,0}, // P
			{120,204,204,204,220,124,0}, // Q
			{248,204,204,248,208,204,0}, // R
			{124,192,120,12,12,248,0}, // S
			{252,48,48,48,48,48,0}, // T
			{204,204,204,204,204,124,0}, // U
			{204,204,204,204,120,48,0}, // V
			{219,219,219,219,219,127,0}, // W
			{204,104,48,48,88,204,0}, // X
			{204,204,120,48,48,48,0}, // Y
			{252,24,48,96,192,252,0}, // Z
			{112,96,96,96,96,112,0}, // [
			{192,192,96,96,48,48,0}, // ﾂ･
			{224,96,96,96,96,224,0}, // ]
			{96,144,0,0,0,0,0}, // ^
			{0,0,0,0,0,240,0}, // _
			{192,96,0,0,0,0,0}, // `
			{0,120,12,124,204,124,0}, // a
			{192,192,248,204,204,248,0}, // b
			{0,120,192,192,192,120,0}, // c
			{12,12,124,204,204,124,0}, // d
			{0,120,204,252,192,120,0}, // e
			{56,96,248,96,96,96,0}, // f
			{0,120,204,204,124,12,120}, // g
			{192,192,248,204,204,204,0}, // h
			{96,0,96,96,96,96,0}, // i
			{96,0,96,96,96,96,192}, // j
			{192,192,204,216,240,220,0}, // k
			{96,96,96,96,96,32,0}, // l
			{0,255,219,219,219,219,0}, // m
			{0,248,204,204,204,204,0}, // n
			{0,120,204,204,204,120,0}, // o
			{0,248,204,204,248,192,192}, // p
			{0,124,204,204,124,12,12}, // q
			{0,216,240,192,192,192,0}, // r
			{0,124,192,120,12,248,0}, // s
			{96,240,96,96,96,48,0}, // t
			{0,204,204,204,204,124,0}, // u
			{0,204,204,204,120,48,0}, // v
			{0,219,219,219,219,127,0}, // w
			{0,204,104,48,88,204,0}, // x
			{0,204,204,108,24,48,96}, // y
			{0,252,24,48,96,252,0}, // z
			{112,96,192,192,96,112,0}, // {
			{64,64,64,64,64,64,0}, // |
			{224,96,48,48,96,224,0}, // }
			{0,0,108,216,0,0,0}, // ~
			{0,0,0,0,0,0,0} // DEL
		};

		if(!initialized) {
			unsigned char mask = 1;
			font_minimum = new Image[ASCII_NUM];
			for(size_t i=0; i<ASCII_NUM; i++) {
				font_minimum[i].set(font_minimum_proportion[i]-1, 7, Image::RGBA);
				for(int y=0; y<7; y++) {
					mask = 128;
					for(int x=0; x<font_minimum_proportion[i]-1; x++) {
						font_minimum[i].alpha(x,y, (0!=(font_minimum_GEN[i][y] & mask) ? 1.0 : 0.0) );
						mask >>= 1;
					}
				}
			}
			initialized = true;
		}
	}

}	/*	<- namespace Psycholops 	*/


