/*
 *  psychlops_g_PNG_bridge.h
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2006/08/22 by Kenchi HOSOKAWA
 *  (C) 2006- Kenchi HOSOKAWA, Kazushi MARUYA and Takao SATO
 */

#ifndef HEADER_PSYCHLOPS_IMAGE_FORMATS_PNG
#define HEADER_PSYCHLOPS_IMAGE_FORMATS_PNG

#ifndef __cplusplus
#define __cplusplus
#endif

#include <stdio.h>
#include <stdlib.h>
#include "png.h"

#include "../../../core/graphic/psychlops_g_image.h"


namespace Psychlops {
namespace IMAGE_FORMATS {


	const unsigned int PNG_BYTES_TO_CHECK = 4;
	class PNG_BRIDGE : public IMAGE_FORMAT {
		private:
		FILE *fp;
		bool is_opened_;

		// PNG specific
		png_structp png_ptr;
		png_infop   info_ptr, end_info_ptr;
		png_uint_32 i;
		double      file_gamma;


		public:
		PNG_BRIDGE();
		virtual ~PNG_BRIDGE();
		virtual void load(const char *file_name, Image * target);
		virtual void save(const char *file_name, Image * target);

		private:
		void open(const char *file_name, const char *mode);
		void close();
		void check_before_read();
		void read(Image * target);
		void prepare_before_write();
		void write(Image * target);

	};


}
}

#endif
