/*
 *  psychlops_figure_standard.h
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2005/10/05 by Kenchi HOSOKAWA
 *  (C) 2005 Kenchi HOSOKAWA, Kazushi MARUYA, Takao SATO
 */

#ifndef HEADER_PSYCHLOPS_FIGURE_STANDARD
#define HEADER_PSYCHLOPS_FIGURE_STANDARD

#include "../../../core/graphic/psychlops_g_fundamental.h"
#include "../../../psychlops_core.h"
#include "../../../core/ApplicationInterfaces/psychlops_app_thread.h"




namespace Psychlops {
namespace Figures {

	class Arrow : virtual public Line
	{
	private:
		static Polygon default_head;
		void createDefaultHead();
		void setDefaultHead();
	protected:
		Group gr;
		Polygon* head;
	public:
		Arrow();
		Arrow(const double x1, const double y1, const double x2, const double y2);
		Arrow(const Point &dbegin, const Point &dend);
		Arrow& set(const double x1, const double y1, const double x2, const double y2);
		Arrow& set(const Point &dbegin, const Point &dend);
		virtual Arrow& draw(Drawable &target = *Drawable::prime);
		virtual Arrow& draw(const Color &col, Drawable &target = *Drawable::prime);
		virtual Arrow& draw(const Stroke &strk, Drawable &target = *Drawable::prime);
	};


	class Cross : virtual public Shape, virtual public FigureDatum
	{
	public:
		//using FigureDatum::datum; using FigureDatum::shift;
		//using Shape::centering;

		double width, height;

		Cross();
		Cross(const Rectangle& rect, Stroke dstrk = Stroke::hair_line);
		Cross(double wid, double hei, Stroke dstrk = Stroke::hair_line);
		virtual ~Cross();
		Cross& set(const Rectangle& rect, Stroke dstrk = Stroke::hair_line);
		Cross& set(double wid, double hei, Stroke dstrk = Stroke::hair_line);
		virtual Cross& centering();
		virtual Cross& centering(const Point &p);
		virtual Cross& draw(Drawable &target = *Drawable::prime);
		virtual Cross& draw(const Color &col, Drawable &target = *Drawable::prime);
		virtual Cross& draw(const Stroke &strk, Drawable &target = *Drawable::prime);
	};


	class Movie : public FigureDatum
	{
		protected:
		int current_frame;
		std::deque<Image*> frame;

		public:
		static std::string bin_path;
		Rectangle source;

		Movie();
		virtual ~Movie();

		Movie &clear();
		Movie &set(Image* frames, int frame_num);
		Movie &setFrameNumber(int frame_num);
		int getCurrentFrame();
		int setCurrentFrame(int new_current);
		Image& operator[](int frame_num);

		virtual Movie & draw(Drawable& target = *Drawable::prime);

		virtual Movie& capture();
		virtual Movie& capture(const Rectangle &source_area_);
		virtual Movie& capture(int target_frame);
		virtual Movie& capture(const Rectangle &source_area_, int target_frame);
		virtual const Movie& save(std::string filename);
		virtual const Movie& saveEachFrames(std::string filename);

	};

	class ProgressBar : public FigureDatum
	{
		private:
		Rectangle frame_, bar_;
		double ratio;

		public:
		Color fgcolor, bgcolor;
		ProgressBar(const Rectangle &rect);
		ProgressBar(const double width, const double height);
		virtual ~ProgressBar();
		ProgressBar & set(Rectangle rect);
		ProgressBar & set(const double width, const double height);
		virtual ProgressBar & draw(Drawable& target = *Drawable::prime);
		virtual ProgressBar & draw(const double x, const double y, const double z = 0, Drawable& target = *Drawable::prime) const;

		ProgressBar & operator()(double ratio);
		ProgressBar & operator()(double now, double max);
	};




}	/*	<- namespace Figure 	*/
}	/*	<- namespace Psycholops 	*/


#endif
