/*
 *  psychlops_math_extension.cpp
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2010/12/14 by Kenchi HOSOKAWA
 *  (C) 2010 Kenchi HOSOKAWA, Kazushi MARUYA and Takao SATO
 */


#include "psychlops_math_extension.h"

namespace Psychlops {
	namespace Euclidean {
		
		double distance(Psychlops::Point p1, Psychlops::Point p2) {
			Psychlops::Point dp = p1 - p2;
			return sqrt(dp.x*dp.x + dp.y*dp.y);
		}
		
		Psychlops::Point interpolate(Psychlops::Point p1, Psychlops::Point p2, double weight_p1) {
			Psychlops::Point dp =  p1 - p2;
			dp.x *= weight_p1;
			dp.y *= weight_p1;
			dp.z *= weight_p1;
			return p1 + dp;
		}
		
		Color interpolate(Color p1, Color p2, double weight_p1) {
			if(p1.getB() + ( p2.getB() - p1.getB() ) * weight_p1 > 1) std::cout << "overflow";
			return Color(
						 p1.getR() + ( p2.getR() - p1.getR() ) * weight_p1,
						 p1.getG() + ( p2.getG() - p1.getG() ) * weight_p1,
						 p1.getB() + ( p2.getB() - p1.getB() ) * weight_p1,
						 p1.getA() + ( p2.getA() - p1.getA() ) * weight_p1
						 );
		}
		
	}	
}	/*	<- namespace Psycholops 	*/
