
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/errno.h>
#include <linux/pci.h>
#include <linux/init.h>
#include <linux/interrupt.h>

#include <asm/system.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/uaccess.h>

#include	"pt1_com.h"
#include	"pt1_pci.h"
#include	"pt1_i2c.h"
#include	"pt1_tuner.h"
#include	"pt1_tuner_data.h"
/***************************************************************************/
/* BSͥơ֥                                                      */
/***************************************************************************/
ISDB_S_CH_TABLE		isdb_t_table[11] ={
	{151, 0, 0},			// 151chBSī
	{161, 0, 1},			// 161chBS-i
	{171, 1, 1},			// 171chBSѥ
	{211, 4, 0},			// 211chBS11ǥ
	{222, 4, 2},			// 222chTwellV
	{141, 6, 0},			// 141chBSƥ
	{181, 6, 1},			// 181chBSե
	{101, 7, 0},			// 101chNHK1(BS1)
	{101, 7, 0},			// 102chNHK2(BS2)
	{103, 7, 1},			// 103chNHKϥӥ(BShi)
	{0, 0, 0}				// 
};

/***************************************************************************/
/* ϥơ֥                                                          */
/***************************************************************************/
/*
ISDB-Sξ
                       C0 C1
:7Bit Address Mode(1b/19):17:00
ISDB-Sξ̵(ޥ)
                       C0 C1
:7Bit Address Mode(1B/19):fe:c0:f0:04
:7Bit Address Mode(1B/19):17:01
*/
WBLOCK	isdb_s_wake = {
	0,
	4,
	{0xFE, 0xC0, 0xF0, 0x04}
};
WBLOCK	isdb_s_sleep = {
	0,
	2,
	{0x17, 0x00}
};
/*
ISDB-Tξ
                       C0 C1
:7Bit Address Mode(1A/18):03:80

ISDB-Tξ̵(ޥ)
                       C0 C1
:7Bit Address Mode(1A/18):fe:c2
:7Bit Address Mode(1A/18):03:90
*/

WBLOCK	isdb_t_wake = {
	0,
	2,
	{0xFE, 0xC2}
};
WBLOCK	isdb_t_sleep = {
	0,
	2,
	{0x03, 0x80}
};

/***************************************************************************/
/* ǡ()                                                  */
/***************************************************************************/
WBLOCK	com_initdata = {
	0,
	2,
	{0x01, 0x80}
};

/***************************************************************************/
/* ǡ(ISDB-S)                                                */
/***************************************************************************/
// ISDB-Sͣ
WBLOCK	isdb_s_init1 ={
	0,
	1,
	{0x07}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init2 ={
	0,
	2,
	{0x04, 0x02}
};

// ISDB-Sͣ
WBLOCK	isdb_s_init3 ={
	0,
	2,
	{0x0D, 0x55}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init4 ={
	0,
	2,
	{0x11, 0x40}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init5 ={
	0,
	2,
	{0x13, 0x80}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init6 ={
	0,
	2,
	{0x17, 0x01}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init7 ={
	0,
	2,
	{0x1C, 0x0A}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init8 ={
	0,
	2,
	{0x1D, 0xAA}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init9 ={
	0,
	2,
	{0x1E, 0x20}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init10 ={
	0,
	2,
	{0x1F, 0x88}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init11 ={
	0,
	2,
	{0x51, 0xB0}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init12 ={
	0,
	2,
	{0x52, 0x89}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init13 ={
	0,
	2,
	{0x53, 0xB3}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init14 ={
	0,
	2,
	{0x5A, 0x2D}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init15 ={
	0,
	2,
	{0x5B, 0xD3}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init16 ={
	0,
	2,
	{0x85, 0x69}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init17 ={
	0,
	2,
	{0x87, 0x04}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init18 ={
	0,
	2,
	{0x8E, 0x02}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init19 ={
	0,
	2,
	{0xA3, 0xF7}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init20 ={
	0,
	2,
	{0xA5, 0xC0}
};
// ISDB-Sͣ
WBLOCK	isdb_s_init21 ={
	0,
	4,
	{0xFE, 0xC0, 0xF0, 0x04}
};
/***************************************************************************/
/* ǡ(ISDB-T)                                                */
/***************************************************************************/
// ISDB-Tͣ
WBLOCK	isdb_t_init1 ={
	0,
	2,
	{0x03, 0x90}
};
// ISDB-Tͣ
WBLOCK	isdb_t_init2 ={
	0,
	2,
	{0x14, 0x8F}
};
// ISDB-Tͣ
WBLOCK	isdb_t_init3 ={
	0,
	2,
	{0x1C, 0x2A}
};
// ISDB-Tͣ
WBLOCK	isdb_t_init4 ={
	0,
	2,
	{0x1D, 0xA8}
};
// ISDB-Tͣ
WBLOCK	isdb_t_init5 ={
	0,
	2,
	{0x1E, 0xA2}
};
// ISDB-Tͣ
WBLOCK	isdb_t_init6 ={
	0,
	2,
	{0x22, 0x83}
};
// ISDB-Tͣ
WBLOCK	isdb_t_init7 ={
	0,
	2,
	{0x31, 0x0D}
};
// ISDB-Tͣ
WBLOCK	isdb_t_init8 ={
	0,
	2,
	{0x32, 0xE0}
};
// ISDB-Tͣ
WBLOCK	isdb_t_init9 ={
	0,
	2,
	{0x39, 0xD3}
};
// ISDB-Tͣ
WBLOCK	isdb_t_init10 ={
	0,
	2,
	{0x3A, 0x00}
};
// ISDB-Tͣ
WBLOCK	isdb_t_init11 ={
	0,
	2,
	{0x5C, 0x40}
};
// ISDB-Tͣ
WBLOCK	isdb_t_init12 ={
	0,
	2,
	{0x5F, 0x80}
};
// ISDB-Tͣ
WBLOCK	isdb_t_init13 ={
	0,
	2,
	{0x75, 0x02}
};
// ISDB-Tͣ
WBLOCK	isdb_t_init14 ={
	0,
	2,
	{0x76, 0x4E}
};
// ISDB-Tͣ
WBLOCK	isdb_t_init15 ={
	0,
	2,
	{0x77, 0x03}
};
// ISDB-Tͣ
WBLOCK	isdb_t_init16 ={
	0,
	2,
	{0xEF, 0x01}
};
// ISDB-Tͣ
WBLOCK	isdb_t_init17 ={
	0,
	7,
	{0xFE, 0xC2, 0x01, 0x8F, 0xC1, 0x80, 0x80}
};

/***************************************************************************/
/* ǡ֥å(ISDB-S)                                        */
/***************************************************************************/
WBLOCK	*isdb_s_initial[MAX_ISDB_S_INIT] =
{
	&isdb_s_init2, &isdb_s_init3, &isdb_s_init4, &isdb_s_init5,
	&isdb_s_init6, &isdb_s_init7, &isdb_s_init8, &isdb_s_init9,
	&isdb_s_init10, &isdb_s_init11, &isdb_s_init12, &isdb_s_init13,
	&isdb_s_init14, &isdb_s_init15, &isdb_s_init16, &isdb_s_init17,
	&isdb_s_init18, &isdb_s_init19, &isdb_s_init20
};
/***************************************************************************/
/* ǡ֥å(ISDB-T)                                        */
/***************************************************************************/
WBLOCK	*isdb_t_initial[MAX_ISDB_T_INIT] =
{
	&isdb_t_init1, &isdb_t_init2, &isdb_t_init3, &isdb_t_init4,
	&isdb_t_init5, &isdb_t_init6, &isdb_t_init7, &isdb_t_init8,
	&isdb_t_init9, &isdb_t_init10, &isdb_t_init11, &isdb_t_init12,
	&isdb_t_init13, &isdb_t_init14, &isdb_t_init15, &isdb_t_init16
};
/***************************************************************************/
/* Ͼǥѥǡ                                                    */
/***************************************************************************/
/***************************************************************************/
/* ȿܥơ֥                                                  */
/* 01:                                                               */
/* 23: ׻                                                          */
/* 45: ɲ÷׻                                                      */
/***************************************************************************/

WBLOCK isdb_t_pll_base = {
	0,
	2,
	{0xFE, 0xC2, 0, 0, 0, 0, 0, 0}
};
/***************************************************************************/
/* ϥǥȿåå                                              */
/***************************************************************************/
WBLOCK	isdb_t_pll_lock = {
	0,
	2,
	{0xFE, 0xC3}
};

WBLOCK	isdb_t_check_tune = {
	0,
	2,
	{0x01, 0x40}
};

WBLOCK	isdb_t_tune_read = {
	0,
	1,
	{0x80}
};
WBLOCK	isdb_t_tmcc_read_1 = {
	0,
	1,
	{0xB2}
};
WBLOCK	isdb_t_tmcc_read_2 = {
	0,
	1,
	{0xB6}
};
/***************************************************************************/
/* ϥǥȿåå                                              */
/***************************************************************************/
WBLOCK	isdb_t_cn_1 = {
	0,
	1,
	{0x8B}
};
WBLOCK	isdb_t_cn_2 = {
	0,
	1,
	{0x8C}
};
WBLOCK	isdb_t_agc1 = {
	0,
	1,
	{0x8D}
};
WBLOCK	isdb_t_agc2 = {
	0,
	1,
	{0x82}
};
WBLOCK	isdb_t_lockedt1 = {
	0,
	1,
	{0x96}
};
WBLOCK	isdb_t_lockedt2 = {
	0,
	1,
	{0xB0}
};
WBLOCK	isdb_t_get_clock = {
	0,
	1,
	{0x86}
};
WBLOCK	isdb_t_get_carrir = {
	0,
	1,
	{0x84}
};

/***************************************************************************/
/* ϥǥѥǡ                                                          */
/***************************************************************************/

/***************************************************************************/
/* £ѥǡ                                                            */
/***************************************************************************/
/***************************************************************************/
/* £Ӽȿåå                                                */
/***************************************************************************/
WBLOCK	bs_pll_lock = {
	0,
	2,
	{0xFE, 0xC1}
};
/***************************************************************************/
/* TMCC                                                                */
/***************************************************************************/
WBLOCK	bs_tmcc_get_1 = {
	0,
	2,
	{0x03, 0x01}
};
WBLOCK	bs_tmcc_get_2 = {
	0,
	1,
	{0xC3}
};
/***************************************************************************/
/* TMCC                                                                */
/***************************************************************************/
WBLOCK	bs_get_slot_ts_id_1 = {
	0,
	1,
	{0xCE}
};
WBLOCK	bs_get_slot_ts_id_2 = {
	0,
	1,
	{0xD2}
};
WBLOCK	bs_get_slot_ts_id_3 = {
	0,
	1,
	{0xD6}
};
WBLOCK	bs_get_slot_ts_id_4 = {
	0,
	1,
	{0xDA}
};
/***************************************************************************/
/* TS-IDå                                                             */
/***************************************************************************/
WBLOCK	bs_set_ts_lock = {
	0,
	3,
	{0x8F, 0x00, 0x00}
};
/***************************************************************************/
/* TS-ID                                                               */
/***************************************************************************/
WBLOCK	bs_get_ts_lock = {
	0,
	1,
	{0xE6}
};
/***************************************************************************/
/* åȼ                                                            */
/***************************************************************************/
WBLOCK	bs_get_slot = {
	0,
	1,
	{0xE8}
};
/***************************************************************************/
/* CN/AGC/MAXAGC                                                       */
/***************************************************************************/
WBLOCK	bs_get_cn = {
	0,
	1,
	{0xBC}
};
WBLOCK	bs_get_agc = {
	0,
	1,
	{0xBD}
};
WBLOCK	bs_get_maxagc = {
	0,
	1,
	{0xBA}
};
/***************************************************************************/
/* åȿ                                                  */
/***************************************************************************/
WBLOCK	bs_get_clock = {
	0,
	1,
	{0xBE}
};
/***************************************************************************/
/* ꥢȿ                                                  */
/***************************************************************************/
WBLOCK	bs_get_carrir = {
	0,
	1,
	{0xBB}
};
/***************************************************************************/
/* ȿơ֥                                                      */
/* £Ӥ˴ؤƤΤߡȤꤢơ֥Ȥ׻ǻнʤ      */
/* ׻ǻФ롣                                                      */
/***************************************************************************/
/***************************************************************************/
/* BS̥ơ֥                                                          */
/***************************************************************************/
WBLOCK	bs_com_step2 = {
	0,
	3,
	{0xFE, 0xC0, 0xE4}
};
/***************************************************************************/
/* BS-1                                                                    */
/***************************************************************************/
WBLOCK	bs_1_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x48, 0x29, 0xE0, 0xD2}
};
WBLOCK	bs_1_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0xD6}
};
/***************************************************************************/
/* BS-3                                                                    */
/***************************************************************************/
WBLOCK	bs_3_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x44, 0x40, 0xE0, 0xE2}
};
WBLOCK	bs_3_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0xE6}
};
/***************************************************************************/
/* BS-5                                                                    */
/***************************************************************************/
WBLOCK	bs_5_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x44, 0x66, 0xE0, 0xE2}
};
WBLOCK	bs_5_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0xE6}
};
/***************************************************************************/
/* BS-7                                                                    */
/***************************************************************************/
WBLOCK	bs_7_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x44, 0x8D, 0xE0, 0x20}
};
WBLOCK	bs_7_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0x24}
};
/***************************************************************************/
/* BS-9                                                                    */
/***************************************************************************/
WBLOCK	bs_9_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x44, 0xB3, 0xE0, 0x20}
};
WBLOCK	bs_9_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0x24}
};
/***************************************************************************/
/* BS-11                                                                   */
/***************************************************************************/
WBLOCK	bs_11_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x44, 0xD9, 0xE0, 0x20}
};
WBLOCK	bs_11_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0x24}
};
/***************************************************************************/
/* BS-13                                                                   */
/***************************************************************************/
WBLOCK	bs_13_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x45, 0x00, 0xE0, 0x20}
};
WBLOCK	bs_13_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0x24}
};
/***************************************************************************/
/* BS-15                                                                   */
/***************************************************************************/
WBLOCK	bs_15_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x45, 0x26, 0xE0, 0x40}
};
WBLOCK	bs_15_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0x44}
};
/***************************************************************************/
/* BS-17                                                                   */
/***************************************************************************/
WBLOCK	bs_17_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x45, 0x73, 0xE0, 0x40}
};
WBLOCK	bs_17_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0X44}
};
/***************************************************************************/
/* BS-19                                                                   */
/***************************************************************************/
WBLOCK	bs_19_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x45, 0x73, 0xE0, 0x40}
};
WBLOCK	bs_19_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0x44}
};
/***************************************************************************/
/* BS-21                                                                   */
/***************************************************************************/
WBLOCK	bs_21_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x45, 0x99, 0xE0, 0x40}
};
WBLOCK	bs_21_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0x44}
};
/***************************************************************************/
/* BS-23                                                                   */
/***************************************************************************/
WBLOCK	bs_23_step1 = {
	0,
	6,
	{0xFE, 0xC0, 0x45, 0xBF, 0xE0, 0x60}
};
WBLOCK	bs_23_step3 = {
	0,
	4,
	{0xFE, 0xC0, 0xF4, 0x64}
};

/***************************************************************************/
/* BS-ȿơ֥                                                       */
/***************************************************************************/
WBLOCK_BS_PLL	bs_pll[MAX_BS_CHANNEL] = {
	{&bs_1_step1, &bs_com_step2, &bs_1_step3},
	{&bs_3_step1, &bs_com_step2, &bs_3_step3},
	{&bs_5_step1, &bs_com_step2, &bs_5_step3},
	{&bs_7_step1, &bs_com_step2, &bs_7_step3},
	{&bs_9_step1, &bs_com_step2, &bs_9_step3},
	{&bs_11_step1, &bs_com_step2, &bs_11_step3},
	{&bs_13_step1, &bs_com_step2, &bs_13_step3},
	{&bs_15_step1, &bs_com_step2, &bs_15_step3},
	{&bs_17_step1, &bs_com_step2, &bs_17_step3},
	{&bs_19_step1, &bs_com_step2, &bs_19_step3},
	{&bs_21_step1, &bs_com_step2, &bs_21_step3},
	{&bs_23_step1, &bs_com_step2, &bs_21_step3}
};
WBLOCK	*bs_get_ts_id[(MAX_BS_TS_ID / 2)] = {
	&bs_get_slot_ts_id_1,
	&bs_get_slot_ts_id_2,
	&bs_get_slot_ts_id_3,
	&bs_get_slot_ts_id_4
};
